/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.editors;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.ui.UiPlugin;
import com.ibm.fmi.ui.editors.ICellEditorElementValidator;
import com.ibm.fmi.ui.providers.HexFieldWrapper;
import com.ibm.fmi.ui.providers.HexRecordWrapper;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.widgets.Item;

public class FieldEditorValidator
implements ICellEditorValidator,
ICellEditorElementValidator {
    private int fieldIndex;

    public FieldEditorValidator(int fieldIndex) {
        this.fieldIndex = fieldIndex;
    }

    public String isValid(Object value) {
        return this.isValid(null, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String isValid(Object element, Object value) {
        if (element != null && element instanceof Item) {
            element = ((Item)element).getData();
        }
        if (element instanceof HexRecordWrapper || element instanceof HexFieldWrapper) {
            char[] a = ((String)value).toCharArray();
            int i = 0;
            while (i < a.length) {
                switch (a[i]) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        break;
                    }
                    default: {
                        return UiPlugin.getString("Editor.error.hex", new Object[]{Character.valueOf(a[i])});
                    }
                }
                ++i;
            }
            return null;
        } else {
            try {
                if (this.fieldIndex >= 0 && element != null && element instanceof Record) {
                    ((Record)element).getDisplayField(this.fieldIndex).validateASCIIchange((String)value);
                    return null;
                }
                if (element != null && element instanceof Field) {
                    ((Field)element).validateASCIIchange((String)value);
                    return null;
                }
                if (element != null && element instanceof DisplayLine) return null;
                UiPlugin.trace(0, this, UiPlugin.getString("Editor.Validator.nullField", new Object[]{element}), null);
                return null;
            }
            catch (FMIConversionException e) {
                UiPlugin.trace(3, this, UiPlugin.getString("Editor.Validator.badValue", new Object[]{value, this.fieldIndex}), e);
                return e.getLocalizedMessage();
            }
            catch (FMIKeyException e) {
                UiPlugin.trace(3, this, UiPlugin.getString("Editor.Validator.badValue", new Object[]{value, this.fieldIndex}), e);
                return e.getLocalizedMessage();
            }
            catch (FMIModelException e) {
                UiPlugin.trace(3, this, UiPlugin.getString("Editor.Validator.badValue", new Object[]{value, this.fieldIndex}), e);
                return e.getLocalizedMessage();
            }
        }
    }
}

