/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.editors;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.shadowline.ShadowLine;
import com.ibm.fmi.ui.UiPlugin;
import com.ibm.fmi.ui.editors.FieldCellEditor;
import com.ibm.fmi.ui.editors.FieldEditorValidator;
import com.ibm.fmi.ui.editors.FileManagerIntegrationEditor;
import com.ibm.fmi.ui.providers.FMICharModeCellModifier;
import com.ibm.fmi.ui.providers.FMICharModeLabelProvider;
import com.ibm.fmi.ui.providers.FMITableModeContentProvider;
import com.ibm.fmi.ui.providers.HexRecordWrapper;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPropertyListener;

public class FMICharTableViewer
implements IPropertyListener {
    private Table table;
    public TableViewer tableViewer;
    public TemplattedData input;
    private FileManagerIntegrationEditor editor;
    protected static final String[] CHAR_MODE_COLUMNS = new String[]{UiPlugin.getString("ICON_TITLE"), UiPlugin.getString("DATA_TITLE")};

    public FMICharTableViewer(Composite parent, TemplattedData input, boolean isHex, boolean isShadow, FileManagerIntegrationEditor editor) {
        this.input = input;
        this.editor = editor;
        this.createTable(parent, isHex, isShadow);
    }

    public void createTable(Composite parent, boolean isHex, boolean isShadow) {
        this.table = new Table(parent, 268501762);
        Font font = JFaceResources.getTextFont();
        this.table.setFont(font);
        GC gc = new GC((Drawable)this.table);
        gc.setFont(font);
        FontMetrics metrics = gc.getFontMetrics();
        gc.dispose();
        this.table.setHeaderVisible(false);
        GridData CAData = new GridData();
        CAData.grabExcessHorizontalSpace = true;
        CAData.grabExcessVerticalSpace = true;
        CAData.horizontalAlignment = 4;
        CAData.verticalAlignment = 4;
        CAData.horizontalSpan = 1;
        this.table.setLayoutData((Object)CAData);
        TableColumn tableColumn0 = new TableColumn(this.table, 0);
        tableColumn0.setWidth(40);
        tableColumn0.setResizable(false);
        int c = 1;
        while (c < CHAR_MODE_COLUMNS.length) {
            TableColumn tableColumn = new TableColumn(this.table, 16384);
            tableColumn.setWidth(12 + metrics.getAverageCharWidth() * this.input.getCurLayout().getEbcdicWidth());
            ++c;
        }
        this.createTableViewer(isHex, isShadow);
    }

    private void createTableViewer(boolean isHex, boolean isShadow) {
        this.tableViewer = new TableViewer(this.table);
        if (!this.editor.readOnly()) {
            CellEditor[] cellEditors = new CellEditor[CHAR_MODE_COLUMNS.length];
            FieldCellEditor textEditor = new FieldCellEditor(this.tableViewer, 16384, 1);
            textEditor.getText().setTextLimit(this.input.getCurLayout().getEbcdicWidth());
            textEditor.setValidator(new FieldEditorValidator(-1));
            cellEditors[0] = textEditor;
            cellEditors[1] = textEditor;
            this.tableViewer.setCellModifier((ICellModifier)new FMICharModeCellModifier());
            this.tableViewer.setColumnProperties(CHAR_MODE_COLUMNS);
            this.tableViewer.setCellEditors(cellEditors);
        }
        FMITableModeContentProvider cp = new FMITableModeContentProvider();
        cp.setHex(isHex);
        cp.setShadow(isShadow);
        this.tableViewer.setContentProvider((IContentProvider)cp);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new FMICharModeLabelProvider());
        this.tableViewer.setInput((Object)this.input);
    }

    public Table getTable() {
        return this.table;
    }

    Listener getTableListener() {
        return new Listener(){
            protected TableItem oldItem = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: {
                        TableItem item = FMICharTableViewer.this.tableViewer.getTable().getItem(new Point(event.x, event.y));
                        if (item == this.oldItem) break;
                        this.oldItem = item;
                        if (item != null && item.getImage() != null) {
                            Object isel = item.getData();
                            FMICharTableViewer.this.tableViewer.getTable().setToolTipText(this.getLabelFor(isel));
                            break;
                        }
                        FMICharTableViewer.this.tableViewer.getTable().setToolTipText(null);
                    }
                }
            }

            private String getLabelFor(Object isel) {
                String label = null;
                if (isel instanceof ShadowLine) {
                    String type = ((ShadowLine)isel).getMessage(((ShadowLine)isel).getNumRecords());
                    label = UiPlugin.getString("Editor.hidden", new Object[]{type});
                } else {
                    label = "Duplicate Keys found!";
                }
                return label;
            }
        };
    }

    public TableViewer getTableViewerC() {
        return this.tableViewer;
    }

    public void propertyChanged(Object source, int propId) {
        FileManagerIntegrationEditor editor = (FileManagerIntegrationEditor)((Object)source);
        if (2049 == propId && source instanceof FileManagerIntegrationEditor) {
            Object obj = ((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
            if (obj instanceof HexRecordWrapper) {
                obj = ((HexRecordWrapper)obj).getRecord();
            }
            FMITableModeContentProvider cp = (FMITableModeContentProvider)this.tableViewer.getContentProvider();
            cp.setHex(editor.isHexMode());
            if (obj != null) {
                this.tableViewer.getTable().setSelection(cp.getIndexOf((DisplayLine)obj));
            }
        } else if (2051 == propId && source instanceof FileManagerIntegrationEditor) {
            FMITableModeContentProvider cp = (FMITableModeContentProvider)this.tableViewer.getContentProvider();
            cp.setShadow(editor.isShadowMode());
        }
    }
}

