/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.action;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.RecordLayout;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.event.IFMIModelListener;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.shadowline.SuppressedSet;
import com.ibm.fmi.ui.action.EditorAction;
import com.ibm.fmi.ui.editors.FileManagerIntegrationEditor;
import com.ibm.fmi.ui.providers.HexRecordWrapper;
import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;

public class SuppressedActions
extends EditorAction {
    private DisplayLine line;
    private FileManagerIntegrationEditor editor;

    public SuppressedActions(FileManagerIntegrationEditor editor, String action) {
        super(action);
        this.editor = editor;
    }

    public void run() {
        Iterator it = this.getStructuredSelection().iterator();
        if (!it.hasNext()) {
            return;
        }
        Object recordType = it.next();
        DisplayLine line = (DisplayLine)recordType;
        TemplattedData input = (TemplattedData)line.getParent();
        if (line instanceof SuppressedSet) {
            RecordLayout newLayout = line.getLayout();
            input.removeModelListenerAllLevels((IFMIModelListener)this.editor);
            try {
                input.changeLayout(newLayout);
                input.addModelListenerAllLevels((IFMIModelListener)this.editor);
            }
            catch (FMIModelException e) {
                e.printStackTrace();
            }
        }
        int page = this.editor.getActivePage();
        this.editor.removePage(1);
        this.editor.removePage(0);
        this.editor.createPage0(input);
        this.editor.createPage1();
        this.editor.setActivePage(page);
    }

    public void setFocus() {
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Iterator it = this.getStructuredSelection().iterator();
        if (!it.hasNext()) {
            return false;
        }
        Object obj = it.next();
        if (obj instanceof DisplayLine) {
            this.line = (DisplayLine)obj;
        } else if (obj instanceof HexRecordWrapper) {
            this.line = ((HexRecordWrapper)obj).getRecord();
        }
        return this.line instanceof SuppressedSet;
    }
}

