/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.action;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.FMIResourceIterator;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.event.FMIResource;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.ui.UiPlugin;
import com.ibm.fmi.ui.action.CopyActions;
import com.ibm.fmi.ui.action.EditorAction;
import com.ibm.fmi.ui.providers.HexRecordWrapper;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;

public class PasteActions
extends EditorAction
implements ISelectionChangedListener {
    public Clipboard clipboard;
    public Object[] value;

    public PasteActions(String text) {
        super(text);
    }

    public void run() {
        this.updateSelection(this.getStructuredSelection());
        int size = this.value.length;
        if (this.value != null) {
            int index = 0;
            Iterator it = this.getStructuredSelection().iterator();
            Object obj = it.next();
            DisplayLine dLine = null;
            if (obj instanceof DisplayLine) {
                dLine = (DisplayLine)obj;
            } else if (obj instanceof HexRecordWrapper) {
                dLine = ((HexRecordWrapper)obj).getRecord();
            }
            TemplattedData input = (TemplattedData)dLine.getParent();
            FMIResourceIterator dlIter = input.getDisplayLineIterator();
            index = dlIter.indexOf((FMIResource)dLine);
            int i = 0;
            while (i < size) {
                if (this.value[i] instanceof DisplayLine) {
                    try {
                        input.addDisplayLine(index + i + 1, (DisplayLine)this.value[i], false);
                    }
                    catch (FMIConversionException e) {
                        UiPlugin.trace(0, (Object)this, UiPlugin.getString("error.copy.invalid"), e);
                    }
                    catch (FMIParseException e) {
                        UiPlugin.trace(0, (Object)this, UiPlugin.getString("error.copy.invalid"), e);
                    }
                    catch (FMIKeyException e) {
                        UiPlugin.trace(0, (Object)this, UiPlugin.getString("error.paste.keyException"), e);
                        e.printStackTrace();
                    }
                    catch (FMIModelException e) {
                        UiPlugin.trace(0, (Object)this, UiPlugin.getString("error.copy.invalid"), e);
                    }
                }
                ++i;
            }
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this.value = CopyActions.getcopyBuffer();
        return this.value != null;
    }
}

