/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.action;

import com.ibm.fmi.model.FMIResourceIterator;
import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.shadowline.ExcludedSet;
import com.ibm.fmi.ui.UiPlugin;
import com.ibm.fmi.ui.action.EditorAction;
import com.ibm.fmi.ui.editors.FileManagerIntegrationEditor;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class IncludeAction
extends EditorAction {
    protected FileManagerIntegrationEditor editor;

    public IncludeAction(String text, FileManagerIntegrationEditor editor) {
        super(text);
        this.editor = editor;
    }

    public void run() {
        Object[] selected;
        Shell shell = Display.getDefault().getActiveShell();
        Vector<Record> records = new Vector<Record>();
        List list = this.editor.getStructuredSelection().toList();
        for (Object line : list) {
            if (!(line instanceof ExcludedSet)) continue;
            ExcludedSet es = (ExcludedSet)line;
            FMIResourceIterator ri = es.getRecordIterator();
            while (ri.hasNext()) {
                records.add((Record)ri.next());
            }
        }
        if (records.isEmpty()) {
            return;
        }
        ListSelectionDialog selectDialog = new ListSelectionDialog(shell, records, new IStructuredContentProvider(){
            Vector records;

            public Object[] getElements(Object arg0) {
                if (this.records == null) {
                    return null;
                }
                return this.records.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
                this.records = (Vector)arg2;
            }
        }, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Record) {
                    Record rec = (Record)element;
                    String ret = "";
                    Field[] fieldArray = rec.getDisplayFields();
                    int n = 0;
                    int n2 = fieldArray.length;
                    while (n < n2) {
                        Field field = fieldArray[n];
                        if (!field.isEmpty()) {
                            String ascii = field.getAsciiStr();
                            int i = ascii.length();
                            while (i < field.getMaxAsciiWidth()) {
                                ascii = String.valueOf(ascii) + " ";
                                ++i;
                            }
                            ret = String.valueOf(ret) + ascii + " ";
                        }
                        ++n;
                    }
                    return ret;
                }
                return super.getText(element);
            }
        }, UiPlugin.getString("Dialog.excluded.msg"));
        selectDialog.open();
        Object[] objectArray = selected = selectDialog.getResult();
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object record = objectArray[n];
            try {
                this.editor.getActiveModel().makeRecordVisible((Record)record);
            }
            catch (FMIModelException e) {
                UiPlugin.trace(0, (Object)this, UiPlugin.getString("error.include"), e);
            }
            ++n;
        }
        selectDialog.close();
        this.editor.deselectAll();
    }

    public boolean updateSelection(IStructuredSelection selection) {
        for (Object line : this.getStructuredSelection().toList()) {
            if (!(line instanceof ExcludedSet)) continue;
            return true;
        }
        return false;
    }
}

