/* API header Inference Engine ***************************************/
/*                                                                   */
/*   IBM Fault Analyzer                                              */
/*                                                                   */
/*   IBM Confidential    OCO Source Materials                        */
/*                                                                   */
/*   5655-R46                                                        */
/*   (C) Copyright IBM Corp. 2000, 2006. All rights reserved.        */
/*                                                                   */
/*   The source code for this program is not published or otherwise  */
/*   divested of its trade secrets, irrespective of what has been    */
/*   deposited with the U.S. Copyright Office.                       */
/*                                                                   */
/****************************************************************************************************************/
/*|:h3.IDIEH.H                                                       */
/*|    IDIEH.H $$prereqs IDIKH.H IDIIH.H IDIXH.H                     */

#include <stdarg.h>
#include <stdio.h>

#define NLST(a) a

#define  MAX_SRCLEN            1024
/*********************************************************************/
/*   API Structure forward declarations                              */
/*********************************************************************/
struct FAILRSN;
typedef struct FAILRSN FAILRSN;

struct SLINE;
typedef struct SLINE SLINE;

struct RELSEQ;
typedef struct RELSEQ RELSEQ;

struct CIBKEY;
typedef struct CIBKEY CIBKEY;

struct PLIPCB ;
typedef  struct PLIPCB PLIPCB ;

struct SYMBOL;
typedef struct SYMBOL SYMBOL;

struct COB_SYM;
typedef struct COB_SYM COB_SYM;

struct PLI_SYM;
typedef struct PLI_SYM PLI_SYM;

struct ASM_SYM;
typedef struct ASM_SYM ASM_SYM;

struct DSC_ARRAY_V1 ;
typedef struct DSC_ARRAY_V1 DSC_ARRAY_V1 ;

struct DSC_ARRAY_V2 ;
typedef struct DSC_ARRAY_V2 DSC_ARRAY_V2 ;

struct COBOL_FILEINFO;
typedef struct COBOL_FILEINFO COBOL_FILEINFO;

struct PLI_FILEINFO;
typedef struct PLI_FILEINFO PLI_FILEINFO;

struct FILEINFO;
typedef struct FILEINFO FILEINFO;

struct RELATION;
typedef struct RELATION RELATION;

struct EVENTS;
typedef struct EVENTS EVENTS;

struct DSAKEY;
typedef struct DSAKEY DSAKEY;

struct TGTKEY;
typedef struct TGTKEY TGTKEY;

struct EIBKEY;
typedef struct EIBKEY EIBKEY;

struct COMMAREAKEY;
typedef struct COMMAREAKEY COMMAREAKEY;

struct TCAKEY;
typedef struct TCAKEY TCAKEY;

struct SYTCAKEY;
typedef struct SYTCAKEY SYTCAKEY;

struct TWAKEY;
typedef struct TWAKEY TWAKEY;

struct EISKEY;
typedef struct EISKEY EISKEY;

struct EIUSKEY;
typedef struct EIUSKEY EIUSKEY;

struct TCTTEKEY;
typedef struct TCTTEKEY TCTTEKEY;

struct TCTUAKEY;
typedef struct TCTUAKEY TCTUAKEY;

struct CSAKEY;
typedef struct CSAKEY CSAKEY;

struct CSAOPFLKEY;
typedef struct CSAOPFLKEY CSAOPFLKEY;

struct CWAKEY;
typedef struct CWAKEY CWAKEY;

struct SCEKEY;
typedef struct SCEKEY SCEKEY;

struct RMUWKEY;
typedef struct RMUWKEY RMUWKEY;

struct FRABKEY;
typedef struct FRABKEY FRABKEY;

struct FLABKEY;
typedef struct FLABKEY FLABKEY;

struct FRTEKEY;
typedef struct FRTEKEY FRTEKEY;

struct FCTEKEY;
typedef struct FCTEKEY FCTEKEY;

struct DSNBKEY;
typedef struct DSNBKEY DSNBKEY;

struct VSWAKEY;
typedef struct VSWAKEY VSWAKEY;

struct PTAKEY;
typedef struct PTAKEY PTAKEY;

struct PLCBKEY;
typedef struct PLCBKEY PLCBKEY;

struct CPCBKEY;
typedef struct CPCBKEY CPCBKEY;

struct CRCBKEY;
typedef struct CRCBKEY CRCBKEY;

struct CSCBKEY;
typedef struct CSCBKEY CSCBKEY;

struct EIB;
typedef struct EIB EIB;

struct DFHS_TASKSTG;
typedef struct DFHS_TASKSTG DFHS_TASKSTG;

struct DFHS_TASKSTGKEY;
typedef struct DFHS_TASKSTGKEY DFHS_TASKSTGKEY;

struct BL_ITEM;
typedef struct BL_ITEM BL_ITEM;

struct BL_INFO;
typedef struct BL_INFO BL_INFO;

struct SFNAME;
typedef struct SFNAME SFNAME;

struct SFPROG;
typedef struct SFPROG SFPROG;

struct SFDATA;
typedef struct SFDATA SFDATA;

struct LISTSF;
typedef struct LISTSF LISTSF;

struct ATRCOMON ;
typedef struct ATRCOMON ATRCOMON ;

struct ATRCOMONE ;
typedef struct ATRCOMONE ATRCOMONE ;

struct ATRNUM ;
typedef struct ATRNUM ATRNUM ;

struct ATRNUME ;
typedef struct ATRNUME ATRNUME ;

struct ATRNOCCR ;
typedef struct ATRNOCCR ATRNOCCR ;

struct SYMTBENT ;
typedef struct SYMTBENT SYMTBENT ;

struct PTABENT ;
typedef struct PTABENT PTABENT ;

struct CICSSYSABEND_POF;
typedef struct CICSSYSABEND_POF CICSSYSABEND_POF;

struct CICSSYSABEND_KEYDATA;
typedef struct CICSSYSABEND_KEYDATA CICSSYSABEND_KEYDATA;

struct PROBABLE_CAUSE;
typedef struct PROBABLE_CAUSE PROBABLE_CAUSE;

/******************************************************************************/
/*   API Function and Structure Definitions                                   */
/******************************************************************************/

int iseanchor( EANCHOR *anchor) ;

struct   EANCHOR {        /* Analysis Script anchor */
  char    eye[8];         /* 8 byte null terminated EANCHOR eye catcher */
  char    *name ;         /* name of the Script */
  short    priority ;     /* dispatch priority */
  void   (*entry)(char*); /* pointer to entry point of the LE compliant script */
  int      devent ;       /* event number when script was last dispatched, or returned non-dispatchable */
  int      nevent ;       /* event number from the current notify item (most recient updateing this script) */
  void    *nanchor ;      /* pointer to IANCHOR or KANCHOR of current notify item  */
  char    *nname ;        /* name of the Script running when the current notify occured */
  int      nwhereamI ;    /* the whereamI address being notified or zero if not a whereamI related notify */
  int      elapsedMS;     /* total elapsed Milli Seconds used by this script */
  int      dispCount;     /* total number of times this script was dispatched */
} ;

#define RsnTextLen 128
struct     FAILRSN {
  short    RsnCode;          /* Reason code for failure                      */
  short    Oper;             /* Operand in error (0 = no operand in error)   */
  char    *Addr;             /* Address associated with error (eg. address   */
                             /* of bad data or address causing a protection  */
                             /* exception).                                  */
  char     RsnText[RsnTextLen]; /* Description of what was wrong with operand*/
} ;

struct     SLINE {
  int      Snline;           /* Offset to next source line structure         */
  int      Filen;            /* File number for source line                  */
  int      Linen;            /* Line number for source line                  */
  int      Stmtn;            /* Statement number for source line             */
  int      Lineind;          /* =1 for File/Line preference else 0           */
  int      RFilen;           /* Reportable file number for source line       */
  int      RLinen;           /* Reportable line number for source line       */
  int      RStmtn;           /* Reportable statement number for source line  */
  int      BStmtn;           /* Start statement number for Block             */
  int      Displ;            /* Displacement to source line                  */
  int      WDBaddr;          /* Pointer to IDILANGX record                   */
  int      Origin;           /* 1 - IDILANGX provided data                   */
                             /* 2 - TEST(,,NOSEPARATE) provided data         */
                             /* 3 - TEST(,,SEPARATE) provided data           */
  char     Sltxt[MAX_SRCLEN];/* Source Text                                  */
} ;

struct RELSEQ {
  int time;                  /* Time of event in tenths of seconds    */
  KANCHOR *next;             /* Next RELSEQ in chain                  */
  KANCHOR *previous;         /* Previous RELSEQ in chain              */
  KANCHOR *type;             /* Type of event (eg. DSA)               */
  int nodisp   : 1,          /* don't display this event in report    */
      usercode : 2,          /* 0=Unknown 1=UserCode 2=LibraryRoutine */
      historical : 1;        /* Historical event                      */
  int seqno;                 /* Relative sequence number              */
};

struct CIBKEY {
  int  cib,                  /* Address of related CIB  */
       cibh,                 /* Address of related CIBH */
       caa;                  /* Address of related CAA  */
};

struct SFNAME {              /* TEST Side file dsn      */
  short sfnamel;             /* DSN length              */
  char  sfnamet[57];         /* DSN                     */
};

struct SFPROG {              /* TEST Side file program  */
  short sfprogl;             /* program length          */
  char  sfprogt[57];         /* program                 */
};

struct SFDATA {              /* Side file function return structure  */
  char *sfpgsum;             /* Pointer to PROGSUM                   */
  char *sfdebug;             /* Pointer to all other debug tables    */
  char *sflist;              /* Pointer to side file listing         */
};

struct LISTSF {              /* Side file listing structure          */
  char  LnId[6];             /* Line Id                              */
  char  recstrt[6];          /* Start of source record               */
  char  comment;             /* Comment column                       */
  char  srec[65];            /* Rest of source record                */
};


/*   COBOL Attribute Table Common Header                             */
//KENICHI_Packed struct ATRCOMON {
#pragma pack(1)
struct ATRCOMON {
  char           atrtypcd;          /* TYPE CODE                              */
  char           atrtrulv;          /* TRUE LEVEL NUMBER                      */
  short int      atrcount;          /* NUMBER OF BYTES IN THIS ENTRY          */
  int            atrsympt;          /* Symbol table pointer                   */
  int            atrgitpt;          /* GITR                                   */
  int            atrdupch;          /* DUPLICATE NAME CHAIN                   */
  union {
    int            _atrdelim;       /* LEVEL DELIMITER POINTER                */
    int            _atrsnxsn;       /* DR OF NEXT SECTION                     */
  } _atrcomon_union1;
  union {
    int            _atrparnt;       /* PARENT POINTER                         */
    int            _atrpcnsn;       /* DR OF CONTAINING SECTION               */
  } _atrcomon_union2;
  unsigned char  atrlinid[3];       /* LINE ID                                */
  unsigned int   atrerror              : 1, /* ERROR DETECTED                         */
                 atrpdmap              : 1, /* PARTIAL DMAP REQUESTED                 */
                 atrspreg              : 1, /* SPECIAL REGISTER                       */
                 atradrof              : 1, /* ADDRESS OF CALL                        */
                 atrutlty              : 1, /* Utility flag                           */
                 atrglobl              : 1, /* GLOBAL ATTRIBUTE                       */
                 atrextrn              : 1, /* EXTERNAL ATTRIBUTE                     */
                 atrxignr              : 1, /* BIT USED BY XREF PHASE                 */
                 atradtyp              : 8, /* BL TYPE                                */
                 atradbt0              : 1, /* Zero - do not use                      */
                 _nmcb001              : 4, /* Reserved - do not use                  */
                 atradbln              : 15, /* BL #                                  */
                 atraddsp              : 12; /* DISPLACEMENT                          */
  char           atrsctyp;          /* SECTION TYPE                           */
  union {
    struct {
      unsigned int   _atrclrsv             : 1,
                                           : 7; /* Used by Session Variable               */
    } _atrcomon_struct1;
    struct {
      unsigned int                         : 1,
                     _atrregsv             : 1,
                                           : 6; /* Used by Session Variable               */
    } _atrcomon_struct2; /* CBSD043  */
    struct {
      unsigned int                         : 2,
                     _atrxufdi             : 1,
                                           : 5; /* UFD ON IDENTIFIER                      */
    } _atrcomon_struct3;
    struct {
      unsigned int                         : 3,
                     _atrxufda             : 1,
                                           : 4; /* UFD ON ALL REFS                        */
    } _atrcomon_struct4;
    struct {
      unsigned int                         : 4,
                     _atrclcpf             : 1,
                                           : 3; /* Calc routine call needed               */
    } _atrcomon_struct5;
    struct {
      unsigned int                         : 5,
                     _atradrbl             : 1,
                                           : 2; /* Addressable- used for chking           */
                                                /* linkage section items only             */
    } _atrcomon_struct6;
    struct {
      unsigned int                         : 6,
                     _atrcalrf             : 1,
                                           : 1; /* Passed BY REFERENCE                    */
                                                /* Bit ATRALLOC added    @PN58290         */
    } _atrcomon_struct7;
    struct {
      unsigned int                         : 7,
                     _atralloc             : 1; /* Allocate storage for data-item         */
    } _atrcomon_struct8;
  } atrxrgen; /* CBSD030  */
                                    /* XREF GENERAL                           */
  unsigned int   atrxodob              : 1, /* ODO OBJECT                             */
                 atrxodop              : 1, /* PSEUDO OBJECT OF ODO                   */
                 atrxocky              : 1, /* OCCURS KEY                             */
                 atrxocsb              : 1, /* SUBJECT OF OCCURS KEY                  */
                 atrxlabl              : 1, /* LABEL RECORD                           */
                 atrxfsta              : 1, /* FILE STATUS KEY                        */
                 _nmcb002              : 2; /* Available                              */
};
#pragma pack(pop)

/*   COBOL Attribute Table Common Header Extension for V3R1          */
struct ATRCOMONE {
  char           atrextend1[16];    /* V3R1 extension area                    */
};

#define atrdelim          _atrcomon_union1._atrdelim
#define atrsnxsn          _atrcomon_union1._atrsnxsn
#define atrparnt          _atrcomon_union2._atrparnt
#define atrpcnsn          _atrcomon_union2._atrpcnsn
#define atrclrsv          atrxrgen._atrcomon_struct1._atrclrsv
#define atrregsv          atrxrgen._atrcomon_struct2._atrregsv
#define atrxufdi          atrxrgen._atrcomon_struct3._atrxufdi
#define atrxufda          atrxrgen._atrcomon_struct4._atrxufda
#define atrclcpf          atrxrgen._atrcomon_struct5._atrclcpf
#define atradrbl          atrxrgen._atrcomon_struct6._atradrbl
#define atrcalrf          atrxrgen._atrcomon_struct7._atrcalrf
#define atralloc          atrxrgen._atrcomon_struct8._atralloc

/*   COBOL Attribute Table Entries 1 thru 5                          */
//KENICHI _Packed struct ATRNUM {
#pragma pack(1)
struct ATRNUM {
  int            atraleng;          /* LENGTH                        */
  char           atrnprec;          /* PRECISION FOR NUMERIC ITEM OR */
                                    /* INDEX DATA ITEM               */
  char           atrnscal;          /* SCALE FOR NUMERIC ITEM        */
  struct {
    unsigned int   _atrnvalu             : 1, /* VALUE                         */
                   _atrnindx             : 1, /* INDEXED                       */
                   _atrnrdef             : 1, /* REDEFINES                     */
                   _atrnrnam             : 1, /* RENAMES                       */
                   _atrnocur             : 1, /* OCCURS                        */
                   _atrhasky             : 1, /* HAS OCCURS KEY(S)             */
                   _atrnocdo             : 1, /* OCCURS DEPENDING ON           */
                   _atrnoinp             : 1; /* OCCURS IN PARENT              */
  } atrnclsp;
  struct {
    unsigned int   _atrredef             : 1, /* REDEFINED                     */
                   _atrrenam             : 1, /* RENAMED                       */
                   _atrsynch             : 1, /* SYNCRONIZED                   */
                   _atriredf             : 1, /* IMPLICITLY REDEFINED          */
                   _atrdate              : 1, /* DATE FIELD                    */
                   _atrnimrd             : 1, /* IMPLICIT REDEFINES            */
                   _atrnfilr             : 1, /* FILLER BIT                    */
                   _atrlvl77             : 1; /* 77 LEVEL ITEM                 */
  } atrcflag;
  union {
    struct {
      unsigned int   _atrnfbin            : 1, /* BINARY                        */
                     _atrneflt            : 1, /* EXTERNAL FLOATING PT          */
                     _atrniflt            : 1, /* INTERNAL FLOATING PT          */
                     _atrnfpak            : 1, /* PACKED                        */
                     _atrnfzon            : 1, /* ZONED                         */
                     _atrncmp5            : 1, /* USAGE COMP-5 SPECIFIED        */
                     _atrnfned            : 1, /* NUMERIC EDITED                */
                     _atrnfpt             : 1; /* EXTERNAL FLOATING POINT       */
    } _atrnum_struct1;
    struct {
      unsigned int   _atrafalb            : 1, /* ALPHABETIC                    */
                     _atrafaln            : 1, /* ALPHANUMERIC                  */
                     _atrafane            : 1, /* ALPHANUMERIC EDITED           */
                     _atracodo            : 1, /* GR CONTAIN ITS OWN ODO OBJ    */
                     _atradbcn            : 1, /* DBCS item (PIC 'N' - MIA std) */
                     _atrgvrln            : 1, /* GROUP VARIABLE LENGTH         */
                     _atrnegcs            : 1, /* EGCS ITEM ('G'S IN PIC)       */
                     _atrneged            : 1; /* EGCS EDITED ('G'S AND 'B'S)   */
    } _atrnum_struct2;
    struct {
      unsigned int                        : 4,
                     _atrgcdat            : 1, /* Group contains date & non-date*/
                                          : 3;
    } _atrnum_struct3; /* CBSD043  */
  } atrnflag; /* CBSD030  */
                                    /* FLAGS ,LEVEL 03 FOR NUMERIC   */
                                    /* LEVEL 05 FOR ALPHANUMERIC     */
  union {
    struct {
      unsigned int   _atrnsign            : 1, /* PICTURE SIGNED                */
                     _atrnsopt            : 1, /* SIGN OVERPUNCH TRAILING       */
                     _atrnsopl            : 1, /* SIGN OVERPUNCH LEADING        */
                     _atrnsept            : 1, /* SIGN SEPARATE TRAILING        */
                     _atrnsepl            : 1, /* SIGN SEPARATE LEADING         */
                     _atrnblnk            : 1, /* BLANK WHEN ZERO               */
                     _atrnscld            : 1, /* SCALED                        */
                                          : 1;
    } _atrnum_struct4;
    struct {
      unsigned int   _atrajust            : 1, /* JUSTIFIED                     */
                     _atralfed            : 1, /* ALPHABETIC EDITED ('B' IN PIC)*/
                     _atrgrind            : 1, /* USAGE INDEX AT GROUP LEVEL    */
                     _atrsaved            : 1, /* VAR LEN GRP SAVED IN TABLE    */
                     _atrgrptr            : 1, /* USAGE POINTER AT GROUP LEVEL  */
                     _atrgrobj            : 1, /* USAGE OBJECT REFERENCE AT GRP */
                                          : 1,
                     _atrgcvld            : 1; /* 01 GR HAS VAR LOC ITEM K200358*/
    } _atrnum_struct5;
    struct {
      unsigned int                        : 2,
                     _atrnmntp            : 1, /* MANTISSA HAS + SIGN           */
                     _atrnexpp            : 1, /* EXPONENT HAS + SIGN           */
                                          : 4;
    } _atrnum_struct6;
    struct {
      unsigned int   _atrouniv            : 1, /* UNIVERSAL OBJECT REFERENCE    */
                     _atrapptr            : 1, /* Procedure pointer             */
                                          : 6;
    } _atrnum_struct7;
  } atrndata;
                                    /* DATA DESCRIPTOR FLAG          */
                                    /* LEVEL 03 FOR NUMERIC ITEM     */
                                    /* LEVEL 05 FOR ALPHANUMERIC     */
                                    /* LEVEL 07 FOR FLOATING POINT   */
                                    /* LEVEL 09 FOR OBJECT REFERENCE */
                                    /* LEVEL 09 FOR PROCEDURE POINTER*/
  union {
    struct {
      unsigned int                        : 2,
                     _atrnsync            : 3, /* NUM OF SYNC BYTES ADDEDPL07345*/
                     _atrnsnca            : 3; /* INTER-OCCURRENCE BYTES@PL07345*/
    } _atrnum_struct8;
    struct {
      unsigned int   _atrvloc             : 1, /* ITEM IS VARIABLY LOCATED      */
                     _atrvloco            : 1, /* ORIGIN OF VAR LOCATED AREA    */
                                          : 6;
    } _atrnum_struct9;
  } atrndat1; /* CBSD030  */
                                    /* MORE DATA DESCRIPTOR FLAGS    */
};
#pragma pack(pop)

/*   COBOL Attribute Table Entries 1-5 Extension for V3R1          */
struct ATRNUME {
  char           atrnextend2[16];    /* V3R1 extension area                    */
};

#define atrnvalu         atrnclsp._atrnvalu
#define atrnindx         atrnclsp._atrnindx
#define atrnrdef         atrnclsp._atrnrdef
#define atrnrnam         atrnclsp._atrnrnam
#define atrnocur         atrnclsp._atrnocur
#define atrhasky         atrnclsp._atrhasky
#define atrnocdo         atrnclsp._atrnocdo
#define atrnoinp         atrnclsp._atrnoinp
#define atrredef         atrcflag._atrredef
#define atrrenam         atrcflag._atrrenam
#define atrsynch         atrcflag._atrsynch
#define atriredf         atrcflag._atriredf
#define atrdate          atrcflag._atrdate
#define atrnimrd         atrcflag._atrnimrd
#define atrnfilr         atrcflag._atrnfilr
#define atrlvl77         atrcflag._atrlvl77
#define atrnfbin         atrnflag._atrnum_struct1._atrnfbin
#define atrneflt         atrnflag._atrnum_struct1._atrneflt
#define atrniflt         atrnflag._atrnum_struct1._atrniflt
#define atrnfpak         atrnflag._atrnum_struct1._atrnfpak
#define atrnfzon         atrnflag._atrnum_struct1._atrnfzon
#define atrncmp5         atrnflag._atrnum_struct1._atrncmp5
#define atrnfned         atrnflag._atrnum_struct1._atrnfned
#define atrnfpt          atrnflag._atrnum_struct1._atrnfpt
#define atrafalb         atrnflag._atrnum_struct2._atrafalb
#define atrafaln         atrnflag._atrnum_struct2._atrafaln
#define atrafane         atrnflag._atrnum_struct2._atrafane
#define atracodo         atrnflag._atrnum_struct2._atracodo
#define atradbcn         atrnflag._atrnum_struct2._atradbcn
#define atrgvrln         atrnflag._atrnum_struct2._atrgvrln
#define atrnegcs         atrnflag._atrnum_struct2._atrnegcs
#define atrneged         atrnflag._atrnum_struct2._atrneged
#define atrgcdat         atrnflag._atrnum_struct3._atrgcdat
#define atrnsign         atrndata._atrnum_struct4._atrnsign
#define atrnsopt         atrndata._atrnum_struct4._atrnsopt
#define atrnsopl         atrndata._atrnum_struct4._atrnsopl
#define atrnsept         atrndata._atrnum_struct4._atrnsept
#define atrnsepl         atrndata._atrnum_struct4._atrnsepl
#define atrnblnk         atrndata._atrnum_struct4._atrnblnk
#define atrnscld         atrndata._atrnum_struct4._atrnscld
#define atrajust         atrndata._atrnum_struct5._atrajust
#define atralfed         atrndata._atrnum_struct5._atralfed
#define atrgrind         atrndata._atrnum_struct5._atrgrind
#define atrsaved         atrndata._atrnum_struct5._atrsaved
#define atrgrptr         atrndata._atrnum_struct5._atrgrptr
#define atrgrobj         atrndata._atrnum_struct5._atrgrobj
#define atrgcvld         atrndata._atrnum_struct5._atrgcvld
#define atrnmntp         atrndata._atrnum_struct6._atrnmntp
#define atrnexpp         atrndata._atrnum_struct6._atrnexpp
#define atrouniv         atrndata._atrnum_struct7._atrouniv
#define atrapptr         atrndata._atrnum_struct7._atrapptr
#define atrnsync         atrndat1._atrnum_struct8._atrnsync
#define atrnsnca         atrndat1._atrnum_struct8._atrnsnca
#define atrvloc          atrndat1._atrnum_struct9._atrvloc
#define atrvloco         atrndat1._atrnum_struct9._atrvloco


//KENICHI _Packed struct ATRNOCCR {            /* OCCURS DATA                     */
#pragma pack(1)
struct ATRNOCCR {            /* OCCURS DATA                     */
  int            atrnomin;              /* MINIMUM                      */
  int            atrnomax;              /* MAXIMUM                      */
  int            atrndrod;              /* DR OF ODO OBJ                */
  int            atrndrop;              /* DR OF OCCURS PARENT          */
  char           atr_dim;               /* NUMBER OF DIMENSIONS         */
  int            atrnodos;              /* ODOSAVE CELL NUMBER          */
};
#pragma pack(pop)

/*   COBOL Symbol Table Entry                                        */
struct SYMTBENT {
  int            symatrpt;          /* ATTRIBUTE TABLE PTR           */
  int            symsynch;          /* SYNONYM CHAIN                 */
  unsigned int   symdupli      : 1, /* DUPLICATE DECLARATION         */
                 symdatan      : 1, /* DATA-NAME                     */
                 symprocn      : 1, /* PROCEDURE-NAME                */
                 symmnemn      : 1, /* MNEMONIC-NAME                 */
                 symprogn      : 1, /* PROGRAM-NAME                  */
                 _nmcb001      : 3; /* RESERVED                      */
  char           symlngth;          /* LENGTH OF SYMBOL NAME         */
  char           symname;           /* SYMBOL NAME (variable length) */
};

struct PTABENT {
  char       LnVbNos[3];  /* Line and verb numbers         */
  char       VbDisp[3];   /* Displacement to verb          */
} ;

void dumpE( void) ;

/*|:h4.eDispatch()                                                   */
/*|:p.eDispatch() scans the loaded scripts array testing for the     */
/*|highest priority script ready to dispatch (selection criteria meet*/
/*|and not already run), then runs that script.  It returns 1 when a */
/*|script was selected and run, or zero of no scripts were           */
/*|dispatchable.                                                     */
/*|:xmp.*/
int eDispatch( void) ;
/*|:exmp.*/
/*|:h4.getMsgInserts()                                               */
/*|:p.getMsgInserts() is used                                                         */
/*|by several scripts to extract information from           */
/*|messages and create key data items with the naming convention                      */
/*|<msg_id>_<insert_id>.                                                              */
/*|The structure MsgInsertInfo contains the necessary definitions.                    */
/*|:xmp.*/
void getMsgInserts( KANCHOR *pKA, KANCHOR *pKArel) ;
/*|:exmp.*/
/*|:h4.IsHexBL()                                                                      */
/*|:p.This external function determines the base locator numbering system for a       */
/*|given COBOL program.                                                               */
/*|:xmp.*/
int IsHexBL(IANCHOR *pIAtgt, int source);
/*|:exmp.*/
/*|:h4.TrimDictBL()                                                                   */
/*|:p.This external function trims the IANCHOR length for each BL type. This length   */
/*|starts as 4096 but can be trimmed so it does not overlap the next higher IANCHOR   */
/*|address. To maximise the effect, this function is called during post analysis      */
/*|when dictionary population is complete.                                            */
/*|:xmp.*/
void TrimDictBL(void);
/*|:exmp.*/
/*|:h4.GetDictBL()                                                                    */
/*|:p.This external function returns a base locator IANCHOR for progname instance     */
/*|parent (CSECT) whose ordinal value is i. This together with AddBLinfo() and        */
/*|GetBLInfo() are used to manage and retrieve dictionary BLs and FCBs.               */
/*|Since there may be multiple instances of a program name, IDlocate() cannot         */
/*|reliably be used to return the IANCHOR of a program's base locator so use this     */
/*|function instead.                                                                  */
/*|:xmp.*/
IANCHOR *GetDictBL(BL_INFO *bl_info, char *bl_type, char *progname, int parent, int i);
/*|:exmp.*/
/*|:h4.AddCsectID()                                                                   */
/*|:p.This external function given an entry point address adds a CSECT IANCHOR.       */
/*|Its only external use is in cob_no_event where the TGTs of loaded but not active   */
/*|programs will not have a parent CSECT pointer unless the binder is available.      */
/*|:xmp.*/
IANCHOR *AddCsectID(KANCHOR *pKA, int ep, char *name);
/*|:exmp.*/
/*|:h4.problem_analysis                                              */
/*|:p.Adds ANALYSIS_PROBLEM keydata explaining a problem encountered */
/*|during analysis. For example, many CICS control blocks are        */
/*|checked for valid eyecatchers -- should an eyecatcher be          */
/*|damaged it is reported via this function.                         */
/*|:xmp.*/
void problem_analysis(char *id, char *text);
/*|:exmp.*/
/*|:h4.GetTGTAddr                                                    */
/*|:p.Given a DSA address returns the TGT address.                   */
/*|:xmp.*/
int GetTGTAddr(int pDSA);
/*|:exmp.*/
/*|:h4.IsOSVS_COBOL_DSA                                              */
/*|:p.Given a DSA IANCHOR returns 1 if it is associated with an      */
/*|OS VS/COBOL CSECT or 0 if not.                                    */
/*|:xmp.*/
int IsOSVS_COBOL_DSA(IANCHOR *pIAdsa);
/*|:exmp.*/

 /********************************************************************/
 /* PL/I Prolog Control Block (PCB)                                  */
 /********************************************************************/
struct PLIPCB {
                                      /*                             */
                                      /*                             */
  struct {
    struct {
      unsigned char  _pcb_stm[4];     /*   STM  14,12,12(13)         */
                                      /*       '90ECCD00C'X          */
      unsigned char  _pcb_bc[3];      /*   B *+x instruction         */
                                      /*       '47F0F0'X             */
    } pcb_init;                       /*                             */
    unsigned char  _pcb_bcsiz;        /*       length of data:       */
                                      /*        always 4+x           */
                                      /*       before version 2,     */
                                      /*        '14'X or less        */
                                      /*       after version 2,      */
                                      /*        '3C'X indicates      */
                                      /*           cu primary epa    */
                                      /*        '28'X indicates      */
                                      /*           other epas        */
                                      /*                             */
  } pcb_start;                        /*                             */
  void          *pcb_snt;             /* Pointer to the statement    */
                                      /* number table                */
                                      /*                             */
  union {
    int            _pcb_dsasz;        /* DSA storage size            */
                                      /*                             */
    void          *_pcb_pent;         /* primary EPA                 */
                                      /*                             */
  } _pcb_union1;
  void          *pcb_stat;            /* A(static csect)             */
                                      /*                             */
  void          *pcb_sym;             /* A(symbol table pointer)     */
                                      /*                             */
  void          *pcb_cib;             /* A(cu information block)     */
                                      /*                             */
  struct {
    struct {
      unsigned int   _pcb_main       : 1, /*   OPTIONS(MAIN) entry       */
                     _pcb_reord      : 1, /*   REORDER specified or      */
                                          /*     inherited               */
                     _pcb_type       : 2, /*   00 = BEGIN BLOCK          */
                                          /*   01 = ON-UNIT BLOCK        */
                                          /*   10 = PROCEDURE BLOCK      */
                                          /*   11 = RESERVED             */
                     _pcb_name       : 1, /*   Name field precedes EPA   */
                     _pcb_sec        : 1, /*   Secondary entry point     */
                     _pcb_graph      : 1, /*   CHARGRAPHIC in effect     */
                     _pcb_cvary      : 1; /*   Entry has a single parm   */
                                          /*     that is a varying char  */
                                          /*     string                  */
    } pcb_flag0;                      /*   Flags                     */
    struct {
      unsigned int   _pcb_nexec      : 1, /*     1 = Proc options        */
                                          /*         noexecops           */
                     _pcb_byval      : 1, /*     1 = By Value            */
                     __nm00001       : 6; /*   Reserved                  */
    } pcb_flag1;                      /*   Reserved for flags        */
    unsigned int   _pcb_flag2      : 8, /*   Reserved for flags        */
                   _pcb_flag3      : 8; /*   Reserved for flags        */
  } pcb_flags;                        /* Flag/Options                */
  struct {
    char           _pcb_ontyp;        /* Reserved for ON-unit type   */
                                      /*                             */
    char           _pcb_level;        /* Block Level Number          */
                                      /*                             */
    char           _pcb_count;        /* Block Sequence Number       */
                                      /*                             */
    char           _pcb_pcnt;         /* Number of parameters        */
                                      /*                             */
  } pcb_info;                         /*                             */
  unsigned char  _filler1[8];         /* reserved for PLITEST        */
                                      /*                             */
};

#define pcb_stm     pcb_start.pcb_init._pcb_stm
#define pcb_bc      pcb_start.pcb_init._pcb_bc
#define pcb_bcsiz   pcb_start._pcb_bcsiz
#define pcb_dsasz   _pcb_union1._pcb_dsasz
#define pcb_pent    _pcb_union1._pcb_pent
#define pcb_main    pcb_flags.pcb_flag0._pcb_main
#define pcb_reord   pcb_flags.pcb_flag0._pcb_reord
#define pcb_type    pcb_flags.pcb_flag0._pcb_type
#define pcb_name    pcb_flags.pcb_flag0._pcb_name
#define pcb_sec     pcb_flags.pcb_flag0._pcb_sec
#define pcb_graph   pcb_flags.pcb_flag0._pcb_graph
#define pcb_cvary   pcb_flags.pcb_flag0._pcb_cvary
#define pcb_nexec   pcb_flags.pcb_flag1._pcb_nexec
#define pcb_byval   pcb_flags.pcb_flag1._pcb_byval
#define _nm00001    pcb_flags.pcb_flag1.__nm00001
#define pcb_flag2   pcb_flags._pcb_flag2
#define pcb_flag3   pcb_flags._pcb_flag3
#define pcb_ontyp   pcb_info._pcb_ontyp
#define pcb_level   pcb_info._pcb_level
#define pcb_count   pcb_info._pcb_count
#define pcb_pcnt    pcb_info._pcb_pcnt

struct SYMBOL {
  int      LangId;           /* Language Id - see Language Environment       */
                             /* member language identifiers in IDIIH.H       */
  void    *pStg;             /* pointer to COBST/PLISTG table                */
  int      oStg;             /* occurrence in Stg for this symbol            */
  union {
    COB_SYM    *CobSym;      /* COBOL symbol definition                      */
    void       *CCSym;       /* C/C++ symbol definition                      */
    PLI_SYM    *PliSym;      /* PL/I symbol definition                       */
    ASM_SYM    *AsmSym;      /* Assembler symbol definition                  */
  } Sym;
};

struct COB_SYM {
  char     Name[31];         /* Name of the symbol                           */
  int      Line;             /* Defining source line number                  */
  char     Level;            /* Symbol Level number                          */
  char     Qual;             /* Qualification indicator. Zero means unique   */
                             /* name, no qualification needed.               */
  char     Type;             /* Symbol type (see #defines below)             */
  char     Attrib;           /* Symbol attribute                             */
  char     Mnem_type;        /* Mnemonic-name type code                      */
  union {
    struct {
      unsigned int   _cls_val        : 1, /* Value                           */
                     _cls_idxd       : 1, /* Indexed                         */
                     _cls_red        : 1, /* Redefines                       */
                     _cls_ren        : 1, /* Renames                         */
                     _cls_occ        : 1, /* Occurs                          */
                     _cls_hasocc     : 1, /* Has Occurs keys                 */
                     _cls_odo        : 1, /* Occurs depending on             */
                     _cls_occinpar   : 1; /* Occurs in parent                */
    } DI_cls;                /* Clauses specified for data item              */
    struct {
      unsigned int   _cls_sel        : 1, /* Select                          */
                     _cls_asgn       : 1, /* Assign                          */
                     _cls_rerun      : 1, /* Rerun                           */
                     _cls_sma        : 1, /* Same area                       */
                     _cls_smra       : 1, /* Same record area                */
                     _cls_rm         : 1, /* Recording mode                  */
                     _cls_rsv1       : 1, /* reserved                        */
                     _cls_rec        : 1; /* Record                          */
    } Fl_cls;                /* Clauses specified for file                   */
  } Clauses;                 /* Clauses specified in symbol definition       */
  struct {
    unsigned int   _redef          : 1, /* REDEFINED                         */
                   _renam          : 1, /* RENAMED                           */
                   _synch          : 1, /* SYNCRONIZED                       */
                   _iredf          : 1, /* IMPLICITLY REDEFINED              */
                   _date           : 1, /* DATE FIELD                        */
                   _nimrd          : 1, /* IMPLICIT REDEFINES                */
                   _nfilr          : 1, /* FILLER BIT                        */
                   _lvl77          : 1; /* 77 LEVEL ITEM                     */
  } Flags_1;                 /* Data flags when Attrib 0x01, 0x02, 0x03 or   */
                             /* 0x05                                         */
  union {
    struct {
      unsigned int   _bin            : 1, /* Binary                          */
                     _exfp           : 1, /* External floating-point         */
                     _infp           : 1, /* Internal floating-point         */
                     _pckd           : 1, /* Packed                          */
                     _znd            : 1, /* Zoned                           */
                     _scld           : 1, /* Scaled                          */
                     _nmed           : 1, /* Numeric edited                  */
                     _rsv2           : 1; /* reserved                        */
    } Nmflgs;                /* Data flags for numeric symbols               */
    struct {
      unsigned int   _alpha          : 1, /* Alphabetic                      */
                     _alphnm         : 1, /* Alphanumeric                    */
                     _alphned        : 1, /* Alphanumeric edited             */
                     _grpodo         : 1, /* Group contains own ODO object   */
                     _dbcs           : 1, /* DBCS                            */
                     _grpvar         : 1, /* Group variable length           */
                     _egcs           : 1, /* EGCS item                       */
                     _egcsed         : 1; /* EGCS edited                     */
    } Alflgs;                /* Data flags for Alphanumeric symbols          */
    struct {
      unsigned int   _objodo         : 1, /* Object of ODO in record         */
                     _subodo         : 1, /* Subject of ODO in record        */
                     _seqa           : 1, /* Sequential access               */
                     _randa          : 1, /* Random access                   */
                     _dyna           : 1, /* Dynamic access                  */
                     _loca           : 1, /* Locate mode                     */
                     _reca           : 1, /* Record area                     */
                     _rvs3           : 1; /* reserved                        */
    } Flflgs;                /* Data flags for both file types               */
  } Flags_2;                 /* Data flags when Attrib 0x01, 0x02, 0x0F or   */
                             /* 0x10                                         */
  struct {
    unsigned int   _samel          : 1, /* All records same length           */
                   _fixl           : 1, /* Fixed length                      */
                   _varl           : 1, /* Variable length                   */
                   _undef          : 1, /* Undefined                         */
                   _span           : 1, /* Spanned                           */
                   _blkd           : 1, /* Blocked                           */
                   _awo            : 1, /* Apply Write Only                  */
                   _ssma           : 1; /* Same SORT/MERGE area              */
  } Flags_3;                 /* Data flags when Attrib 0x0F or 0x10          */
  struct {
    unsigned int   _qsam           : 1, /* QSAM                              */
                   _ascii          : 1, /* ASCII                             */
                   _stdlbl         : 1, /* Standard label                    */
                   _usrlbl         : 1, /* User label                        */
                   _vsseq          : 1, /* VSAM sequential                   */
                   _vsidx          : 1, /* VSAM indexed                      */
                   _vsrel          : 1, /* VSAM relative                     */
                   _rsv4           : 1; /* reserved                          */
  } File_org;                /* File organisation for both file types        */
  char     Usage;            /* Usage clause definition                      */
  char     Sign;             /* Sign clause definition                       */
  char     Indicator;        /* Miscellaneous indicators                     */
  int      Byte_len;         /* Length in bytes                              */
  char     Precision;        /* Precision                                    */
  char     Scale;            /* Scale factor                                 */
  char     BL_type;          /* Base locator type                            */
  char     Date_format;      /* Date Format                                  */
  int      No_dec;           /* Number of decimal places                     */
  int      Occ_min;          /* Minimum value for OCCURS                     */
  int      Occ_max;          /* Maximum value for OCCURS                     */
  int      Dims;             /* Number of dimensions                         */
  int      Sub_vals[7];      /* Array subscript values                       */
  int      Key_cnt;          /* Number of keys                               */
  int      Index_cnt;        /* Number of Indexes                            */
  short    Error_flg;        /* Error involvement indicator                  */
                             /* 0=innocent, 1=caused, 2=contributed,         */
                             /* 3=involved, 4=not addressable                */
  char    *Data;             /* Data stored in data item                     */
};

struct BL_ITEM {
  int address;
  int offset;
  int length;
  char name[10];             /* Base locator name (eg. BLW=00001) */
  int o_address;             /* Failing instruction bad operand address */
  unsigned int bad_pack : 1, /* PACK instruction caused bad operand */
               div_zero : 1; /* Bad operand is zero */
};

struct BL_INFO {             /* Base locator info for #BLx'progname keydata */
  int nBL;                   /* No of base locators (of this type) */
  int start;                 /* Starting number (0 or 1) */
  short osvsBL;              /* Starting number for OS/VS COBOL BL */
  int parent;                /* BL IANCHOR parent address (CSECT) */
};

#define DI_Clauses   Clauses.DI_cls
#define Fl_Clauses   Clauses.Fl_cls
#define Cls_val      DI_Clauses._cls_val
#define Cls_idxd     DI_Clauses._cls_idxd
#define Cls_red      DI_Clauses._cls_red
#define Cls_ren      DI_Clauses._cls_ren
#define Cls_occ      DI_Clauses._cls_occ
#define Cls_hasocc   DI_Clauses._cls_hasocc
#define Cls_odo      DI_Clauses._cls_odo
#define Cls_occinpar DI_Clauses._cls_occinpar
#define Cls_sel      Fl_Clauses._cls_sel
#define Cls_asgn     Fl_Clauses._cls_asgn
#define Cls_rerun    Fl_Clauses._cls_rerun
#define Cls_sma      Fl_Clauses._cls_sma
#define Cls_smra     Fl_Clauses._cls_smra
#define Cls_rm       Fl_Clauses._cls_rm
#define Cls_rsv1     Fl_Clauses._cls_rsv1
#define Cls_rec      Fl_Clauses._cls_rec
#define redef        Flags_1._redef
#define renam        Flags_1._renam
#define synch        Flags_1._synch
#define iredf        Flags_1._iredf
#define date         Flags_1._date
#define nimrd        Flags_1._nimrd
#define nfilr        Flags_1._nfilr
#define lvl77        Flags_1._lvl77
#define Nm_Flags     Flags_2.Nmflgs
#define Al_Flags     Flags_2.Alflgs
#define Fl_Flags     Flags_2.Flflgs
#define bin          Nm_Flags._bin
#define exfp         Nm_Flags._exfp
#define infp         Nm_Flags._infp
#define pckd         Nm_Flags._pckd
#define znd          Nm_Flags._znd
#define scld         Nm_Flags._scld
#define nmed         Nm_Flags._nmed
#define rsv2         Nm_Flags._rsv2
#define alpha        Al_Flags._alpha
#define alphnm       Al_Flags._alphnm
#define alphned      Al_Flags._alphned
#define grpodo       Al_Flags._grpodo
#define dbcs         Al_Flags._dbcs
#define grpvar       Al_Flags._grpvar
#define egcs         Al_Flags._egcs
#define egcsed       Al_Flags._egcsed
#define objodo       Fl_Flags._objodo
#define subodo       Fl_Flags._subodo
#define seqa         Fl_Flags._seqa
#define randa        Fl_Flags._randa
#define dyna         Fl_Flags._dyna
#define loca         Fl_Flags._loca
#define reca         Fl_Flags._reca
#define rvs3         Fl_Flags._rvs3
#define samel        Flags_3._samel
#define fixl         Flags_3._fixl
#define varl         Flags_3._varl
#define undef        Flags_3._undef
#define span         Flags_3._span
#define blkd         Flags_3._blkd
#define awo          Flags_3._awo
#define ssma         Flags_3._ssma
#define qsam         File_org._qsam
#define ascii        File_org._ascii
#define stdlbl       File_org._stdlbl
#define usrlbl       File_org._usrlbl
#define vsseq        File_org._vsseq
#define vsidx        File_org._vsidx
#define vsrel        File_org._vsrel
#define rsv4         File_org._rsv4

/* COBOL Symbol type codes                                                   */
#define TYPE_DATA      0x40    /* Data name               */
#define TYPE_PROC      0x20    /* Procedure name          */
#define TYPE_MNEM      0x10    /* Mnemonic name           */
#define TYPE_PROG      0x08    /* Program name            */
#define TYPE_EXT       0x04    /* External                */
#define TYPE_GLOB      0x02    /* Global                  */
#define TYPE_RESV      0x81    /* --- reserved ---        */
#define TYPE_CLASS     0x68    /* Class name (Class-Id)   */
#define TYPE_METHOD    0x58    /* Method name             */

/*   Attribute type codes                                            */
#define NATRNUM  1        /* NUMERIC ITEM                            */
#define NATRALFN 2        /* ALPHANUMERIC ELEMENTARY ITEM            */
#define NATRALGR 3        /* ALPHANUMERIC GROUPE ITEM                */
#define NATRPNTR 4        /* POINTER/PROCEDURE-POINTER               */
#define NATRINXD 5        /* INDEX DATA ITEM                         */
#define NATRINXN 6        /* INDEX NAME                              */
#define NATRCOND 7        /* CONDITION NAME                          */
#define NATRMNEM 8        /* MNEMONIC NAME                           */
#define NATRALPH 9        /* ALPHABET NAME                           */
#define NATRRC   10       /* CONTROL NAME (REPORT)                   */
#define NATRRG1  11       /* REPORT GROUPE (LEVEL 01)                */
#define NATRRG2  12       /* REPORT GROUPE (LEVEL 02-48)             */
#define NATRRELI 13       /* REPORT ELEMENTARY ITEM                  */
#define NATRREL1 14       /* REPORT ELEMENTARY ITEM(LV01)            */
#define NATRFILE 15       /* FILE NAME                               */
#define NATRSRTF 16       /* SORT FILE NAME                          */
#define NATRREPN 17       /* REPORT NAME                             */
#define NATRSECT 18       /* SECTION NAME                            */
#define NATRPARA 19       /* PARAGRAPH NAME                          */
#define NATRPROG 20       /* PROGRAM ENTRY                           */
#define NATRSYMC 21       /* SYMBOLIC CHARACTER                      */
#define NATRCLAS 22       /* CLASS NAME                              */
#define NATROOCL 23       /* OO CLASS NAME                           */
#define NATROBJR 24       /* OBJECT REFERENCE                        */
#define NATRCURS 25       /* CURRENCY SIGN SYMBOL                    */

/*   USAGE type codes                                                */
#define USE_DISPLAY    0  /* DISPLAY                                 */
#define USE_COMP1      1  /* COMP-1                                  */
#define USE_COMP2      2  /* COMP-2                                  */
#define USE_PD         3  /* PACKED DECIMAL or COMP-3                */
#define USE_BIN        4  /* BINARY, COMP or COMP-4                  */
#define USE_DISPLAY1   5  /* DISPLAY-1                               */
#define USE_PTR        6  /* POINTER                                 */
#define USE_INDEX      7  /* INDEX                                   */
#define USE_PROC_PTR   8  /* PROCEDURE POINTER                       */
#define USE_OBJ_REF    9  /* OBJECT-REFERENCE                        */

/*   SIGN type codes                                                 */
#define SIGN_NONE         0
#define SIGN_LEAD         1
#define SIGN_LEAD_SEP     2
#define SIGN_TRAIL        3
#define SIGN_TRAIL_SEP    4

/*   BL type codes                                                   */
#define BLF      1       /* Files                                    */
#define BLW      2       /* Working storage                          */
#define BLL      3       /* Linkage section                          */
#define BLS      4       /* Sort files (not used)                    */
#define BL       5       /* Special registers                        */
#define INDEXBY  7       /* Indexed by variable                      */
#define RTRNCOD  8       /* Return code special register             */
#define COMREG   9       /* COM-REG Special register                 */
#define UPSISW   10      /* UPSI Switch                              */
#define SORTRTN  11      /* SORT-RETURN Special register             */
#define SORTCTL  12      /* SORT-CONTROL Special register            */
#define BLV      13      /* Variably located data                    */
#define BLX      14      /* External data                            */
#define BLA      15      /* Alphnumeric function temporary           */
#define BLAE     16      /* Alphnumeric evaluate temporary           */
#define BLO      17      /* Object data                              */
#define LINDXBY  18      /* Lcl-stg index (opt, not in dict'y)       */
#define BLK      19      /* Local Storage (Automatic)                */

struct ASM_SYM {
  char     Name[32];         /* Name of the symbol                           */
  int      Stmt;             /* Defining source stmt number                  */
  char     Type;             /* Symbol type (see DED types below)            */
  int      Byte_len;         /* Length in bytes                              */
  int      Bit_len;          /* Additional bit length                        */
  char     Precision;        /* Precision                                    */
  char     Scale;            /* Scale factor                                 */
  char     Dimensions;       /* Number of dimensions                         */
  void    *Array_dsc;        /* Array descriptor                             */
  int      Sub_vals[15];     /* Array subscript values                       */
  short    Error_flg;        /* Error involvement indicator                  */
                             /* 0=innocent, 1=caused, 2=contributed,         */
                             /* 3=involved, 5=indexes unavailable            */
  short    Data_set;         /* 0=Data not set, 1=Data set even if zero      */
  int      Data;             /* Data stored in data item                     */
  int      Data_len;         /* If symbol is a pointer, length in bytes of   */
                             /* the data the pointer references              */
  int      Displ;            /* Offset (from base reg, so Data-Displ = base) */
  char     Sect_type;        /* Section type: 1=CSECT, 2=DSECT               */
  char     Sect_name[32];    /* Section (CSECT/DSECT) name                   */
};

struct PLI_SYM {
  char     Name[32];         /* Name of the symbol                           */
  int      File;             /* Defining source file number                  */
  int      Line;             /* Defining source line number                  */
  int      Stmt;             /* Defining source stmt number                  */
  char     Level;            /* Symbol Level number                          */
  char     Type;             /* Symbol type (see DED types below)            */
  char     Class;            /* Storage class (see SYMTYPEs below)           */
  union {
    struct {
      unsigned int   _filler1        : 7,
                     _vuab           : 1; /* Unaligned bit string            */
    } Str_Flgs;              /* String flags                                 */
    struct {
      unsigned int   _filler2        : 3,
                     _vfex           : 1, /* Extended Precision              */
                     _filler3        : 1,
                     _vdec           : 1, /* DECIMAL                         */
                     _vfln           : 1, /* Long Precision                  */
                     _vfcp           : 1; /* COMPLEX                         */
    } Num_Flgs;              /* Numeric flags                                */
  } Flags;
  struct {
    unsigned int   _sym_vary       : 1,   /* varying string                  */
                   _sym_ver2       : 1,   /* Compiled with CMPAT(V2)         */
                   _sym_based      : 1,   /* Symbol is based                 */
                   _sym_extrn      : 1,   /* Symbol is external              */
                   _filler4        : 4;
  } Sym_flags;
  int      Byte_len;         /* Length in bytes                              */
  int      Bit_len;          /* Additional bit length                        */
  char     Bit_offset;       /* Bit offset                                   */
  char     Precision;        /* Precision                                    */
  char     Scale;            /* Scale factor                                 */
  char     Dimensions;       /* Number of dimensions                         */
  void    *Array_dsc;        /* Array descriptor                             */
  int      Sub_vals[15];     /* Array subscript values                       */
  short    plen1;            /* string PICTURE - length with insertion chars */
                             /* arithmetic PICTURE - length of picture       */
  short    plen2;            /* string PICTURE - length without insertions   */
                             /* arithmetic PICTURE - length of data          */
  char    *Picture;          /* Picture in internal format                   */
  short    Error_flg;        /* Error involvement indicator                  */
                             /* 0=innocent, 1=caused, 2=contributed,         */
                             /* 3=involved, 4=bad address,                   */
                             /* 5=indexes unavailable                        */
  short    Array_flg;        /* Array usage indicator                        */
                             /* 0=of no consequence                          */
                             /* 1=subscript out of range                     */
                             /* 2=subscript specification too complex        */
                             /* 3=subscript variable unknown                 */
                             /* 4=entire array referenced (ie. no subscript) */
  short    Data_set;         /* 0=Data not set, 1=Data set even if zero      */
  int      Data;             /* Data stored in data item                     */
  int      Data_len;         /* If symbol is a pointer, length in bytes of   */
                             /* the data the pointer references              */
  int      Ptr;              /* Address held in pointer symbol               */
  void    *Based_sym;        /* Based item this symbol points to (LXSYLO)    */
};

#define Str_Flags    Flags.Str_Flgs
#define Num_Flags    Flags.Num_Flgs
#define vuab         Str_Flags._vuab
#define vfex         Num_Flags._vfex
#define vdec         Num_Flags._vdec
#define vfln         Num_Flags._vfln
#define vfcp         Num_Flags._vfcp
#define sym_vary     Sym_flags._sym_vary
#define sym_ver2     Sym_flags._sym_ver2
#define sym_based    Sym_flags._sym_based
#define sym_extrn    Sym_flags._sym_extrn

struct DSC_ARRAY_V1 {                 /* ARRAY Descriptor - V1      */
  int            dsc_rvo;             /* Relative Virtual Origin    */
  struct {
    int            _dsc_strid;        /*   Multiplier               */
    short int      _dsc_ubnd;         /*   Upper bound              */
    short int      _dsc_lbnd;         /*   Lower bound              */
  } dsc_data[15];                     /* Data for each dimension    */
};

#define v1_dsc_strid    dsc_data._dsc_strid
#define v1_dsc_ubnd     dsc_data._dsc_ubnd
#define v1_dsc_lbnd     dsc_data._dsc_lbnd

struct DSC_ARRAY_V2 {                 /* ARRAY Descriptor - V2      */
  int            dsc_rvo;             /* Relative Virtual Origin    */
  struct {
    int            _dsc_strid;        /*   Multiplier               */
    int            _dsc_ubnd;         /*   Upper bound              */
    int            _dsc_lbnd;         /*   Lower bound              */
  } dsc_data[15];                     /* Data for each dimension    */
};

#define v2_dsc_strid    dsc_data._dsc_strid
#define v2_dsc_ubnd     dsc_data._dsc_ubnd
#define v2_dsc_lbnd     dsc_data._dsc_lbnd

/********************************************************************/
/* DEDs for computational data.                                     */
/********************************************************************/
#define ded_vlxb       0x00  /* Fixed binary                */
#define ded_vlxd       0x04  /* Fixed decimal               */
#define ded_vlft       0x08  /* Float                       */
#define ded_vpxb       0x10  /* Fixed pictured binary       */
#define ded_vpxd       0x14  /* Fixed pictured decimal      */
#define ded_vpfb       0x18  /* Float pictured binary       */
#define ded_vpfd       0x1C  /* Float pictured decimal      */
#define ded_vchn       0x20  /* Character string - fixed    */
#define ded_vbin       0x24  /* Bit string - fixed          */
#define ded_vchv       0x28  /* Character string - varying  */
#define ded_vbiv       0x2C  /* Bit string - varying        */
#define ded_vspc       0x30  /* Pictured character string   */

#define ded_vgrn       0xA0  /* Graphic string - fixed      */
#define ded_vgrv       0xA8  /* Graphic string - varying    */

#define ded_vuab       0x01  /* Unal. bit string indicator  */

/********************************************************************/
/*  The DED_TYPE for computational data other than graphic          */
/*  strings will be less than DED_VPTA.                             */
/********************************************************************/
#define ded_vpta       0x80

/********************************************************************/
/*  DEDs for program control variables                              */
/********************************************************************/
#define ded_vlbl       0x80  /* LABEL                       */
#define ded_vven       0x84  /* ENTRY                       */
#define ded_vcaa       0x88  /* AREA                        */
#define ded_vtsk       0x8C  /* TASK                        */
#define ded_voft       0x90  /* OFFSET                      */
#define ded_vptr       0x94  /* POINTER                     */
#define ded_vfil       0x98  /* FILE                        */
#define ded_vevt       0x9C  /* EVENT                       */

/********************************************************************/
/*  The DED_TYPE for all variables other than program control       */
/*  constants will be less than DED_VPTC.                           */
/********************************************************************/
#define ded_vptc       0xB0

/********************************************************************/
/*  DEDs for program control constants                              */
/********************************************************************/
#define ded_vlbc       0xB0  /* LABEL                       */
#define ded_vvec       0xB4  /* ENTRY                       */
#define ded_vfic       0xB8  /* FILE                        */
#define ded_vcnd       0xBC  /* CONDITION                   */

/********************************************************************/
/*  Values that distinguish entry constants                         */
/********************************************************************/
#define ded_vvec_pli   0x0A  /* PLI                  */
#define ded_vvec_fort  0x07  /* FORTRAN              */
#define ded_vvec_cobol 0x05  /* COBOL                */
#define ded_vvec_asm   0x10  /* ASSEMBLER            */

/********************************************************************/
/*  SYMTYPEs                                                        */
/********************************************************************/
#define symtype_auto     0x80
#define symtype_based    0x20
#define symtype_cparm    0xE0
#define symtype_ctled    0x40
#define symtype_dbggr    0xC0
#define symtype_defnd    0x60
#define symtype_mask     0xE0
#define symtype_parm     0xA0
#define symtype_static   0x00

/************************************************************************/
/* COBOL_FILEINFO                                                       */
/************************************************************************/
struct COBOL_FILEINFO {
  /***  start of common area shared by PLI_FILEINFO and OPEN_FILEINFO      ***/
  char ddname[9];            /* DD name                                      */
  char *dsname;              /* blank-delimited dataset names                */
  int  status;               /* File status                                  */
  char *reason;              /* File status reason                           */
  int  RetCode;              /* VSAM Return Code                             */
  int  FuncCode;             /* VSAM Function Code                           */
  int  FeedBack;             /* VSAM Feedback Code                           */
  char func[9];              /* Function  (open, close, etc.)                */
  char  open;                /* File is open                                 */
  int   recl;                /* Record length for data set                   */
  short blksize;             /* Block size                                   */
  short keyl;                /* Key length                                   */
  short keyloc;              /* KEYLOC (VSAM)                                */
  short primkeyl;            /* Primary key length (VSAM)                    */
  short primkeyloc;          /* Primary KEYLOC (VSAM)                        */
  char  *dsbase;             /* Base (primary key) dataset name (VSAM)       */
  short irecnbl;             /* Number of base locators for record           */
  int   ncp    :8;           /* Channel programs                             */
  int   bufno  :8;           /* Number of buffers                            */
  int   smsi   :8;           /* Index area                                   */
  int   bufof  :8;           /* ASCII buffer offset                          */
  void *currkey;             /* VSAM: key of current record                  */
  void *currrec;             /* VSAM: current record                         */
  int   currrecl;            /* VSAM: current record length                  */
  int   currpos;             /* VSAM: SLOT(RRDS) or RBA(ESDS)                */
  void *recs;                /* Pointer to QSAM/VSAM_REC array               */
  int   nrecs;               /* No of elements in recs                       */
  char  itype;               /* Info type (1=OS VS/COBOL, 2=Other COBOLs)    */
  int   bof      : 1,        /* At beginning-of-file                         */
        eof      : 1,        /* At end-of-file                               */
        output   : 1,        /* Open for output                              */
        fixed    : 1,        /* Record format is fixed                       */
        prevwrap : 1,        /* Previous record n/a (buffer wrap-around)     */
        nextwrap : 1,        /* Next record n/a (buffer wrap-around)         */
        currnoba : 1,        /* Put locate r1 area consumed -- no current    */
                             /*  record build area, r1 is previous recotd    */
        path     : 1,        /* This file is a VSAM AIX PATH                 */
        noactplh : 1,        /* No active placeholder (VSAM)                 */
        norpl    : 1,        /* No valid RPL (VSAM)                          */
        nobuff   : 1,        /* No buffers (QSAM) or control interval (VSAM) */
        noiomod  : 1,        /* MVS I/O module not supported (QSAM/BSAM)     */
        asciivar : 1,        /* File is ASCII variable length (not supported)*/
        iopend   : 1,        /* I/O not complete (BSAM)                      */
                 : 2;        /* Spare                                        */
  /***  end of common area                                                 ***/

  struct {                   /* File organisation                            */
    unsigned int   _finf_iorgseq   : 1, /* Sequential                        */
                   _finf_iorgind   : 1, /* Indexed                           */
                   _finf_iorgrel   : 1, /* Relative                          */
                   _finf_iorgvsam  : 1, /* VSAM                              */
                   _finf_iorgolds  : 1, /* Old sequential file code = S      */
                   _finf_iorgiam   : 1, /* IAM                               */
                   _finf_spare     : 2; /* Spare                             */
  } _finf_org;
  struct {                   /* File access mode                             */
    unsigned int   _finf_iaccseq   : 1, /* Sequential                        */
                   _finf_iaccran   : 1, /* Random                            */
                   _finf_iaccdyn   : 1, /* Dynamic                           */
                   _finf_spare     : 5; /* Spare                             */
  } _finf_acc;
  struct {                   /* File recording mode                          */
    unsigned int   _finf_irecf     : 1, /* Fixed                             */
                   _finf_irecv     : 1, /* Variable                          */
                   _finf_irecasci  : 1, /* track overflow or ASCII var length*/
                   _finf_irecbr    : 1, /* Blocked                           */
                   _finf_irecsb    : 1, /* For fixed length record format -  */
                                        /* standard blocks.                  */
                                        /* For variable length record fmt -  */
                                        /* spanned records.                  */
                   _finf_irecca    : 1, /* ASA control characters            */
                   _finf_ireccm    : 1, /* Machine control characters        */
                   _finf_ireckl    : 1; /* Key length specified in DCB       */
  } _finf_rcf;
  struct {                   /* Open verbs                                   */
    unsigned int   _finf_iverbinp  : 1, /* Input                             */
                   _finf_iverbout  : 1, /* Output                            */
                   _finf_iverbio   : 1, /* I-O                               */
                   _finf_iverbext  : 1, /* Extend                            */
                   _finf_iverbrev  : 1, /* Reversed                          */
                   _finf_iverbnrw  : 1, /* No rewind                         */
                   _finf_iverbcls  : 1, /* Close                             */
                   _finf_iverbrel  : 1; /* REEL/UNIT                         */
  } _finf_vrb;
  char *dspath;              /* Path dataset name if AIX used */
};

#define finf_iorgseq        _finf_org._finf_iorgseq
#define finf_iorgind        _finf_org._finf_iorgind
#define finf_iorgrel        _finf_org._finf_iorgrel
#define finf_iorgvsam       _finf_org._finf_iorgvsam
#define finf_iorgiam        _finf_org._finf_iorgiam
#define finf_iorgolds       _finf_org._finf_iorgolds
#define finf_iaccseq        _finf_acc._finf_iaccseq
#define finf_iaccran        _finf_acc._finf_iaccran
#define finf_iaccdyn        _finf_acc._finf_iaccdyn
#define finf_irecf          _finf_rcf._finf_irecf
#define finf_irecv          _finf_rcf._finf_irecv
#define finf_irecasci       _finf_rcf._finf_irecasci
#define finf_irecbr         _finf_rcf._finf_irecbr
#define finf_irecsb         _finf_rcf._finf_irecsb
#define finf_irecca         _finf_rcf._finf_irecca
#define finf_ireccm         _finf_rcf._finf_ireccm
#define finf_ireckl         _finf_rcf._finf_ireckl
#define finf_iverbinp       _finf_vrb._finf_iverbinp
#define finf_iverbout       _finf_vrb._finf_iverbout
#define finf_iverbio        _finf_vrb._finf_iverbio
#define finf_iverbext       _finf_vrb._finf_iverbext
#define finf_iverbrev       _finf_vrb._finf_iverbrev
#define finf_iverbnrw       _finf_vrb._finf_iverbnrw
#define finf_iverbcls       _finf_vrb._finf_iverbcls
#define finf_iverbrel       _finf_vrb._finf_iverbrel

/************************************************************************/
/* PLI_FILEINFO                                                         */
/************************************************************************/
struct PLI_FILEINFO {
  /***  start of common area shared by COBOL_FILEINFO and OPEN_FILEINFO    ***/
  char  ddname[9];           /* DD name                                      */
  char *dsname;              /* Blank-delimited data set names               */
  int   status;              /* File status (not used)                       */
  char *reason;              /* File status reason (not used)                */
  int   RetCode;             /* VSAM Return Code                             */
  int   FuncCode;            /* VSAM Function Code                           */
  int   FeedBack;            /* VSAM Feedback Code                           */
  char  func[9];             /* Function  (open, close, etc.)                */
  char  open;                /* File is open                                 */
  int   recl;                /* Record length for data set                   */
  short blksize;             /* Block size                                   */
  short keyl;                /* Key length                                   */
  short keyloc;              /* KEYLOC (VSAM)                                */
  short primkeyl;            /* Primary key length (VSAM)                    */
  short primkeyloc;          /* Primary KEYLOC (VSAM)                        */
  char  *dsbase;             /* Base (primary key) dataset name (VSAM)       */
  short reserved2;           /* Reserved (xxx_FILEINFO compatibility)        */
  int   ncp    :8;           /* Channel programs                             */
  int   bufno  :8;           /* Number of buffers                            */
  int   smsi   :8;           /* Index area                                   */
  int   bufof  :8;           /* ASCII buffer offset                          */
  void *currkey;             /* VSAM: key of current record                  */
  void *currrec;             /* VSAM: current record                         */
  int   currrecl;            /* VSAM: current record length                  */
  int   currpos;             /* VSAM: SLOT(RRDS) or RBA(ESDS)                */
  void *recs;                /* Pointer to QSAM/VSAM_REC array               */
  int   nrecs;               /* No of elements in recs                       */
  char  itype;               /* Info type (always 3=PLI)                     */
  int   bof      : 1,        /* At beginning-of-file                         */
        eof      : 1,        /* At end-of-file                               */
        output   : 1,        /* Open for output                              */
        fixed    : 1,        /* Record format is fixed                       */
        prevwrap : 1,        /* Previous record n/a (buffer wrap-around)     */
        nextwrap : 1,        /* Next record n/a (buffer wrap-around)         */
        currnoba : 1,        /* Put locate r1 area consumed -- no current    */
                             /*  record build area, r1 is previous recotd    */
        path     : 1,        /* This file is a VSAM AIX PATH                 */
        noactplh : 1,        /* No active placeholder (VSAM)                 */
        norpl    : 1,        /* No valid RPL (VSAM)                          */
        nobuff   : 1,        /* No buffers (QSAM) or control interval (VSAM) */
        noiomod  : 1,        /* MVS I/O module not supported (QSAM/BSAM)     */
        asciivar : 1,        /* File is ASCII variable length (not supported)*/
        iopend   : 1,        /* I/O not complete (BSAM)                      */
                 : 2;        /* Spare                                        */
  /***  end of common area                                                 ***/

  struct {                   /* File attributes                              */
    unsigned int   _finf_fdsp      : 1, /* Display                           */
                   _finf_frio      : 1, /* Record                            */
                   _finf_fsio      : 1, /* Stream                            */
                   _finf_fbak      : 1, /* Backwards                         */
                   _finf_fupd      : 1, /* Update                            */
                   _finf_fout      : 1, /* Output                            */
                   _finf_fipt      : 1, /* Input                             */
                   _finf_ftra      : 1, /* Transient                         */
                   _finf_fdir      : 1, /* Direct                            */
                   _finf_fseq      : 1, /* Sequential                        */
                   _finf_fmsgfile  : 1, /* LE Msgfile                        */
                   _finf_fprt      : 1, /* Print                             */
                   _finf_fxcl      : 1, /* Exclusive                         */
                   _finf_fkyd      : 1, /* Keyed                             */
                   _finf_funb      : 1, /* Unbuffered                        */
                   _finf_fbuf      : 1, /* Buffered                          */
                   _finf_fvsm      : 1, /* VSAM                              */
                   _finf_ffix      : 1, /* F format                          */
                   _finf_fvar      : 1, /* V format                          */
                   _finf_fund      : 1, /* U format                          */
                   _finf_fasc      : 1, /* D format                          */
                   _finf_fspa      : 1, /* Spanned                           */
                   _finf_fblo      : 1, /* Blocked                           */
                   _finf_frecto    : 1, /* Track overflow                    */
                   _finf_fiam      : 1, /* IAM                               */
                   _finf_spare     : 7; /* spare                             */
  } _finf_attr;

  struct {                   /* VSAM stuff                                   */
    unsigned int   _finf_fksd      : 1, /* KSDS                              */
                   _finf_fesd      : 1, /* ESDS                              */
                   _finf_frds      : 1, /* RRDS                              */
                   _finf_fpth      : 1, /* PATH                              */
                   _finf_fnun      : 1, /* NON-UNIQUE                        */
                   _finf_frls      : 1, /* RLS                               */
                   _finf_spare     : 2; /* spare                             */
  } _finf_attr_vsam;

  struct {
    unsigned int   _finf_ncon      : 1, /* Consecutive                       */
                   _finf_nind      : 1, /* Indexed                           */
                   _finf_nrg1      : 1, /* Regional(1)                       */
                   _finf_nrg2      : 1, /* Regional(2)                       */
                   _finf_nrg3      : 1, /* Regional(3)                       */
                   _finf_ntpm      : 1, /* TP(M)                             */
                   _finf_ntpr      : 1, /* TP(R)                             */
                   _finf_noth      : 1, /* Other organization                */
                   _finf_nasa      : 1, /* CTLASA                            */
                   _finf_n360      : 1, /* CTL360                            */
                   _finf_negs      : 1, /* GRAPHIC                           */
                   _finf_nlve      : 1, /* LEAVE                             */
                   _finf_nrrd      : 1, /* REREAD                            */
                   _finf_ngky      : 1, /* GENKEY                            */
                   _finf_ncbl      : 1, /* COBOL                             */
                   _finf_nowr      : 1, /* NOWRITE                           */
                   _finf_ntot      : 1, /* TOTAL                             */
                   _finf_nabf      : 1, /* ADDBUF                            */
                   _finf_nstl      : 1, /* SCALARVARYING                     */
                   _finf_nfsi      : 1, /* SIS                               */
                   _finf_nfsk      : 1, /* SKIP                              */
                   _finf_nfbw      : 1, /* BKWD                              */
                   _finf_nfrs      : 1, /* REUSE                             */
                   _finf_spare     : 9; /* spare                             */
    unsigned int   _finf_nbnd;          /* BUFND value                       */
    unsigned int   _finf_nbni;          /* BUFNI value                       */
    unsigned int   _finf_nbsp;          /* BUFSP value                       */
  } _finf_env;
};

#define finf_fdsp           _finf_attr._finf_fdsp
#define finf_frio           _finf_attr._finf_frio
#define finf_fsio           _finf_attr._finf_fsio
#define finf_fbak           _finf_attr._finf_fbak
#define finf_fupd           _finf_attr._finf_fupd
#define finf_fout           _finf_attr._finf_fout
#define finf_fipt           _finf_attr._finf_fipt
#define finf_ftra           _finf_attr._finf_ftra
#define finf_fdir           _finf_attr._finf_fdir
#define finf_fseq           _finf_attr._finf_fseq
#define finf_fmsgfile       _finf_attr._finf_fmsgfile
#define finf_fprt           _finf_attr._finf_fprt
#define finf_fxcl           _finf_attr._finf_fxcl
#define finf_fkyd           _finf_attr._finf_fkyd
#define finf_funb           _finf_attr._finf_funb
#define finf_fbuf           _finf_attr._finf_fbuf
#define finf_fvsm           _finf_attr._finf_fvsm
#define finf_fiam           _finf_attr._finf_fiam
#define finf_ffix           _finf_attr._finf_ffix
#define finf_fvar           _finf_attr._finf_fvar
#define finf_fund           _finf_attr._finf_fund
#define finf_fasc           _finf_attr._finf_fasc
#define finf_fspa           _finf_attr._finf_fspa
#define finf_fblo           _finf_attr._finf_fblo
#define finf_frecto         _finf_attr._finf_frecto
#define finf_fksd           _finf_attr_vsam._finf_fksd
#define finf_fesd           _finf_attr_vsam._finf_fesd
#define finf_frds           _finf_attr_vsam._finf_frds
#define finf_fpth           _finf_attr_vsam._finf_fpth
#define finf_fnun           _finf_attr_vsam._finf_fnun
#define finf_frls           _finf_attr_vsam._finf_frls
#define finf_ncon           _finf_env._finf_ncon
#define finf_nind           _finf_env._finf_nind
#define finf_nrg1           _finf_env._finf_nrg1
#define finf_nrg2           _finf_env._finf_nrg2
#define finf_nrg3           _finf_env._finf_nrg3
#define finf_ntpm           _finf_env._finf_ntpm
#define finf_ntpr           _finf_env._finf_ntpr
#define finf_noth           _finf_env._finf_noth
#define finf_nasa           _finf_env._finf_nasa
#define finf_n360           _finf_env._finf_n360
#define finf_negs           _finf_env._finf_negs
#define finf_nlve           _finf_env._finf_nlve
#define finf_nrrd           _finf_env._finf_nrrd
#define finf_ngky           _finf_env._finf_ngky
#define finf_ncbl           _finf_env._finf_ncbl
#define finf_nowr           _finf_env._finf_nowr
#define finf_ntot           _finf_env._finf_ntot
#define finf_nabf           _finf_env._finf_nabf
#define finf_nstl           _finf_env._finf_nstl
#define finf_nfsi           _finf_env._finf_nfsi
#define finf_nfsk           _finf_env._finf_nfsk
#define finf_nfbw           _finf_env._finf_nfbw
#define finf_nfrs           _finf_env._finf_nfrs
#define finf_nbnd           _finf_env._finf_nbnd
#define finf_nbni           _finf_env._finf_nbni
#define finf_nbsp           _finf_env._finf_nbsp

/*   Error flag codes                                                */
#define innocent      0
#define caused        1
#define contributed   2
#define involved      3

struct RELATION {
  int initFlag : 1,  /* first event in chain */
      POF      : 1,  /* point of failure event */
      NoShow   : 1;  /* Event not displayed in batch report due to excessive total number of events */
  KANCHOR *pKA;      /* key NEWRELSEQ anchor pointer */
  int usercode : 2;  /* 0=Unknown 1=UserCode 2=LibraryRoutine */
  int event_type;    /* see enum E_TYPE in IDIPBREP */
};

static enum EVENTS_TYPE { BATCH_EVENT=1, CICS_EVENT };
typedef enum EVENTS_TYPE EVENTS_TYPE;

struct EVENTS {
  int numRels;       /* number of RELATION structures */
  KANCHOR    *next;  /* debug - next EVENTS structure */
  KANCHOR    *first; /* debug - first DSA2 event      */
  int         addr;  /* debug - TCB/TCA address       */
  int         epie;  /* debug - epie address          */
  EVENTS_TYPE type;  /* debug - type of events        */
  RELATION Rel[1];
};

static struct EVENT_MAIN {     /* EVENTS structures   */
  KANCHOR    *first;           /* first one added     */
  KANCHOR    *last;            /* last one added      */
  KANCHOR    *report;          /* one to report       */
};
typedef struct EVENT_MAIN EVENT_MAIN;

struct DSAKEY {                /* DSA information   */
  int     addr;                /* address of DSA    */
  int     r14;                 /* return address    */
  int     ep;                  /* entry point       */
  int     prb;                 /* addr of MVS PRB   */
  int     pesa;                /* addr of CICS PESA */
  short   amode;               /* amode (from r14)  */
  int     skip:1;              /* events skipped    */
  enum {CALL,LINK,BALR} type;  /* call type         */
  ICUDATA CU;                  /* Compile Unit Data */
};

struct TGTKEY {                /* COBOL TGT information  */
  int  addr;                   /* address of TGT         */
  int  len;                    /* length of TGT          */
};

/* Structures for CICS System Analysis Scripts           */
/*  Storage usage by task                                */
struct DFHS_TASKSTG {
  IANCHOR *pIA;                /* DS Task IANCHOR        */
  int SysAbove;                /* System above (bytes)   */
  int SysBelow;                /*        below (bytes)   */
  int UserAbove;               /* User above (bytes)     */
  int UserBelow;               /*      below (bytes)     */
  int Total;                   /* Task's total storage   */
};

/*  Keydata for storage usage by task                    */
struct DFHS_TASKSTGKEY {
  int Count;                   /* No of TASKSTG structs  */
  DFHS_TASKSTG *TaskStg;       /* Array of TASKSTGs      */
};

struct EIBKEY {                /* CICS EIB information   */
  int  aeib;                   /* address of EIB         */
  int  asytca;                 /* address of system TCA  */
};

struct COMMAREAKEY {           /* CICS COMMAREA information   */
  int  ca_len;                 /* length of COMMAREA          */
  int  ca_addr;                /* address of COMMAREA         */
};

struct TCAKEY {                /* CICS TCA information   */
  int  addr;                   /* address of TCA         */
  int  len;                    /* length of TCA          */
};

struct SYTCAKEY {              /* CICS SYTCA information */
  int  addr;                   /* address of SYTCA       */
  int  len;                    /* length of SYTCA        */
};

struct TWAKEY {                /* CICS TWA information   */
  int  addr;                   /* address of TWA         */
  int  len;                    /* length of TWA          */
};

struct EISKEY {                /* CICS EIS information   */
  int  addr;                   /* address of EIS         */
  int  len;                    /* length of EIS          */
};

struct EIUSKEY {               /* CICS EIUS information  */
  int  addr;                   /* address of EIUS        */
  int  len;                    /* length of EIUS         */
};

struct TCTTEKEY {              /* CICS TCTTE information     */
  int  addr;                   /* address of TCTTE           */
  int  len;                    /* length of TCTTE            */
  char fci;                    /* facility control indicator */
};

struct TCTUAKEY {              /* CICS TCTUA information     */
  int  addr;                   /* address of TCT User Area   */
  int  len;                    /* length of TCT User Area    */
};

struct CSAKEY {                /* CICS CSA information   */
  int  addr;                   /* address of CSA         */
  int  len;                    /* length of CSA          */
};

struct CSAOPFLKEY {            /* CICS CSA optional features */
  int  addr;                   /* address of CSAOPFL         */
  int  len;                    /* length of CSAOPFL          */
};

struct CWAKEY {                /* CICS CWA information   */
  int  addr;                   /* address of CWA         */
  int  len;                    /* length of CWA          */
};

struct SCEKEY {                /* CICS User24/31 storage */
  int  addr;                   /* address of SCE         */
  int  len;                    /* length of SCE          */
};

struct RMUWKEY {                /* CICS UOW object        */
  int  addr;                   /* address of RMUW        */
  int  len;                    /* length of RMUW         */
};

struct FRABKEY {                /* CICS File Request Anchor Block */
  int  addr;                   /* address of FRAB        */
  int  len;                    /* length of FRAB         */
};

struct FLABKEY {                /* CICS File Lasting Access Block */
  int  addr;                   /* address of FLAB        */
  int  len;                    /* length of FLAB         */
};

struct FRTEKEY {                /* CICS File Request Thread Element */
  int  addr;                   /* address of FRTE        */
  int  len;                    /* length of FRTE         */
};

struct FCTEKEY {                /* CICS File Control Table Entry  */
  int  addr;                   /* address of FRTE        */
  int  len;                    /* length of FRTE         */
  char access[6];              /* VSAM, BDAM, etc.       */
  char mode[6];                /* base, path, AIX        */
  char type[6];                /* KSDS, ESDS, RRDS       */
  char remote[4];              /* YES, NO                */
};

struct DSNBKEY {                /* CICS Dataset Name Block */
  int  addr;                   /* address of DSNB        */
  int  len;                    /* length of DSNB         */
};

struct VSWAKEY {                /* CICS VSAM work area   */
  int  addr;                   /* address of VSWA        */
  int  len;                    /* length of VSWA         */
};

struct PTAKEY {                /* CICS PTA               */
  int  addr;                   /* address of PTA         */
  int  len;                    /* length of PTA          */
  int  link_levels;            /* no of link levels      */
};

struct PLCBKEY {               /* CICS PLCB              */
  int  addr;                   /* address of PLCB        */
  int  len;                    /* length of PLCB         */
  char pgmname[9];             /* program name           */
};

struct CPCBKEY {               /* CICS Container Pool    */
  int  container_addr;         /* address of CPCB        */
  int  container_count;        /* no of containers       */
};

struct CRCBKEY {               /* CICS Container         */
  int  addr;                   /* address of CRCB        */
  int  datalen;                /* container data length  */
};

struct CSCBKEY {               /* CICS Container Segment */
  int  addr;                   /* address of CSCB        */
  int  datalen;                /* segment data length    */
};

struct EIB {                   /* CICS EIB               */
  unsigned char       eibtime  [4] ;
  unsigned char       eibdate  [4] ;
  unsigned char       eibtrnid [4] ;
  unsigned char       eibtaskn [4] ;
  unsigned char       eibtrmid [4] ;
  signed short int    eibfil01  ;
  signed short int    eibcposn  ;
  signed short int    eibcalen  ;
  unsigned char       eibaid    ;
  unsigned char       eibfn    [2] ;
  unsigned char       eibrcode [6] ;
  unsigned char       eibds    [8] ;
  unsigned char       eibreqid [8] ;
  unsigned char       eibrsrce [8] ;
  unsigned char       eibsync   ;
  unsigned char       eibfree   ;
  unsigned char       eibrecv   ;
  unsigned char       eibfil02  ;
  unsigned char       eibatt    ;
  unsigned char       eibeoc    ;
  unsigned char       eibfmh    ;
  unsigned char       eibcompl  ;
  unsigned char       eibsig    ;
  unsigned char       eibconf   ;
  unsigned char       eiberr    ;
  unsigned char       eiberrcd [4] ;
  unsigned char       eibsynrb  ;
  unsigned char       eibnodat  ;
  signed long  int    eibresp   ;
  signed long  int    eibresp2  ;
  unsigned char       eibrldbk  ;
};

/*|:h4.eInstallScripts()                                             */
/*|:p.eInstallScripts() is used to call the install entry point for     */
/*|a set of DA scripts.  The install entry point returns an array of pointers */
/*|that describe the scripts it contains.                                     */
/*|:xmp.*/

void eInstallScripts( void **(*)(void)) ;

/*|:exmp.*/

/*|:h4.eCsectInfo()                                                  */
/*|:p.eCsectInfo() fills out the supplied XCSECT structures according   */
/*|to the addr and DSA passed in.  Structure is only valid if rc=0.  */
/*|:xmp.*/

int eCsectInfo(int addr,char *pDSA,XCSECT *pCSECT);

/*|:exmp.*/

/*|:h4.eModSeqno()                                                   */
/*|:p.eModSeqno() removes the leading sequence number from a COBOL      */
/*|source line if it is identical to the line number.                */
/*|:xmp.*/

void eModSeqno(SLINE *pSLINE);

/*|:exmp.*/

/*|:h4.eSlineInfo()                                                  */
/*|:p.eSlineInfo() creates and returns to the caller an SLINE structure.*/
/*|Structure is only valid if rc=0. The caller is responsible for    */
/*|freeing the storage obtained for the returned SLINE structure.    */
/*|:xmp.*/

int eSlineInfo(int addr,char *pDSA,SLINE **pSLINE,int *SLsz);

/*|:exmp.*/

/*|:h4.eGetCobSource()                                                                */
/*|:p.This function checks whether the program associated with the passed CSECT has   */
/*|been compiled with the TEST option. If so it calls the function which uses the     */
/*|TEST control blocks to find the source line(s) corresponding to the passed         */
/*|displacement. If the program is not compiled with TEST, the function that finds    */
/*|the source line(s) using WDBLANGX is called.                                       */
/*|:xmp.*/

int eGetCobSource(IANCHOR *pIAcs, int displ, SLINE **pSLINE, int *SLsz, XCSECT *pXC) ;

/*|:exmp.*/

/*|:h4.eGetPliSource()                                                                */
/*|:p.This function checks whether the program associated with the passed CSECT has   */
/*|been compiled with the TEST option. If so it calls the function which uses the     */
/*|TEST control blocks to find the source line(s) corresponding to the passed         */
/*|displacement. If the program is not compiled with TEST, the function that finds    */
/*|the source line(s) using WDBLANGX is called.                                       */
/*|:xmp.*/

int eGetPliSource(IANCHOR *pIAcs, char *pDSA, int displ, SLINE **pSLINE, int *SLsz) ;

/*|:exmp.*/


/*|:h4.CobStaticStg()                                                                 */
/*|:p.This function builds keydata for COBOL programs loaded but not active (ie. no   */
/*|DSA). Calls may be internally from IDIECOB or externally from FormatCOBOLStatic    */
/*|at presentation time. For COBOLs other than OS/VS this function is called during   */
/*|interactive presentation and facilitates 'on demand' LANGX calls -- it is only     */
/*|during interactive presentation that we need source view for these programs and    */
/*|there could be a large number of them (so LANGX calls during script processing     */
/*|(cob_no_event) are redundant).                                                     */
/*|:xmp.*/

void CobStaticStg(IANCHOR *pIAtgt, char *progname, char source);

/*|:exmp.*/

ICUDATA *Cob2DSAChk(int DSA) ;             /*$$ZAP PH these look to be unused */
ICUDATA *CobosvsDSAChk(int DSA) ;          /*$$ZAP PH these look to be unused */
ICUDATA *Cob2CSECTChk(IANCHOR *pIA) ;      /*$$ZAP PH these look to be unused */
ICUDATA *CobosvsCSECTChk(IANCHOR *pIA) ;   /*$$ZAP PH these look to be unused */

/*|:h4.AddrIsIn()                                                    */
/*|:p.AddrIsIn() finds whether an address is within                  */
/*|a given dictionary item?                        */
/*|Returns either a pointer to an IANCHOR or a NULL.                 */
/*|:xmp.*/

IANCHOR *AddrIsIn(int addr,char *name);

/*|:exmp.*/

/*|:h4.FindCsectOrModule()                                           */
/*|:p.FindCsectOrModule() checks if the given address is within a    */
/*|CSECT or MODULE. If the address is within a CSECT then return the */
/*|address of the CSECT IANCHOR.  If not but the address is found to */
/*|be in a MODULE then return the address of the MODULE IANCHOR.  If */
/*|it is not in either, then return NULL.                            */
/*|:xmp.*/

IANCHOR *FindCsectOrModule(int addr);

/*|:exmp.*/

/*|:h4.EPType()                                                      */
/*|:p.EPType()  Looks for LE comforming EP types. Written primarily  */
/*|to identify XPLink EPs.                                           */
/*|:xmp.*/

int EPType(int EP);

/*|:exmp.*/

/*|:h4.GetDsaEP()                                                    */
/*|:p.GetDsaEP() gets the Entry Point from a given DSA.              */
/*|This is a quick and dirty; the DSA chaining script does a more    */
/*|thorough job but this was needed for those scripts running before */
/*|the DSA chain script.                                             */
/*|:xmp.*/

int GetDsaEP(int dsa);

/*|:exmp.*/

/*|:h4.PSW_Addr()                                                    */
/*|:p.PSW_Addr() calculates the abend address given the PSW, ILC and */
/*|PIC.  This function decrements the PSW by the ILC if the PIC      */
/*|indicates that this is needed.  The ILC is the number of bytes    */
/*|not the code.                                                     */
/*|:xmp.*/

int PSW_Addr(int *psw, int ilc, int pic);

/*|:exmp.*/

/*|:h4.GetBLInfo()                                                                    */
/*|:p.This external function locates BL_INFO keydata (added by AddBLInfo). It is      */
/*|passed the BL type (eg. BLW), program name and parent (CSECT).                     */
/*|It returns a pointer to a BL_INFO struct.                                          */
/*|Using this struct the caller can locate all IANCHORs for a given BL type.          */
/*|:xmp.*/

BL_INFO *GetBLInfo(char *bl, char *progname, int parent);

/*|:exmp.*/

/*|:h4.UpdateSLine()                                                 */
/*|:p.This function creates an entry in an SLINE linked list.        */
/*|:xmp.*/

void    UpdateSLine(char *src, int fnum, int lnum, int stmt, int disp, SLINE **pSLINE, int *SLsz, int *psize,
                    int rfnum, int rlnum, int rstmt, int bstmt, int wdbaddr, int origin, int lineind);

/*|:exmp.*/

/*|:h4.CicsFunc_Format_GroupFunc()                                   */
/*|:p.This function returns CICS API verbs when given a hex          */
/*|Group/Function code (as in EIBFN).                                */
/*|:xmp.*/

char *CicsFunc_Format_GroupFunc(unsigned short GroupFunc);

/*|:exmp.*/

/*|:h4.CicsFunc_GetArg0Len()                                         */
/*|:p.Given:   SHORT of EXEC CICS Group/Function                     */
/*|:p.Returns: SHORT of the probable length of that ARG0.            */
/*|:xmp.*/

short CicsFunc_GetArg0Len(unsigned short GroupFunc);

/*|:exmp.*/

/*|:h4.CobTstAvail()                                                 */
/*|:p.Given:   IANCHOR for a csect                                   */
/*|:p.Returns: pointer to a PROGSUM if TEST option ON.               */
/*|:xmp.*/

int   CobTstAvail(IANCHOR *pIAcs);

/*|:exmp.*/

/*|:h4.CobSepSource()                                                */
/*|:p.Given:   IANCHOR for a csect                                   */
/*|:p.         data set name                                         */
/*|:p.         program name                                          */
/*|:p.         module name                                           */
/*|:p.         table of results                                      */
/*|:p.Returns: zero return code if the TEST(,,SEPARATE) data was     */
/*|:p.         stored correctly.                                     */
/*|:xmp.*/

int  CobSepSource(IANCHOR *pIAcs, char *dsn, char *progname, char *module, int tabp, char nosigcheck);

/*|:exmp.*/

/*|:h4.CobStaticPS()                                                 */
/*|:p.Given:   IANCHOR for a csect                                   */
/*|:p.Returns: virtual address of DEBUGINF/PROGSUM in COBOL CSECT    */
/*|:p.         or zero if not found.                                 */
/*|:xmp.*/

int CobStaticPS(IANCHOR *pIAcs);

/*|:exmp.*/

void **EBASE( void ) ;  /* define the initial base scripts package */
void **EDSA ( void ) ;  /* define the DSA scripts package          */
void **ELE  ( void ) ;  /* define the LE scripts package           */
void **EASM ( void ) ;  /* define the assembler scripts package    */
void **ECOB ( void ) ;  /* define the COBOL scripts package        */
void **EPLI ( void ) ;  /* define the PL/I scripts package         */
void **ECICS( void ) ;  /* define the CICS scripts package         */
void **EDB2 ( void ) ;  /* define the DB2 scripts package          */
void **EIMS ( void ) ;  /* define the IMS scripts package          */
void **EMQS ( void ) ;  /* define the MQSeries scripts package     */
void **EJAVA( void ) ;  /* define the Java scripts package         */
void **EABND( void ) ;  /* define the common abend code scripts package */

/**************************************************************************************/
/*User data (UDATA) flags--key data items using the prefix UDATA contain              */
/*the following flags in the 2nd halfword:                                            */
/**************************************************************************************/
#define UDATABOOK  0x8000 /* Topic extracted from softcopy book */
#define UDATANOFMT 0x4000 /* Do not format (reflow) */

#define GPR0  "GPREGS.0x00"
#define GPR2  "GPREGS.0x08"
#define GPR3  "GPREGS.0x0C"
#define GPR4  "GPREGS.0x10"
#define GPR15 "GPREGS.0x3C"

/**************************************************************************************/
/*|:h4.struct SysAbendInfo                                                            */
/*|:p.Abend codes should be added here when:                                          */
/*|:ul.                                                                               */
/*|:li.The abend code explanation is to be found under a heading that differs from    */
/*|the default which is based on the actual abend code                                */
/*|(for example, the "System Codes" book does not contain a description for           */
/*|abend 0C4 - it is included in the description of abend 0Cx).                       */
/*|:li.The abend code explanation includes a follow-on reference to one or more       */
/*|message explanations.                                                              */
/*|:li.The abend has an associated reason code that can be obtained from a related    */
/*|key data item.                                                                     */
/*|More complicated reason code determination can be added directly to the            */
/*|sysabend_all script.                                                               */
/*|:eul.                                                                              */
/**************************************************************************************/
/*|:xmp.*/
struct {
  short code;     /* system abend code */
  short range;    /* number of consecutive codes included in this entry */
  char *altref;   /* alternative code reference */
  char *msgref;   /* message reference */
  char *rc_src;   /* reason code location--first token must be a key item */
} SysAbendInfo[] = {
/*|:psc proc='x' */
  {0x001, 1, NULL, "IEC020I", NULL},
  {0x002, 1, NULL, "IEC036I", GPR15},
  {0x003, 2, NULL, NULL, GPR15},
  {0x005, 1, NULL, "IEC041I", "IEC041I_RC"},
  {0x008, 1, NULL, NULL, NULL},
  {0x00A, 1, NULL, NULL, GPR15},
  {0x00B, 1, NULL, NULL, NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0x00C, 2, NULL, NULL, GPR15},
  {0x00F, 1, NULL, "CBDA099I", NULL},
  {0x012, 1, NULL, NULL, GPR15},
  {0x013, 1, NULL, "IEC141I", GPR15},
  {0x014, 1, NULL, "IEC208I", GPR15},
  {0x015, 3, NULL, NULL, GPR15},
  {0x019, 3, NULL, NULL, GPR15},
  {0x01C, 1, NULL, NULL, NULL},
  {0x01D, 1, NULL, NULL, GPR15},
  {0x01F, 1, NULL, NULL, GPR15},
  {0x020, 1, NULL, NULL, NULL},
  {0x021, 1, NULL, NULL, GPR15},
  {0x022, 1, NULL, NULL, NULL},
  {0x023, 1, NULL, NULL, GPR15},
  {0x024, 1, NULL, "APS050I,APS521I", "APS050I_RC"},  /* zzz rc also in msg APS521I */
  {0x025, 2, NULL, NULL, GPR15},
  {0x027, 1, NULL, "APS050I,APS521I", "APS050I_RC"},  /* zzz rc also in msg APS521I */
  {0x028, 1, NULL, "IEA928I", NULL},
  {0x029, 1, NULL, NULL, NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0x02A, 1, NULL, NULL, GPR2},
  {0x02B, 1, NULL, NULL, NULL},
  {0x02C, 1, NULL, "$HASP413,$HASP415,$HASP750", NULL},
  {0x02D, 1, NULL, "$HASP088,$HASP095", NULL},
  {0x02E, 1, NULL, "AVM010E", "GPREGS.0x3C,AVM010_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x030, 1, NULL, NULL, NULL},
  {0x031, 1, NULL, NULL, NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0x032, 1, NULL, NULL, NULL},
  {0x033, 1, NULL, NULL, GPR15},
  {0x034, 1, NULL, NULL, NULL},
  {0x035, 1, NULL, NULL, NULL},
  {0x036, 4, NULL, NULL, NULL},
  {0x03A, 1, NULL, "IEC251I", NULL},
  {0x03B, 2, NULL, NULL, GPR15},
  {0x03D, 2, NULL, "IEC156I", "GPREGS.0x3C,IEC156I_RC"},
  {0x03E, 1, NULL, NULL, NULL},
  {0x03F, 1, NULL, NULL, NULL},  /* zzz msg IHJxxxI and appropriate rc! */
  {0x040, 2, NULL, "IED008I", NULL},  /* zzz GPR0? */
  {0x043, 1, NULL, "IED015I", GPR0},
  {0x044, 1, NULL, NULL, GPR3},
  {0x045, 1, NULL, NULL, NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0x046, 2, NULL, NULL, NULL},
  {0x048, 1, NULL, NULL, GPR0},
  {0x049, 1, NULL, NULL, NULL},
  {0x04A, 3, NULL, NULL, GPR15},
  {0x04E, 1, NULL, NULL, GPR15},
  {0x04F, 1, NULL, "DSNV086E", NULL},  /* zzz ? */
  {0x051, 5, NULL, NULL, GPR15},
  {0x056, 2, NULL, NULL, NULL},
  {0x058, 3, NULL, NULL, GPR15},
  {0x05B, 1, NULL, NULL, NULL},   /* zzz ? */
  {0x05C, 1, NULL, "IEF100I", "GPREGS.0x3C,IEF100I_REASON"},
  {0x05D, 2, NULL, NULL, GPR15},
  {0x05F, 1, NULL, NULL, NULL},
  {0x060, 1, NULL, NULL, GPR15},
  {0x061, 1, NULL, NULL, NULL},
  {0x062, 1, NULL, NULL, NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0x063, 2, NULL, NULL, NULL},
  {0x065, 4, NULL, NULL, GPR15},
  {0x069, 1, NULL, NULL, NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0x06A, 1, NULL, NULL, NULL},
  {0x06B, 1, NULL, NULL, GPR4},
  {0x06C, 4, NULL, NULL, NULL},
  {0x070, 1, NULL, NULL, GPR15},
  {0x071, 1, NULL, "IEA500A", GPR15},
  {0x072, 2, NULL, NULL, GPR15},
  {0x074, 2, NULL, NULL, NULL},
  {0x076, 1, NULL, NULL, GPR15}, /* zzz reason in R15?  R5 contains rc for some reasons */
  {0x077, 1, NULL, NULL, GPR15},
  {0x078, 3, NULL, NULL, NULL},
  {0x07B, 1, NULL, NULL, GPR15},
  {0x07C, 1, NULL, NULL, NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0x07D, 1, NULL, NULL, GPR15}, /* zzz rc in R15? */
  {0x07E, 1, NULL, NULL, GPR15},
  {0x07F, 5, NULL, NULL, NULL},
  {0x083, 3, NULL, NULL, NULL},
  {0x086, 1, NULL, NULL, GPR15},
  {0x087, 1, NULL, NULL, NULL},
  {0x089, 2, NULL, NULL, NULL},
  {0x08B, 1, NULL, NULL, NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0x08C, 1, NULL, NULL, GPR15}, /* zzz R2 is SRB, R3 is return addr */
  {0x08D, 1, NULL, NULL, GPR15},
  {0x08E, 1, NULL, NULL, NULL},
  {0x08F, 1, NULL, NULL, GPR15},
  {0x090, 10, NULL, NULL, NULL},
  {0x09A, 1, NULL, NULL, NULL}, /* RC handled as 'special case' in sysabend_rc */
  {0x09B, 1, NULL, "ANFM102I,ANFM105I", NULL},  /* zzz message inserts to be created */
  {0x09D, 2, NULL, NULL, GPR15},
  {0x09F, 1, NULL, NULL, GPR15},
  {0x0A0, 1, NULL, "IEE479W", GPR15},
  {0x0A1, 5, NULL, NULL, NULL},
  {0x0A6, 1, NULL, "APS050I,APS055I",NULL},
  {0x0A7, 1, NULL, NULL, NULL},
  {0x0A8, 2, NULL, NULL, NULL}, /* RC handled as 'special case' in sysabend_rc */
  {0x0AA, 1, NULL, NULL, NULL},
  {0x0AB, 1, NULL, NULL, NULL}, /* RC handled as 'special case' in sysabend_rc */
  {0x0AC, 1, NULL, NULL, NULL}, /* RC handled as 'special case' in sysabend_rc */
  {0x0AD, 1, NULL, NULL, NULL}, /* RC handled as 'special case' in sysabend_rc */
  {0x0AE, 1, NULL, NULL, NULL},
  {0x0AF, 1, NULL, "INMR037I,INMX040I,INMX042I,INMX067I,INMX083I,INMR127I,"
                   "INMR132I,INMR133I,INMR134I,INMR137I,INMC156I,INMX204I,"
                   "INMX210I",GPR15},
  {0x0B0, 1, NULL, NULL, GPR15},
  {0x0B1, 1, NULL, "IEA513W,IEA514W,IEA515W,IEA516W,IEA517W,IEA518W",
                         NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0x0B2, 4, NULL, NULL, NULL},
  {0x0B6, 3, NULL, NULL, GPR15},
  {0x0B9, 3, NULL, NULL, NULL},
  {0x0BD, 1, NULL, NULL, NULL},
  {0x0BE, 1, NULL, "IEE480I,IEE481I,IEE839I", NULL},
  {0x0BF, 1, NULL, NULL, NULL},
  {0x0C1, 3, NULL, NULL, NULL},
  {0x0C4, 1, NULL, NULL, "PIC"},
  {0x0C5, 2, NULL, NULL, NULL},
  {0x0C7, 1, NULL, NULL, NULL}, /* RC handled as 'special case' in sysabend_rc */
  {0x0C8, 8, NULL, NULL, NULL},
  {0x0D2, 4, NULL, NULL, NULL},
  {0x0D6, 1, NULL, NULL, "PIC"},
  {0x0D7, 2, NULL, NULL, NULL},
  {0x0D9, 3, NULL, NULL, NULL},
  {0x0DC, 1, NULL, "IEF402I", "IEF402I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x0E0, 1, NULL, NULL, "PIC"},
  {0x0E1, 5, NULL, NULL, GPR15},
  {0x0E6, 1, NULL, NULL, NULL},
  {0x0E7, 2, NULL, NULL, GPR15},
  {0x0F0, 1, NULL, NULL, NULL},
  {0x0F1, 1, NULL, NULL, GPR15},
  {0x0F2, 2, NULL, NULL, NULL},
  {0x0F4, 1, NULL, NULL, GPR15},
  {0x0F6, 1, NULL, NULL, GPR15},
  {0x0F7, 1, NULL, NULL, NULL},   /* RC handled as 'special case' in sysabend_rc */
  {0x0F8, 1, NULL, NULL, NULL},   /* RC handled as 'special case' in sysabend_rc */
  {0x0F9, 1, NULL, NULL, GPR15},
  {0x0FB, 4, NULL, NULL, NULL},
  {0x0FF, 1, NULL, NULL, GPR15},
  {0x101, 1, NULL, NULL, NULL},
  {0x102, 1, NULL, NULL, GPR15},
  {0x104, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x106, 1, NULL, "CSV011I", GPR15},
  {0x10A, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x10B, 1, NULL, NULL, NULL},
  {0x10D, 2, NULL, NULL, NULL},
  {0x110, 1, NULL, NULL, NULL},
  {0x112, 1, NULL, "IEC908I", GPR15},
  {0x113, 1, NULL, "IEC142I", GPR15},
  {0x115, 1, NULL, NULL, NULL},
  {0x117, 1, NULL, "IEC218I", GPR15},
  {0x118, 1, NULL, "IEC912I", GPR15},
  {0x119, 1, NULL, "IEC914I", GPR15},
  {0x11A, 1, NULL, NULL, NULL},
  {0x121, 2, NULL, NULL, NULL},
  {0x128, 1, NULL, NULL, NULL},
  {0x12A, 1, NULL, NULL, GPR15},
  {0x12C, 3, NULL, NULL, NULL},
  {0x12F, 1, NULL, NULL, GPR15},
  {0x130, 1, NULL, NULL, NULL},
  {0x133, 1, NULL, NULL, NULL},
  {0x135, 1, NULL, "IEC903I", NULL},
  {0x137, 1, NULL, "IEC022I", "GPREGS.0x3C,IEC022I_RC"},
  {0x138, 1, NULL, NULL, NULL},
  {0x139, 1, NULL, "IEC905I", NULL},
  {0x13C, 1, NULL, NULL, GPR15},
  {0x13E, 1, NULL, NULL, NULL},
  {0x13F, 1, NULL, NULL, NULL},  /* zzz accompanied by message IHJxxxI with the appropriate reason code */
  {0x144, 1, NULL, NULL, NULL},
  {0x145, 1, NULL, "IEC916I", GPR15},
  {0x147, 1, NULL, NULL, NULL},
  {0x149, 3, NULL, NULL, NULL},
  {0x14C, 1, NULL, NULL, GPR15},
  {0x14F, 1, NULL, NULL, GPR15},
  {0x151, 1, NULL, "IEC918I", NULL},
  {0x153, 1, NULL, NULL, NULL},
  {0x157, 1, NULL, NULL, GPR15},
  {0x15B, 3, NULL, NULL, NULL},
  {0x15F, 1, NULL, NULL, GPR15},
  {0x169, 1, NULL, "IEC919I", GPR15},
  {0x16B, 1, NULL, NULL, GPR15},
  {0x16D, 2, NULL, NULL, GPR15},
  {0x171, 1, NULL, NULL, GPR0},
  {0x172, 1, NULL, NULL, NULL},
  {0x177, 1, NULL, NULL, NULL},
  {0x178, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x179, 1, NULL, NULL, GPR2},
  {0x17A, 2, NULL, NULL, NULL},
  {0x17D, 1, NULL, NULL, NULL},
  {0x182, 2, NULL, NULL, GPR15},
  {0x185, 1, NULL, NULL, GPR15},
  {0x18A, 1, NULL, NULL, GPR0},
  {0x18B, 1, NULL, "IEC606I", NULL},
  {0x18F, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0x1C5, 1, NULL, NULL, GPR15},
  {0x1C6, 1, NULL, NULL, NULL},
  {0x1C7, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0x1FA, 1, NULL, NULL, NULL},
  {0x1FB, 1, NULL, "IAT1601,IAT1602,IAT1603,IAT1604,IAT1605,IAT1606,IAT1607,"
                   "IAT1609,IAT1610,IAT1611,IAT1612,IAT1614,IAT1803,IAT6700,"
                   "IAT6703,IAT6704,IAT6707,IAT6708,IAT6711,IAT6309", NULL},
  {0x1FC, 1, NULL, NULL, NULL},
  {0x200, 1, NULL, NULL, NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0x201, 1, NULL, NULL, NULL},
  {0x202, 1, NULL, NULL, GPR15},
  {0x204, 2, NULL, NULL, NULL},
  {0x206, 1, NULL, NULL, GPR15},
  {0x20A, 1, NULL, NULL, NULL},
  {0x20D, 3, NULL, NULL, NULL},
  {0x212, 1, NULL, "IEC909I", GPR15},
  {0x213, 1, NULL, "IEC143I", GPR15},
  {0x214, 1, NULL, "IEC210I", GPR15},
  {0x215, 1, NULL, "IEC910I", GPR15},
  {0x218, 1, NULL, "IEC913I", GPR15},
  {0x219, 1, NULL, "IEC915I", GPR15},
  {0x222, 3, NULL, NULL, NULL},
  {0x228, 3, NULL, NULL, NULL},
  {0x22A, 1, NULL, NULL, GPR15},
  {0x22C, 2, NULL, NULL, NULL},
  {0x22F, 2, NULL, NULL, NULL},
  {0x233, 1, NULL, NULL, GPR15},
  {0x235, 1, NULL, "IEC902I", GPR15},
  {0x237, 1, NULL, "IEC023I", GPR15},
  {0x238, 1, NULL, NULL, NULL},
  {0x239, 1, NULL, "IEC902I", GPR15},
  {0x23E, 1, NULL, NULL, GPR15},
  {0x23F, 1, NULL, NULL, NULL},  /* zzz accompanied by message IHJxxxI with the appropriate reason code */
  {0x240, 1, NULL, "IEC155I", GPR15},
  {0x244, 1, NULL, NULL, NULL},
  {0x245, 1, NULL, "IEC917I", GPR15},
  {0x247, 1, NULL, NULL, NULL},
  {0x251, 1, NULL, "IEC918I", GPR15},
  {0x253, 1, NULL, NULL, NULL},
  {0x25F, 1, NULL, NULL, NULL},
  {0x260, 1, NULL, NULL, GPR15},
  {0x269, 1, NULL, "IEC920I", GPR15},
  {0x271, 1, NULL, NULL, NULL},
  {0x278, 1, NULL, NULL, NULL},
  {0x279, 1, NULL, NULL, GPR2},
  {0x27B, 1, NULL, NULL, NULL},
  {0x282, 2, NULL, "ICH409I", "GPREGS.0x3C,ICH409I_RC"},
  {0x285, 1, NULL, "ICH409I", "GPREGS.0x3C,ICH409I_RC"},
  {0x28A, 1, NULL, NULL, NULL},
  {0x2C6, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0x2F3, 1, NULL, NULL, NULL},
  {0x2FB, 2, NULL, NULL, NULL},
  {0x300, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0x301, 1, NULL, NULL, NULL},
  {0x302, 1, NULL, NULL, GPR15},
  {0x305, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x306, 1, NULL, "CSV013I,CSV015I,CSV019I,CSV020I,CSV024I,CSV027I,CSV025I,CSV026I", GPR15},
  {0x30A, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x30E, 1, NULL, NULL, NULL},
  {0x312, 1, NULL, "CSV222I,CSV218E", GPR15},
  {0x313, 1, NULL, "IEC144I", "GPREGS.0x3C,IEC144I_RC"},
  {0x314, 1, NULL, "IEC211I", "GPREGS.0x3C,IEC211I_RC"},
  {0x315, 1, NULL, "IEC911I", GPR15},
  {0x317, 1, NULL, "IEC220I", "GPREGS.0x3C,IEC220I_RC"},
  {0x322, 1, NULL, NULL, NULL},
  {0x328, 1, NULL, NULL, NULL},
  {0x32D, 1, NULL, NULL, NULL},
  {0x32E, 1, NULL, NULL, GPR15},
  {0x330, 1, NULL, NULL, NULL},
  {0x333, 1, NULL, "IEA794I,IEA911E,IEA611I", GPR15},
  {0x335, 1, NULL, NULL, NULL},
  {0x337, 1, NULL, "IEC024I", "GPREGS.0x3C,IEC024I_RC"},
  {0x338, 2, NULL, NULL, NULL},
  {0x33E, 1, NULL, NULL, NULL},
  {0x33F, 1, NULL, NULL, NULL}, /* zzz accompanied by message IHJxxxI with the appropriate reason code */
  {0x344, 1, NULL, NULL, NULL},
  {0x351, 1, NULL, "IEC918I", GPR15},
  {0x35F, 1, NULL, NULL, NULL},
  {0x36D, 1, NULL, NULL, GPR15},
  {0x36F, 1, NULL, NULL, NULL},
  {0x378, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x37A, 2, NULL, NULL, NULL},
  {0x37D, 1, NULL, NULL, NULL},
  {0x382, 2, NULL, NULL, GPR15},
  {0x385, 1, NULL, NULL, GPR15},
  {0x3C4, 1, NULL, NULL, GPR15},
  {0x3C5, 1, NULL, NULL, NULL},
  {0x3C6, 1, NULL, NULL, GPR15},  /* zzz other regs are interesting also */
  {0x3C7, 1, NULL, NULL, GPR15},
  {0x3FB, 1, NULL, NULL, NULL},
  {0x3FC, 1, NULL, NULL, GPR15},
  {0x400, 1, NULL, NULL, NULL},
  {0x401, 2, NULL, NULL, GPR15},
  {0x406, 1, NULL, NULL, NULL},
  {0x40A, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x40D, 1, NULL, "IEF402I", "GPREGS.0x3C,IEF402I_REASON"},
  {0x413, 1, NULL, "IEC145I", GPR15},
  {0x414, 1, NULL, "IEC212I", "GPREGS.0x3C,IEC212I_RC"},
  {0x417, 1, NULL, "IEC221I", "GPREGS.0x3C,IEC221I_RC"},
  {0x422, 1, NULL, NULL, GPR15},
  {0x42A, 1, NULL, NULL, NULL},
  {0x42D, 1, NULL, NULL, NULL},
  {0x430, 1, NULL, NULL, NULL},
  {0x433, 1, NULL, "ADY015I", GPR15},
  {0x435, 1, NULL, NULL, NULL},
  {0x437, 1, NULL, "IEC025I", "GPREGS.0x3C,IEC025I_RC"},
  {0x438, 1, NULL, NULL, NULL},
  {0x43E, 1, NULL, NULL, NULL},
  {0x43F, 1, NULL, NULL, NULL},  /* zzz accompanied by message IHJxxxI with the appropriate reason code */
  {0x444, 1, NULL, NULL, NULL},
  {0x451, 1, NULL, "IEC918I", GPR15},
  {0x453, 1, NULL, NULL, NULL},
  {0x45F, 1, NULL, NULL, NULL},
  {0x46D, 1, NULL, NULL, GPR15},
  {0x478, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x47A, 1, NULL, NULL, NULL},
  {0x47B, 1, NULL, NULL, NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0x47D, 1, NULL, NULL, NULL},
  {0x482, 2, NULL, NULL, GPR15},
  {0x485, 1, NULL, NULL, GPR15},
  {0x4C5, 1, NULL, NULL, NULL},
  {0x4C6, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0x4C7, 2, NULL, "ICH409I", "GPREGS.0x3C,ICH409I_RC"},
  {0x4FB, 2, NULL, NULL, NULL},
  {0x500, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0x502, 1, NULL, NULL, NULL},
  {0x504, 2, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x506, 1, NULL, NULL, NULL},
  {0x50D, 1, NULL, NULL, GPR15},
  {0x513, 1, NULL, "IEC146I", "GPREGS.0x3C,IEC146I_RC"},
  {0x522, 1, NULL, NULL, NULL},
  {0x52A, 1, NULL, NULL, GPR15},
  {0x530, 1, NULL, NULL, NULL},
  {0x535, 1, NULL, NULL, NULL},
  {0x538, 1, NULL, NULL, NULL},
  {0x53E, 1, NULL, NULL, NULL},
  {0x53F, 1, NULL, NULL, NULL},  /* zzz accompanied by message IHJxxxI with the appropriate reason code */
  {0x544, 1, NULL, NULL, GPR15},
  {0x553, 1, NULL, NULL, GPR15},
  {0x55F, 1, NULL, NULL, GPR15},
  {0x56D, 1, NULL, NULL, NULL},
  {0x56F, 1, NULL, NULL, NULL},
  {0x57D, 1, NULL, NULL, NULL},
  {0x582, 1, NULL, "ICH409I", "GPREGS.0x3C,ICH409I_RC"},
  {0x585, 1, NULL, "ICH409I", "GPREGS.0x3C,ICH409I_RC"},
  {0x5C4, 1, NULL, NULL, GPR15},
  {0x5C6, 1, NULL, NULL, GPR15},
  {0x5FB, 1, NULL, NULL, GPR15},
  {0x5FC, 1, NULL, NULL, NULL},
  {0x602, 1, NULL, NULL, GPR15},
  {0x604, 2, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x60D, 1, NULL, "IEA995I", "GPREGS.0x3C,IEA995I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x613, 1, NULL, "IEC147I", "GPREGS.0x3C,IEC147I_RC"},
  {0x614, 1, NULL, "IEC214I", "GPREGS.0x3C,IEC214I_RC"},
  {0x622, 1, NULL, NULL, NULL},
  {0x637, 1, NULL, "IEC026I", "GPREGS.0x3C,IEC026I_RC"},
  {0x644, 1, NULL, NULL, NULL},
  {0x65F, 1, NULL, "IRA602I", NULL},
  {0x66D, 1, NULL, NULL, GPR15},  /* zzz rc in R15? - hi-order is rc, lo-order is reason */
  {0x67D, 1, NULL, NULL, NULL},
  {0x683, 3, NULL, NULL, NULL},
  {0x6C4, 1, NULL, NULL, NULL},
  {0x6C5, 1, NULL, NULL, GPR15},
  {0x6C6, 1, NULL, "CSQV086E", NULL},  /* zzz rc in msg */
  {0x6C7, 1, NULL, NULL, GPR15},
  {0x6FB, 1, NULL, NULL, GPR15},
  {0x6FC, 1, NULL, NULL, NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0x700, 1, NULL, NULL, NULL},
  {0x702, 1, NULL, NULL, GPR15},
  {0x704, 2, NULL, NULL, NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0x706, 1, NULL, "CSV016I", NULL},
  {0x70A, 1, NULL, NULL, NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0x70D, 1, NULL, "IEA995I", "IEA995I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x713, 1, NULL, "IEC148I", "GPREGS.0x3C,IEC148I_RC"},
  {0x714, 1, NULL, "IEC215I", "GPREGS.0x3C,IEC215I_RC"},
  {0x717, 1, NULL, "IEC222I", "GPREGS.0x3C,IEC222I_RC"},
  {0x71A, 1, NULL, NULL, NULL},
  {0x722, 1, NULL, NULL, NULL},
  {0x72A, 1, NULL, NULL, GPR15},
  {0x730, 1, NULL, NULL, NULL},
  {0x737, 1, NULL, "IEC027I", "GPREGS.0x3C,IEC027I_RC"},
  {0x738, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0x744, 1, NULL, NULL, NULL},
  {0x75F, 1, NULL, NULL, NULL},
  {0x76D, 1, NULL, NULL, NULL},
  {0x778, 1, NULL, NULL, NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0x77D, 1, NULL, NULL, GPR15},
  {0x7C4, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0x7C6, 2, NULL, NULL, GPR15},
  {0x7FB, 1, NULL, NULL, NULL},
  {0x800, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0x804, 2, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x806, 1, NULL, "CSV003I,CSV004I,CSV005I,CSV006I,CSV007I,CSV008I,CSV021I", GPR15},
  {0x80A, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x813, 1, NULL, "IEC149I", "GPREGS.0x3C,IEC149I_RC"},
  {0x81A, 1, NULL, NULL, NULL},
  {0x822, 1, NULL, "IEF085I,IEF186I", NULL},
  {0x82A, 1, NULL, NULL, NULL},
  {0x830, 1, NULL, NULL, NULL},
  {0x837, 1, NULL, "IEC028I", "GPREGS.0x3C,IEC028I_RC"},
  {0x838, 1, NULL, NULL, NULL},
  {0x85F, 1, NULL, "IRA604I", GPR15},  /* zzz rc in R15? */
  {0x878, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x87D, 1, NULL, NULL, NULL},
  {0x8C4, 2, NULL, NULL, GPR15},
  {0x8C6, 1, NULL, NULL, NULL},
  {0x8C7, 1, NULL, NULL, GPR15},
  {0x8FB, 1, NULL, NULL, GPR15},
  {0x905, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x906, 1, NULL, NULL, GPR15},
  {0x90A, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x913, 1, NULL, "IEC150I", GPR15},
  {0x91A, 1, NULL, NULL, NULL},
  {0x922, 1, NULL, NULL, NULL},
  {0x92A, 1, NULL, NULL, GPR15},
  {0x930, 1, NULL, NULL, NULL},
  {0x937, 1, NULL, "IEC029I", "GPREGS.0x3C,IEC029I_RC"},
  {0x938, 1, NULL, NULL, NULL},
  {0x978, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0x9C4, 1, NULL, NULL, GPR15},
  {0x9C5, 1, NULL, "EKG1326D", GPR15},  /* zzz rc in R15? */
  {0x9C6, 1, NULL, NULL, GPR15},
  {0x9C7, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0x9FB, 1, NULL, NULL, NULL},
  {0xA00, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0xA03, 1, NULL, NULL, NULL},
  {0xA05, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0xA06, 1, NULL, NULL, NULL},
  {0xA0A, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0xA13, 1, NULL, "IEC151I", "GPREGS.0x3C,IEC151I_RC"},
  {0xA14, 1, NULL, "IEC216I", "GPREGS.0x3C,IEC216I_RC"},
  {0xA1A, 1, NULL, NULL, NULL},
  {0xA22, 2, NULL, NULL, NULL},
  {0xA37, 1, NULL, "IEC015I", "GPREGS.0x3C,IEC015I_RC"},
  {0xA78, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0xA7A, 1, NULL, NULL, NULL},   /* RC handled as 'special case' in sysabend_rc */
  {0xAC4, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0xAC5, 1, NULL, NULL, GPR15},
  {0xAC6, 1, NULL, NULL, NULL},
  {0xAC7, 1, NULL, NULL, GPR15},
  {0xAFB, 1, NULL, NULL, GPR15},
  {0xB00, 1, NULL, NULL, NULL},
  {0xB04, 2, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0xB06, 1, NULL, NULL, NULL},
  {0xB0A, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0xB13, 1, NULL, "IEC152I", "GPREGS.0x3C,IEC152I_RC"},
  {0xB14, 1, NULL, "IEC217I", "GPREGS.0x3C,IEC217I_RC"},
  {0xB1A, 1, NULL, NULL, NULL},
  {0xB23, 1, NULL, "IEE824A,IEE824E", NULL},
  {0xB2D, 1, NULL, NULL, NULL},
  {0xB37, 1, NULL, "IEC030I", "GPREGS.0x3C,IEC030I_RC"},
  {0xB78, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0xBC5, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0xBFB, 1, NULL, "IAT6352,IAT1025", NULL},
  {0xC03, 1, NULL, "IEC999I", NULL},
  {0xC0D, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0xC13, 1, NULL, "IEC153I,IEC157I", "GPREGS.0x3C,IEC153I_RC,IEC157I_RC"},
  {0xC1A, 1, NULL, NULL, NULL},
  {0xC22, 1, NULL, NULL, NULL},
  {0xC2D, 1, NULL, NULL, NULL},
  {0xC37, 1, NULL, "IEC033I", "GPREGS.0x3C,IEC033I_RC"},
  {0xC78, 1, NULL, NULL, NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0xCC4, 1, NULL, NULL, NULL},
  {0xCC5, 1, NULL, NULL, NULL},  /* RC handled as 'special case' in sysabend_rc */
  {0xCC7, 1, NULL, NULL, GPR15},
  {0xCFB, 1, NULL, "IAT3005", NULL},
  {0xD04, 2, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0xD06, 1, NULL, NULL, NULL},
  {0xD0A, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0xD0D, 1, NULL, NULL, NULL},
  {0xD13, 1, NULL, "IEC158I", "GPREGS.0x3C,IEC158I_RC"},
  {0xD14, 1, NULL, NULL, NULL},
  {0xD1A, 1, NULL, NULL, NULL},
  {0xD22, 2, NULL, NULL, GPR15},
  {0xD2D, 1, NULL, NULL, NULL},
  {0xD37, 1, NULL, "IEC031I", "GPREGS.0x3C,IEC031I_RC"},
  {0xD78, 1, NULL, "IEA705I", "IEA705I_REASON"},  /* RC handled as 'special case' in sysabend_rc */
  {0xD82, 4, NULL, "ICH409I", "GPREGS.0x3C,ICH409I_RC"},
  {0xDC5, 2, NULL, NULL, GPR0},
  {0xDC7, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0xDFB, 1, NULL, NULL, GPR15},  /* RC handled as 'special case' in sysabend_rc */
  {0xE00, 1, NULL, NULL, NULL},
  {0xE03, 1, NULL, NULL, NULL},
  {0xE06, 1, NULL, NULL, GPR15},
  {0xE13, 1, NULL, "IEC159I", "GPREGS.0x3C,IEC159I_RC"},
  {0xE1A, 1, NULL, NULL, NULL},
  {0xE23, 1, NULL, NULL, NULL},
  {0xE2D, 1, NULL, NULL, NULL},
  {0xE37, 1, NULL, "IEC032I", "GPREGS.0x3C,IEC032I_RC"},
  {0xE82, 4, NULL, NULL, NULL},
  {0xEC4, 1, NULL, NULL, NULL},
  {0xEC5, 1, NULL, NULL, GPR0},
  {0xEC6, 1, NULL, NULL, GPR15},
  {0xEC7, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0xEFB, 1, NULL, NULL, GPR15},  /* zzz rc in R15? */
  {0xF00, 255, "Fnn", NULL, NULL}, /* abend F00 through FFF */
  {-1} /* must be last entry */
/*|:epsc.*/
/*|&vellip. */
};
/*|:exmp.*/

/**************************************************************************************/
/*|:h4.struct UserAbendInfo                                                           */
/**************************************************************************************/
/*|:xmp.*/
struct {
  char *prodid;   /* product ID (for example, "CEE" for LE) */
  short code;     /* user abend code */
  short range;    /* number of consecutive codes included in this entry */
  char *altref;   /* alternative code reference */
  char *msgref;   /* message reference */
} UserAbendInfo[] = {
/*|:psc proc='x' */
  {NULL} /* must be last entry */
/*|:epsc.*/
/*|&vellip. */
};
/*|:exmp.*/

/**************************************************************************************/
/*|:h4.struct SQLCodeInfo                                                             */
/**************************************************************************************/
/*|:xmp.*/
struct {
  short code;     /* SQL code */
  short range;    /* number of consecutive codes included in this entry */
  char *altref;   /* alternative code reference */
  char *msgref;   /* message reference */
} SQLCodeInfo[] = {
/*|:psc proc='x' */
  {-911, 1, NULL, "DSNT500I"},
  {-913, 1, NULL, "DSNT500I"},
  {0} /* must be last entry */
/*|:epsc.*/
/*|&vellip. */
};
/*|:exmp.*/

/**************************************************************************************/
/*|:h4.struct SQLReasInfo                                                             */
/**************************************************************************************/
/*|:xmp.*/
struct {
  unsigned int code;  /* SQL reason code */
  short range;    /* number of consecutive codes included in this entry */
  char *altref;   /* alternative code reference */
  char *msgref;   /* message reference */
} SQLReasInfo[] = {
/*|:psc proc='x' */
  {0x00C89011, 9, "00C8901x", NULL},
  {0x00C900C0, 1, NULL, "DSNT500I"},
  {0x00D31051, 1, NULL, "DSNL052E"},
  {0x00E60100, 100, "00E601xx", NULL},
  {0} /* must be last entry */
/*|:epsc.*/
/*|&vellip. */
};
/*|:exmp.*/

/**************************************************************************************/
/*|:h4.struct CICSAbendInfo                                                           */
/**************************************************************************************/
/*|:xmp.*/
struct {
  char *code;        /* CICS abend code */
  char *ref_code;    /* Referenced CICS abend code */
} CICSAbendInfo[] = {
/*|:psc proc='x' */
  {"AEID", "AEIA"},
  {"AEIE", "AEIA"},
  {"AEIG", "AEIA"},
  {"AEIH", "AEIA"},
  {"AEII", "AEIA"},
  {"AEIJ", "AEIA"},
  {"AEIK", "AEIA"},
  {"AEIL", "AEIA"},
  {"AEIM", "AEIA"},
  {"AEIN", "AEIA"},
  {"AEIO", "AEIA"},
  {"AEIP", "AEIA"},
  {"AEIQ", "AEIA"},
  {"AEIR", "AEIA"},
  {"AEIS", "AEIA"},
  {"AEIT", "AEIA"},
  {"AEIU", "AEIA"},
  {"AEIV", "AEIA"},
  {"AEIW", "AEIA"},
  {"AEIZ", "AEIA"},
  {"AEI0", "AEIA"},
  {"AEI1", "AEIA"},
  {"AEI2", "AEIA"},
  {"AEI3", "AEIA"},
  {"AEI4", "AEIA"},
  {"AEI8", "AEIA"},
  {"AEI9", "AEIA"},
  {"AEXC", "AEIA"},
  {"AEXF", "AEIA"},
  {"AEXI", "AEIA"},
  {"AEXJ", "AEIA"},
  {"AEXK", "AEIA"},
  {"AEXL", "AEIA"},
  {"AEXV", "AEIA"},
  {"AEXW", "AEIA"},
  {"AEXX", "AEIA"},
  {"AEX0", "AEIA"},
  {"AEX1", "AEIA"},
  {"AEX2", "AEIA"},
  {"AEX3", "AEIA"},
  {"AEX5", "AEIA"},
  {"AEX6", "AEIA"},
  {"AEX7", "AEIA"},
  {"AEYA", "AEIA"},
  {"AEYB", "AEIA"},
  {"AEYC", "AEIA"},
  {"AEYE", "AEIA"},
  {"AEYG", "AEIA"},
  {"AEYH", "AEIA"},
  {"AEYJ", "AEIA"},
  {"AEYK", "AEIA"},
  {"AEYL", "AEIA"},
  {"AEYM", "AEIA"},
  {"AEYN", "AEIA"},
  {"AEYO", "AEIA"},
  {"AEYP", "AEIA"},
  {"AEYQ", "AEIA"},
  {"AEYR", "AEIA"},
  {"AEYT", "AEIA"},
  {"AEYU", "AEIA"},
  {"AEYV", "AEIA"},
  {"AEYX", "AEIA"},
  {"AEYY", "AEIA"},
  {"AEYZ", "AEIA"},
  {"AEY0", "AEIA"},
  {"AEY1", "AEIA"},
  {"AEY2", "AEIA"},
  {"AEY3", "AEIA"},
  {"AEY7", "AEIA"},
  {NULL} /* must be last entry */
/*|:epsc.*/
/*|&vellip. */
};
/*|:exmp.*/

/**************************************************************************************/
/*|:h4.struct MsgInfo                                                                 */
/*|:p.This structure is used to facilitate retrieval of message explanations through  */
/*|an alternative text ID.                                                            */
/**************************************************************************************/
/*|:xmp.*/
struct {
  char *msgno;      /* message number */
  char *altref;     /* alternative message reference */
} MsgInfo[] = {
/*|:psc proc='x' */
  {"EDC6005S", "EDC6005E"},
  {NULL} /* must be last entry */
/*|:epsc.*/
/*|&vellip. */
};
/*|:exmp.*/

/**************************************************************************************/
/*|:h4.struct MsgInsertInfo                                                           */
/*|:p.This structure is used for automatic creation of key data items containing      */
/*|extracts from console messages.                                                    */
/*|:p.Use only for extraction of hex or decimal values.                               */
/**************************************************************************************/
/*|:xmp.*/
struct {
  char *msgno;      /* message number */
  char *string;     /* string immediately preceeding value (used to locate the value in the message text) */
  char *keysuffix;  /* key suffix to be used - the prefix is the message number and a '_' */
} MsgInsertInfo[] = {
/*|:psc proc='x' */
  {"APS050I", "REASON CODE", "RC"},      /* key APS050I_RC */
  {"AVM010E", "REASON=", "REASON"},      /* key AVM010E_REASON */
  {"CSV011I", "REASON CODE", "REASON"},  /* key CSV011I_REASON */
  {"CSV011I", "RETURN CODE", "RC"},      /* key CSV011I_RC */
  {"ICH409I", "-", "RC"},                /* key ICH409I_RC */
  {"IEA705I", "-", "REASON"},            /* key IEA705I_REASON */
  {"IEA995I", "REASON CODE=", "REASON"}, /* key IEA995I_REASON */
  {"IEC015I", "A37-", "RC"},             /* key IEC015I_RC */
  {"IEC022I", "137-", "RC"},             /* key IEC022I_RC */
  {"IEC024I", "337-", "RC"},             /* key IEC024I_RC */
  {"IEC025I", "437-", "RC"},             /* key IEC025I_RC */
  {"IEC026I", "637-", "RC"},             /* key IEC026I_RC */
  {"IEC027I", "737-", "RC"},             /* key IEC027I_RC */
  {"IEC028I", "837-", "RC"},             /* key IEC028I_RC */
  {"IEC029I", "937-", "RC"},             /* key IEC029I_RC */
  {"IEC030I", "B37-", "RC"},             /* key IEC030I_RC */
  {"IEC031I", "D37-", "RC"},             /* key IEC031I_RC */
  {"IEC032I", "E37-", "RC"},             /* key IEC032I_RC */
  {"IEC033I", "C37-", "RC"},             /* key IEC033I_RC */
  {"IEC041I", "005-", "RC"},             /* key IEC041I_RC */
  {"IEC141I", "013-", "RC"},             /* key IEC141I_RC */
  {"IEC144I", "313-", "RC"},             /* key IEC144I_RC */
  {"IEC146I", "513-", "RC"},             /* key IEC146I_RC */
  {"IEC147I", "613-", "RC"},             /* key IEC147I_RC */
  {"IEC148I", "713-", "RC"},             /* key IEC148I_RC */
  {"IEC149I", "813-", "RC"},             /* key IEC149I_RC */
  {"IEC151I", "A13-", "RC"},             /* key IEC151I_RC */
  {"IEC152I", "B13-", "RC"},             /* key IEC152I_RC */
  {"IEC153I", "C13-", "RC"},             /* key IEC153I_RC */
  {"IEC156I", "03D-", "RC"},             /* key IEC156I_RC */
  {"IEC157I", "C13-", "RC"},             /* key IEC157I_RC */
  {"IEC158I", "D13-", "RC"},             /* key IEC158I_RC */
  {"IEC159I", "E13-", "RC"},             /* key IEC159I_RC */
  {"IEC161I", " ",    "RC"},             /* key IEC161I_RC */
  {"IEC211I", "314-", "RC"},             /* key IEC211I_RC */
  {"IEC212I", "414-", "RC"},             /* key IEC212I_RC */
  {"IEC214I", "614-", "RC"},             /* key IEC214I_RC */
  {"IEC215I", "714-", "RC"},             /* key IEC215I_RC */
  {"IEC216I", "A14-", "RC"},             /* key IEC216I_RC */
  {"IEC217I", "B14-", "RC"},             /* key IEC217I_RC */
  {"IEC220I", "317-", "RC"},             /* key IEC220I_RC */
  {"IEC221I", "417-", "RC"},             /* key IEC221I_RC */
  {"IEC222I", "717-", "RC"},             /* key IEC222I_RC */
  {"IEF100I", "REASON=", "REASON"},      /* key IEF100I_REASON */
  {"IEF402I", "REASON CODE", "REASON"},  /* key IEF402I_REASON */
  {NULL} /* must be last entry */
/*|:epsc.*/
/*|&vellip. */
};
/*|:exmp.*/

/**************************************************************************************/
/*|:h4.struct PicInfo                                                                 */
/*|:p.This structure is used to cross-reference a program interrupt code with its     */
/*|related explanation in the Principles of Operation manual.                         */
/**************************************************************************************/
/*|:xmp.*/
struct {
  unsigned char pic;   /* program interrupt code */
  char *docref;        /* book reference */
  char *picTitle;      /* program interrupt title */
} PicInfo[] = {
/*|:psc proc='x' */
  {0x01, "PIC01", NLST("Operation Exception")},
  {0x02, "PIC02", NLST("Privileged-Operation Exception")},
  {0x03, "PIC03", NLST("Execute Exception")},
  {0x04, "PIC04", NLST("Protection Exception")},
  {0x05, "PIC05", NLST("Addressing Exception")},
  {0x06, "PIC06", NLST("Specification Exception")},
  {0x07, "PIC07", NLST("Data Exception")},
  {0x08, "PIC08", NLST("Fixed-Point-Overflow Exception")},
  {0x09, "PIC09", NLST("Fixed-Point-Divide Exception")},
  {0x0A, "PIC0A", NLST("Decimal-Overflow Exception")},
  {0x0B, "PIC0B", NLST("Decimal-Divide Exception")},
  {0x0C, "PIC0C", NLST("HFP-Exponent-Overflow Exception")},
  {0x0D, "PIC0D", NLST("HFP-Exponent-Underflow Exception")},
  {0x0E, "PIC0E", NLST("HFP-Significance Exception")},
  {0x0F, "PIC0F", NLST("HFP-Divide Exception")},
  {0x10, "PIC10", NLST("Segment-Translation Exception")},
  {0x11, "PIC11", NLST("Page-Translation Exception")},
  {0x12, "PIC12", NLST("Translation-Specification Exception")},
  {0x13, "PIC13", NLST("Special-Operation Exception")},
  {0x15, "PIC15", NLST("Operand Exception")},
  {0x16, "PIC16", NLST("Trace-Table Exception")},
  {0x17, "PIC17", NLST("ASN-Translation-Specification Exception")},
  {0x19, "PIC19", NLST("Vector-Operation Exception")},
  {0x1C, "PIC1C", NLST("Space-Switch Event")},
  {0x1D, "PIC1D", NLST("HFP-Square-Root Exception")},
  {0x1E, "PIC1E", NLST("Unnormalized-Operand Exception")},
  {0x1F, "PIC1F", NLST("PC-Translation-Specification Exception")},
  {0x20, "PIC20", NLST("AFX-Translation Exception")},
  {0x21, "PIC21", NLST("ASX-Translation Exception")},
  {0x22, "PIC22", NLST("LX-Translation Exception")},
  {0x23, "PIC23", NLST("EX-Translation Exception")},
  {0x24, "PIC24", NLST("Primary-Authority Exception")},
  {0x25, "PIC25", NLST("Secondary-Authority Exception")},
  {0x28, "PIC28", NLST("ALET-Specification Exception")},
  {0x29, "PIC29", NLST("ALEN-Translation Exception")},
  {0x2A, "PIC2A", NLST("ALE-Sequence Exception")},
  {0x2B, "PIC2B", NLST("ASTE-Validity Exception")},
  {0x2C, "PIC2C", NLST("ASTE-Sequence Exception")},
  {0x2D, "PIC2D", NLST("Extended-Authority Exception")},
  {0x30, "PIC30", NLST("Stack-Full Exception")},
  {0x31, "PIC31", NLST("Stack-Empty Exception")},
  {0x32, "PIC32", NLST("Stack-Specification Exception")},
  {0x33, "PIC33", NLST("Stack-Type Exception")},
  {0x34, "PIC34", NLST("Stack-Operation Exception")},
  {0x40, "PIC40", NLST("Monitor Event")},
  {0x80, "PIC80", NLST("PER Event")},
  {0} /* must be last entry */
/*|:epsc.*/
/*|&vellip. */
};
/*|:exmp.*/

#pragma pack(1)

/* Note: These structures must match the DB2_INFO DSECT in IDIECDB2.COPY */
/* IDIEH.H $$SYNC IDIECDB2.COPY ******************************************/
/*************************************************************************/
/* ONLY EVER ADD NEW FIELDS TO THE END OF THIS STRUCTURE TO ENSURE       */
/* COMPATIBILITY WITH OLD FAULT ENTRIES                                  */
/*************************************************************************/
typedef struct {
  char *pSQLCA;
  void *inputHostVars;
  void *outputHostVars;
  int dbsAsid;
  short stmtType;
  unsigned short precompilerStmtNo;
  char subsystemName[4];
  char version[2];
  char release[2];
  char mod[1];
  unsigned char rdiflag1;
  char unused[2];
  char primaryAuthId[8];
  char plan[8];
  char plan_owner[9];
  char plan_bind_date[11];
  char plan_bind_time[9];
  char currentSQLId[8];
  char dbrm[8];
  char sqlca[136];
  char package_collection[18];
  char package_owner[8];
  char package_creator[8];
  char package_version[64];
  char dbrm_library[44];
  char package_qualifier[8];
  char package_create_ts[19];
  char package_bind_ts[19];
  char precompile_ts[19];
  char package_name[8];
  char dbrm_consistency_token[8];
  unsigned int dbrm_openfail : 1;  /* If 1, then the DBRM open failed */
  char groupAttachName[4];
  char odbcName[5];                /* null term, subsystemName or groupAttachName used for actual ODBC calls */
} DB2_REPORT_INFO;

typedef struct {
  DB2_REPORT_INFO rep;
  char rda[256];
  char rdi[64];
  char dbrm_unicode[130];      /* RDILPRNM */
} DB2_XFACE;

typedef struct {
  char eyeCatcher[4];
  long blockSize;
  struct DB2_INFO *pNext;
  unsigned long section;
  long rsn;
  DB2_XFACE reportInfo;
} DB2_INFO;

/**************************************************************************************/
/* SQLDA (SQL Descriptor Area) definitions                                            */
/**************************************************************************************/

/*********************************************************************
  PVAR structure format definitions

  The format is specified by the RDIFLAG1 field in the RDI

  Format     Useage                                    Description
  ------     --------------------------------------    ----------------
    0        Most embedded statements                  Compressed SQLDA
    1        Using/via descriptor and describe         Complete SQLDA
    2        Precomp - prepare and execute immediate   Str len and text
**********************************************************************/
#define RDIFPAF0  0x08   // Format 0 for output host vars
#define RDIFPAF1  0x04   // Format 1 for output host vars
#define RDIFPAF2  0x02   // Format 2 for output host vars
#define RDIFPVF0  0x80   // Format 0 for input host vars
#define RDIFPVF1  0x40   // Format 1 for input host vars
#define RDIFPVF2  0x20   // Format 2 for input host vars

typedef struct {
  char SQLDAID[8];
  unsigned int SQLDABC;
  short SQLN;
  short SQLD;
} SQLDA_HEADER;

typedef struct {
  short SQLTYPE;
  short SQLLEN;
  unsigned long SQLDATA;
  unsigned long SQLIND;
  short SQLNAMEL;
  char SQLNAME[30];
} SQLVAR1;

typedef struct {
  unsigned int SQLLONGL;
  unsigned int SQLRSVDL;
  void *SQLDATAL;
  short SQLTNAMEL;
  char SQLTNAM[30];
} SQLVAR2;

typedef struct {
  long PVARSIZE;
} COMPRESSED_PVAR_HEADER;

typedef struct {
  short PVARTYPE;
  short PVARLEN;
  unsigned long PVARADDR;
  unsigned long PVARIND;
} COMPRESSED_PVAR;

//KENICHI #pragma pack(reset)
#pragma pack(pop)

typedef struct {
  char *pCursorName;
  int nameSize;
} DB2_CURSOR_INFO;

struct CICSSYSABEND_POF {           /* Included in HD segment         */
/* NOTE: This a effectively a copy of the DDIR_POF structure in       */
/*       IDIXHSEG.H ($$SYNC).                                         */
  unsigned  DDirPofOffset;          /* CSECT offset                   */
  char      DDirPofModBDate[8];     /* Module bind date (YYYYDDD)     */
  char      DDirPofModBTime[7];     /* Module bind time (HHMMSS)      */
  char      DDirPofCsect[9];        /* CSECT name (null term)         */
  char      DDirPofModule[9];       /*Module name (var len, null term)*/
  char      DDirPofReserved[3] ;    /*                                */
};

/* This structure is used in the CICSSYSABEND key and provides data for updating
   the HD segment for CICS system abend faults */
struct CICSSYSABEND_KEYDATA {
  char abend_code[7];               /* 6-digit abend code, null-terminated */
  CICSSYSABEND_POF pof_info;        /* Pseudo point-of-failure information */
  char      DDirHdTranID[9];        /* Transaction ID                 */
  char      DDirHdTranNO[9];        /* Transaction Number             */
  char      DDirHdApplID[9];        /* Applid                         */
  char      DDirHdTermId[5];        /* Termid                         */
  char      DDirHdNetName[9];       /* Netname                        */
};

/* This structure is used to record data relating to COBOL messages IGZ0011C and IGZ0096C */
struct PROBABLE_CAUSE {
  int  addr;                        /* Load address of failing program */
  char pgmname[9];                  /* Name of failing program        */
  char cobmod[9];                   /* Name of COBOL runtime routine  */
  char dsn[45];                     /* DSN appl program loaded from   */
};

// NOTE: This key is gradually being populated with valid data.
//       Refer to the STATE key creation in IDIEDSA.C CreateEvent() for
//       information about which fields are being used so far.
typedef struct STATE {
  unsigned short invalid_gpr_map;   // A bit set to 1 indicates that the
                                    // corresponding GPR should not be used.
                                    // Bit 0 represents GPR0.
  unsigned char  amode;             // Addressing mode: 24, 31, or 64 (decimal)
  char           unused[5];         // (Not used.)
  int            gpr_sa_addr[2];    // $$ZAP - not able to use "long long" due to IDIVLOCB SPA compiler bug!
//long long      gpr_sa_addr;       // Address of primary data area from where
                                    // the GPRs were obtained.
  int            gpr_sa_type;       // Type of primary data area.
  int            psw[4];            // Program status word (see zPSW flag).
  unsigned int   ilc;               // Instruction length code.
  unsigned int   pic;               // Program interruption code.
  FAILRSN        pic_reason;        // Program interruption code reason.
  int            ep_address;        // Entry-point address.
  int            dsa_address[2];    // $$ZAP - not able to use "long long" due to IDIVLOCB SPA compiler bug!
//long long      dsa_address;       // LE DSA address.
  unsigned int   zPSW : 1,          // 0 = ESA/390 PSW (8 bytes),
                                    // 1 = z/Architecture PSW (16 bytes).
                 not_home : 1,      // Not in home ASID (registers should not
                                    // be used for addressing purposes).
                 aregs_saved : 1,   // Access registers saved.
                 fpregs_saved : 1,  // Floating point registers saved.
                 afp : 1;           // 0 = non-AFP mode (FPR 0, 2, 4, and 6
                                    //     stored consecutively),
                                    // 1 = AFP mode (FPR 0 - 15),
  union {                           // GPR 0 through 15.
    int          r31[16];           // 31-bit registers.
    int          r64[16][2];        // $$ZAP - not able to use "long long" due to IDIVLOCB SPA compiler bug!
//  long long    r64[16];           // 64-bit registers.
  } gpr;                            // (See amode flag for type of regs
                                    // (31/64)).
  int            aregs[16];         // AR 0 through 15.
  int            fpregs[16][2];     // $$ZAP - not able to use "long long" due to IDIVLOCB SPA compiler bug!
//long long      fpregs[16];        // Floating point registers (see afp flag).
} STATE;

// Values for STATE.gpr_sa_type.
#define TYPE_CIB          0
#define TYPE_DSA          1   // LE DSA (non-XPLink)
#define TYPE_EIB          2
#define TYPE_EPIE         3
#define TYPE_RB           4
#define TYPE_RTM2WA       5
#define TYPE_TACB         6
#define TYPE_TCB          7
#define TYPE_INTERTEST    8
#define TYPE_TO_XPLINK    9   // LE transition DSA to XPLink
#define TYPE_XPLINK      10   // LE XPLink DSA
#define TYPE_FROM_XPLINK 11   // LE transition DSA from XPLink

// Existing keys planned to be replaced by the STATE key:
// PSW        - 8 bytes
// GPREGS     - 16 31-bit GPRs, stored 0 through 15.
// AREGS      - 16 31-bit ARs, stored 0 through 15.
// FPREGS     - 4 or 16 64-bit FPRs, stored 0 through 15 (non-AFP, stored 0, 2,
//              4, 6 consecutively)
// AMODE      - int
// ILC        - int
// PIC        - int
// PIC_REASON - FAILRSN struct
// NOT_HOME   - int
//

