/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.view.summary.actions;

import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.view.details.DetailedHistoryFileView;
import com.ibm.etools.fa.view.details.FAHistoryFileViewData;
import com.ibm.etools.fa.view.summary.HistoryFileElement;
import com.ibm.etools.fa.view.summary.HistoryFilesContainerElement;
import com.ibm.etools.fa.view.summary.HistoryFilesView;
import com.ibm.etools.fa.view.summary.RootElement;
import com.ibm.etools.fa.view.summary.SystemElement;
import com.ibm.etools.fa.view.summary.TreeElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;

public abstract class HistoryFileViewAction
implements IViewActionDelegate {
    protected IViewPart view;
    protected TreeElement selectedElement;

    public void init(IViewPart view) {
        this.view = view;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel = (IStructuredSelection)selection;
        this.selectedElement = (TreeElement)sel.getFirstElement();
    }

    protected void refreshView() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage activePage = FAPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                HistoryFilesView faView = (HistoryFilesView)activePage.findView("com.ibm.etools.fa.view.summary.HistoryFilesView");
                faView.refresh();
            }
        });
    }

    protected void expandView(TreeElement element, int level) {
        IWorkbenchPage activePage = FAPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        HistoryFilesView faView = (HistoryFilesView)activePage.findView("com.ibm.etools.fa.view.summary.HistoryFilesView");
        faView.expand(element, level);
        faView.refresh();
    }

    protected void removeAllChildren(TreeElement element) {
        element.removeAllChildren();
        this.refreshView();
    }

    protected HistoryFileElement addNewHistoryFile(FAHistoryFileViewData data, RootElement root) {
        SystemElement systemElement = new SystemElement(data.getSystemAliasName());
        systemElement = (SystemElement)root.addIfNew(systemElement);
        HistoryFilesContainerElement histFileContainerEle = new HistoryFilesContainerElement();
        histFileContainerEle = (HistoryFilesContainerElement)systemElement.addIfNew(histFileContainerEle);
        HistoryFileElement histFileElement = new HistoryFileElement(data.getHistFileName(), data);
        histFileElement = (HistoryFileElement)histFileContainerEle.addIfNew(histFileElement);
        this.expandView(root, 3);
        return histFileElement;
    }

    protected void openErrorThreadSafe(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            }
        });
    }

    protected DetailedHistoryFileView getDetailedHistoryFileView() throws Exception {
        IWorkbenchPage activePage = FAPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        DetailedHistoryFileView view = (DetailedHistoryFileView)activePage.showView("com.ibm.etools.fa.view.details.DetailedHistoryFileView");
        return view;
    }
}

