/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.view.summary.actions;

import com.ibm.etools.fa.jobs.RetrieveIspfProfileJob;
import com.ibm.etools.fa.pages.RetrieveHistoryFileInfoPage;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.subsystem.FASubSystem;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.util.RSESystemManagement;
import com.ibm.etools.fa.view.summary.RootElement;
import com.ibm.etools.fa.view.summary.SystemElement;
import com.ibm.etools.fa.view.summary.actions.HistoryFileViewAction;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AddRecentryUsedHistoryFilesFromIspfProfile
extends HistoryFileViewAction {
    public static final String RECENTLY_USED_HISTORY_FILES_CACHE_FILE_EXTENSION = "ispfHistFilesCache";

    public void run(IAction action) {
        try {
            RootElement selectedRoot = (RootElement)this.selectedElement;
            FASubSystem[] faSubSystems = RSESystemManagement.getAllFASubSystems();
            if (faSubSystems == null || faSubSystems.length == 0) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("HistoryFilesView.NoSubSysTitle"), (String)NLS.getString("HistoryFilesView.NoSubSysMsg"));
                return;
            }
            String[] systemNames = new String[faSubSystems.length];
            int i = 0;
            while (i < faSubSystems.length) {
                systemNames[i] = faSubSystems[i].getSystemConnection().getAliasName();
                ++i;
            }
            RetrieveHistoryFileInfoPage page = new RetrieveHistoryFileInfoPage(Display.getCurrent().getActiveShell(), systemNames);
            if (page.open() != 0) {
                return;
            }
            String selectedSystemName = page.getSelectedSystemName();
            String execName = page.getExecName();
            String ispfProfDsn = page.getIspfProfDsn();
            String tmpDsn = page.getTmpDsn();
            String appID = page.getAppID();
            SystemElement systemElement = new SystemElement(selectedSystemName);
            systemElement = (SystemElement)selectedRoot.addIfNew(systemElement);
            System.out.println("Retrieving history file information for " + selectedSystemName);
            String projPath = String.valueOf(selectedSystemName) + File.separator;
            String fileName = String.valueOf(projPath) + ispfProfDsn + "." + RECENTLY_USED_HISTORY_FILES_CACHE_FILE_EXTENSION;
            IFile file = FAPlugin.getDefault().getFile(fileName);
            System.out.println(file.getLocation().toString());
            System.out.println(file.getParent().getLocation().toString());
            RetrieveIspfProfileJob job = new RetrieveIspfProfileJob(selectedSystemName, systemElement, String.valueOf(file.getParent().getLocation().toString()) + File.separator, String.valueOf(ispfProfDsn) + "." + RECENTLY_USED_HISTORY_FILES_CACHE_FILE_EXTENSION, execName, ispfProfDsn, tmpDsn, appID);
            job.runJob();
        }
        catch (Exception e) {
            FAPlugin.getDefault().log(4, NLS.getString("AddRecentryUsedHistoryFilesFromIspfProfile.ErrMsg"), e, true);
            return;
        }
    }
}

