/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pages;

import com.ibm.etools.fa.pages.HistoryFileColumnSelectionPage;
import com.ibm.etools.fa.util.GUIUtility;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.view.details.ColumnConfigurationData;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnConfigSelectionPage
extends TitleAreaDialog {
    private boolean cancelButtonPressed = false;
    private int selectionIndex = 0;
    private ArrayList<ColumnConfigurationData> configDataList;
    private List configList;
    private Button addButton;
    private Button updateButton;
    private Button deleteButton;

    public ColumnConfigSelectionPage(Shell parentShell, ArrayList<ColumnConfigurationData> configDataList, ColumnConfigurationData currentSelection) {
        super(parentShell);
        this.configDataList = configDataList;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(NLS.getString("ColumnConfigSelectionPage.Title"));
        this.setMessage(NLS.getString("ColumnConfigSelectionPage.Msg"));
        Composite mainComposite = GUIUtility.createComposite(parent, 1);
        this.createConfigDataList(mainComposite);
        this.createButtons(mainComposite);
        return mainComposite;
    }

    private void createConfigDataList(Composite parent) {
        Composite listComposite = GUIUtility.createComposite(parent, 1);
        GridData compositeData = new GridData();
        compositeData.horizontalAlignment = 4;
        compositeData.verticalAlignment = 4;
        compositeData.grabExcessHorizontalSpace = true;
        compositeData.grabExcessVerticalSpace = true;
        listComposite.setLayoutData((Object)compositeData);
        this.configList = new List(listComposite, 832);
        GridData listData = new GridData();
        listData.horizontalAlignment = 4;
        listData.verticalAlignment = 4;
        listData.grabExcessHorizontalSpace = true;
        listData.grabExcessVerticalSpace = true;
        listData.heightHint = this.configList.getFont().getFontData()[0].getHeight() * 20;
        this.configList.setLayoutData((Object)listData);
        int i = 0;
        while (i < this.configDataList.size()) {
            ColumnConfigurationData data = this.configDataList.get(i);
            this.configList.add(data.getConfigDataName());
            ++i;
        }
        this.configList.setSelection(0);
        ListViewer viewer = new ListViewer(this.configList);
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ColumnConfigSelectionPage.this.okPressed();
            }
        });
    }

    private void createButtons(Composite parent) {
        Composite buttonComposite = GUIUtility.createComposite(parent, 3);
        buttonComposite.setLayout((Layout)new FillLayout());
        this.addButton = new Button(buttonComposite, 8);
        this.addButton.setText(NLS.getString("Add"));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HistoryFileColumnSelectionPage page = new HistoryFileColumnSelectionPage(Display.getCurrent().getActiveShell(), new ColumnConfigurationData(""));
                if (page.open() != 0) {
                    return;
                }
                ColumnConfigurationData newData = page.getNewColumnConfiguration();
                ColumnConfigSelectionPage.this.configDataList.add(newData);
                ColumnConfigSelectionPage.this.configList.add(newData.getConfigDataName());
                ColumnConfigSelectionPage.this.configList.redraw();
                ColumnConfigSelectionPage.this.configList.setSelection(ColumnConfigSelectionPage.this.configList.getItemCount() - 1);
            }
        });
        this.updateButton = new Button(buttonComposite, 8);
        this.updateButton.setText(NLS.getString("Update"));
        this.updateButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ColumnConfigSelectionPage.this.configList.getSelectionIndex();
                if (selectionIndex != -1) {
                    ColumnConfigurationData selectedConfigData = (ColumnConfigurationData)ColumnConfigSelectionPage.this.configDataList.get(selectionIndex);
                    HistoryFileColumnSelectionPage page = new HistoryFileColumnSelectionPage(Display.getCurrent().getActiveShell(), selectedConfigData);
                    if (page.open() != 0) {
                        return;
                    }
                }
            }
        });
        this.deleteButton = new Button(buttonComposite, 8);
        this.deleteButton.setText(NLS.getString("Delete"));
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ColumnConfigSelectionPage.this.configDataList.size() == 1) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("ColumnConfigSelectionPage.LastConfigErrTitle"), (String)NLS.getString("ColumnConfigSelectionPage.LastConfigErrMsg"));
                    return;
                }
                int selectionIndex = ColumnConfigSelectionPage.this.configList.getSelectionIndex();
                if (selectionIndex != -1 && MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("ColumnConfigSelectionPage.DeleteConfigConfirmTitle"), (String)NLS.getString("ColumnConfigSelectionPage.DeleteConfigConfirmMsg"))) {
                    ColumnConfigSelectionPage.this.configDataList.remove(selectionIndex);
                    ColumnConfigSelectionPage.this.configList.remove(selectionIndex);
                    ColumnConfigSelectionPage.this.configList.redraw();
                }
            }
        });
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void cancelPressed() {
        this.cancelButtonPressed = true;
        super.cancelPressed();
    }

    public boolean close() {
        if (this.cancelButtonPressed) {
            return super.close();
        }
        this.selectionIndex = this.configList.getSelectionIndex();
        return super.close();
    }

    public int getSelectionIndex() {
        return this.selectionIndex;
    }

    public ArrayList<ColumnConfigurationData> getNewColumnConfigDataList() {
        return this.configDataList;
    }
}

