/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.util.FileUtils;
import com.installshield.util.LocaleUtils;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public class TextDisplayPanel
extends WizardPanel {
    public static final int TEXT_CONTENT_TYPE = 1;
    public static final int HTML_CONTENT_TYPE = 2;
    public static final int TEXT_PROPERTY = 1;
    public static final int LOCAL_FILE = 2;
    private static final int LOCALE_SCOPE_NO_LOCALE = 0;
    private static final int LOCALE_SCOPE_LANGUAGE = 1;
    private static final int LOCALE_SCOPE_COUNTRY = 2;
    private static final int LOCALE_SCOPE_VARIANT = 3;
    private String text = "$L(com.installshield.wizardx.i18n.WizardXResources, TextDisplayPanel.text)";
    private int textSource = 1;
    private String fileEncoding = "";
    private String fileName = "";
    private boolean includeLocalizedFiles = false;
    private int contentType = 2;
    private boolean showBorder = false;
    private boolean resolveFileContents = false;
    private String busyMessage = "";

    public TextDisplayPanel() {
        this.setDescription("$L(com.installshield.wizardx.i18n.WizardXResources, TextDisplayPanel.description)");
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        try {
            wizardBuilderSupport.putResourceBundles("com.installshield.wizardx.i18n.WizardXResources");
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
        if (this.getTextSource() == 2) {
            this.fileName = this.resolveString(this.fileName, "fileName", wizardBuilderSupport);
            if (this.fileName == null) {
                return;
            }
            this.buildFile(wizardBuilderSupport, this.fileName, null);
            if (this.includeLocalizedFiles) {
                Locale[] localeArray = wizardBuilderSupport.getSelectedLocales();
                int n = 0;
                while (n < localeArray.length) {
                    this.buildFile(wizardBuilderSupport, this.fileName, localeArray[n]);
                    ++n;
                }
            }
        }
    }

    private void buildFile(WizardBuilderSupport wizardBuilderSupport, String string, Locale locale) {
        try {
            File file = locale != null ? new File(LocaleUtils.createLocalizedFileName(string, locale, 3)) : new File(string);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                wizardBuilderSupport.putResource(fileInputStream, this.createStorageName(string, locale, 3));
            } else {
                wizardBuilderSupport.logEvent(this, locale == null ? "err" : "wrn", String.valueOf(String.valueOf(file)) + " does not exist");
            }
        }
        catch (IOException iOException) {
            this.logEvent(this, "wrn", iOException);
        }
    }

    private String createStorageName(String string, Locale locale, int n) {
        String string2 = new String();
        if (locale != null) {
            string = LocaleUtils.createLocalizedFileName(string, locale, n);
        }
        string2 = String.valueOf(this.getBeanId()) + "_" + FileUtils.getName(string);
        return string2;
    }

    private byte[] examineBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] == 13 && n2 + 1 < byArray.length && byArray[n2 + 1] == 10) {
                ++n2;
            }
            byArray2[n++] = byArray[n2];
            ++n2;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    public String getBusyMessage() {
        return this.busyMessage;
    }

    public int getContentType() {
        return this.contentType;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public String getFileName() {
        return this.fileName;
    }

    private InputStream getFileResource(String string) throws IOException {
        InputStream inputStream;
        if (this.includeLocalizedFiles) {
            String string2 = this.createStorageName(string, Locale.getDefault(), 3);
            try {
                inputStream = this.getResource(string2).openStream();
            }
            catch (IOException iOException) {
                try {
                    string2 = this.createStorageName(string, Locale.getDefault(), 2);
                    inputStream = this.getResource(string2).openStream();
                }
                catch (IOException iOException2) {
                    try {
                        string2 = this.createStorageName(string, Locale.getDefault(), 1);
                        inputStream = this.getResource(string2).openStream();
                    }
                    catch (IOException iOException3) {
                        this.logEvent(this, "wrn", "could not open resource for " + string2);
                        inputStream = this.getResource(this.createStorageName(string, null, 0)).openStream();
                    }
                }
            }
        } else {
            inputStream = this.getResource(this.createStorageName(string, null, 0)).openStream();
        }
        return inputStream;
    }

    public boolean getIncludeLocalizedFiles() {
        return this.includeLocalizedFiles;
    }

    public String getText() {
        return this.text;
    }

    protected String getTextImpl() {
        if (this.getTextSource() == 2) {
            String string = this.readTextSource();
            if (this.isResolveFileContents()) {
                return this.resolveString(string);
            }
            return string;
        }
        return this.resolveString(this.getText());
    }

    public int getTextSource() {
        return this.textSource;
    }

    public boolean isResolveFileContents() {
        return this.resolveFileContents;
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        String string = this.resolveString(this.busyMessage);
        if (string != null && string.length() > 0) {
            wizardBeanEvent.getUserInterface().setBusy(string);
        }
        return super.queryEnter(wizardBeanEvent);
    }

    private String readTextSource() {
        String string;
        block8: {
            if (this.fileName == null || this.fileName.equals("")) {
                return "";
            }
            string = "";
            InputStream inputStream = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            try {
                inputStream = this.getFileResource(this.fileName);
                byteArrayOutputStream = new ByteArrayOutputStream();
                FileUtils.copy(inputStream, byteArrayOutputStream);
                string = this.fileEncoding == null || this.fileEncoding.trim().length() <= 0 ? new String(this.examineBytes(byteArrayOutputStream.toByteArray())) : new String(this.examineBytes(byteArrayOutputStream.toByteArray()), this.fileEncoding);
                inputStream.close();
                byteArrayOutputStream.close();
            }
            catch (Throwable throwable) {
                this.logEvent(this, "wrn", throwable);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (byteArrayOutputStream == null) break block8;
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return string;
    }

    public void setBusyMessage(String string) {
        this.busyMessage = string;
    }

    public void setContentType(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("invalid content type");
        }
        this.contentType = n;
        this.propertyChanged("contentType");
    }

    public void setFileEncoding(String string) {
        this.fileEncoding = string;
        this.propertyChanged("fileEncoding");
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.propertyChanged("fileName");
    }

    public void setIncludeLocalizedFiles(boolean bl) {
        this.includeLocalizedFiles = bl;
        this.propertyChanged("includeLocalizedFiles");
    }

    public void setResolveFileContents(boolean bl) {
        this.resolveFileContents = bl;
        this.propertyChanged("resolveFileContents");
    }

    public void setShowBorder(boolean bl) {
        this.showBorder = bl;
        this.propertyChanged("showBorder");
    }

    public void setText(String string) {
        this.text = string;
        this.propertyChanged("text");
    }

    public void setTextSource(int n) {
        this.textSource = n;
        this.propertyChanged("textSource");
    }
}

