/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ascii;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizardx.ascii.AbstractUpdate;
import com.installshield.wizardx.ascii.AsciiFileUpdateSupport;
import com.installshield.wizardx.ascii.ModifyFile;
import com.installshield.wizardx.ascii.Update;

public class SetVariable
extends AbstractUpdate
implements Update,
Cloneable,
PropertyAccessible {
    private String variableName = new String();
    private String variableValue = new String();
    private int location = 0;
    private String separator = new String();
    private boolean respectCase = false;
    public static final String TYPE_DESCRIPTION = "Set Variable";

    public Object clone() {
        SetVariable setVariable = (SetVariable)super.clone();
        setVariable.variableName = this.variableName;
        setVariable.variableValue = this.variableValue;
        setVariable.location = this.location;
        return setVariable;
    }

    public boolean execute(ModifyFile modifyFile) {
        boolean bl = false;
        if (this.getVariableName() == null || this.getVariableName().length() == 0) {
            modifyFile.getLogAdd().addElement("Set Variable requires Variable Name.");
        } else if (this.getVariableValue() == null || this.getVariableValue().length() == 0) {
            modifyFile.getLogAdd().addElement("Set Variable requires Variable Value.");
        } else {
            modifyFile.setLocation(this.getLocation());
            modifyFile.setCaseSensitive(this.getRespectCase());
            bl = modifyFile.setVariable(modifyFile.resolveString(this.getVariableName()), modifyFile.resolveString(this.getVariableValue()), modifyFile.resolveString(this.getSeparator()));
            modifyFile.setASCIISearchResults(null);
        }
        return bl;
    }

    public int getLocation() {
        return this.location;
    }

    public boolean getRespectCase() {
        return this.respectCase;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getShortDescription() {
        String string = new String();
        String string2 = "\" to variable: ";
        if (this.getLocation() == 0) {
            string = "Append \"";
        } else if (this.getLocation() == 1) {
            string = "Prepend \"";
        } else if (this.getLocation() == 2) {
            string = "Replace \"";
        } else {
            string = "Delete \"";
            string2 = "\" from variable: ";
        }
        return String.valueOf(string) + this.getVariableValue() + string2 + this.getVariableName();
    }

    public String getTypeDescription() {
        return TYPE_DESCRIPTION;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableValue() {
        return this.variableValue;
    }

    public void setLocation(int n) {
        this.location = n;
    }

    public void setRespectCase(boolean bl) {
        this.respectCase = bl;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public void setVariableValue(String string) {
        this.variableValue = string;
    }

    public void verify(AsciiFileUpdateSupport asciiFileUpdateSupport) {
        if (this.getVariableName() == null || this.getVariableName().length() == 0) {
            asciiFileUpdateSupport.logEvent(this, "wrn", "Set Variable requires Variable Name.");
        }
        if (this.getVariableValue() == null || this.getVariableValue().length() == 0) {
            asciiFileUpdateSupport.logEvent(this, "wrn", "Set Variable requires Variable Value.");
        }
    }
}

