/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ascii;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizardx.ascii.AbstractUpdate;
import com.installshield.wizardx.ascii.AsciiFileUpdateSupport;
import com.installshield.wizardx.ascii.ModifyFile;
import com.installshield.wizardx.ascii.Update;

public class DeleteLine
extends AbstractUpdate
implements Update,
Cloneable,
PropertyAccessible {
    private int deleteOption = 0;
    private String deleteText = new String();
    public static final int LINE = 0;
    public static final int TEXT = 1;
    public static final String TYPE_DESCRIPTION = "Delete Line/Text";

    public Object clone() {
        DeleteLine deleteLine = (DeleteLine)super.clone();
        deleteLine.deleteOption = this.deleteOption;
        deleteLine.deleteText = this.deleteText;
        return deleteLine;
    }

    public boolean execute(ModifyFile modifyFile) {
        boolean bl = false;
        if (this.getDeleteOption() == 1 && (this.getDeleteText() == null || this.getDeleteText().length() == 0)) {
            modifyFile.getLogAdd().addElement("Delete Line/Text requires Delete Text if Delete Option is Text.");
        } else if (modifyFile.getASCIISearchResults() != null && modifyFile.getASCIISearchResults().length > 0) {
            if (this.getDeleteOption() == 1) {
                bl = modifyFile.deleteText(modifyFile.resolveString(this.getDeleteText()));
            } else {
                modifyFile.deleteLine();
                bl = true;
            }
            modifyFile.setASCIISearchResults(null);
        }
        return bl;
    }

    public int getDeleteOption() {
        return this.deleteOption;
    }

    public String getDeleteText() {
        return this.deleteText;
    }

    public String getShortDescription() {
        if (this.getDeleteOption() == 0) {
            return "Delete Line";
        }
        return "Delete Text: " + this.getDeleteText();
    }

    public String getTypeDescription() {
        return TYPE_DESCRIPTION;
    }

    public void setDeleteOption(int n) {
        this.deleteOption = n;
    }

    public void setDeleteText(String string) {
        this.deleteText = string;
    }

    public void verify(AsciiFileUpdateSupport asciiFileUpdateSupport) {
        if (this.getDeleteOption() == 1 && (this.getDeleteText() == null || this.getDeleteText().length() == 0)) {
            asciiFileUpdateSupport.logEvent(this, "wrn", "Delete Line/Text requires Delete Text if Delete Option is Text.");
        }
    }
}

