/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.win32service;

import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.platform.win32.Win32Service;
import com.installshield.wizard.service.ServiceException;
import java.util.Dictionary;

public class WindowsServiceControlAction
extends WizardAction {
    private String name = "";
    private int control = 1;
    private boolean logErrorOnFailure = false;
    private String description = "$L(com.installshield.wizard.platform.win32.i18n.Win32Resources, windowsServiceControlAction.progress, ...)";

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        wizardBuilderSupport.putRequiredService("win32Service");
    }

    public Dictionary buildCategories() {
        Dictionary dictionary = super.buildCategories();
        dictionary.put("win32ppk", "");
        return dictionary;
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        this.getState().setStatusDescription(this.resolveString(this.description));
        try {
            Win32Service win32Service = (Win32Service)this.getService("win32Service");
            win32Service.controlNTService(this.resolveString(this.name), this.control);
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, this.logErrorOnFailure ? "err" : "wrn", serviceException);
        }
    }

    public int getControl() {
        return this.control;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getLogErrorOnFailure() {
        return this.logErrorOnFailure;
    }

    public String getName() {
        return this.name;
    }

    private void resolveStrings(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = this.resolveString(stringArray[n]);
                ++n;
            }
        }
    }

    public void setControl(int n) {
        this.control = n;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setLogErrorOnFailure(boolean bl) {
        this.logErrorOnFailure = bl;
    }

    public void setName(String string) {
        this.name = string;
    }
}

