/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.win32service;

import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.wizard.platform.win32.Win32Service;
import com.installshield.wizard.platform.win32.win32service.NTServiceConfig;
import com.installshield.wizard.platform.win32.win32service.Win2kServiceFailureActions;
import com.installshield.wizard.platform.win32.win32service.Win32ServiceUtils;
import com.installshield.wizard.service.ServiceException;
import java.util.Dictionary;
import java.util.Vector;

public class WindowsService
extends ProductAction {
    private String name = "";
    private NTServiceConfig config = new NTServiceConfig();
    private boolean enableFailureActions = false;
    private Win2kServiceFailureActions failureActions = new Win2kServiceFailureActions();
    private String serviceDescription = "";
    private boolean startAfterInstalling = true;
    private Vector startArguments = new Vector();
    private boolean removeOnUninstall = false;
    private String installedName = "";

    public void build(ProductBuilderSupport productBuilderSupport) {
        this.config.validateForBuild(productBuilderSupport, this);
        productBuilderSupport.putRequiredService("win32Service");
    }

    public Dictionary buildCategories() {
        Dictionary dictionary = super.buildCategories();
        dictionary.put("win32ppk", "");
        return dictionary;
    }

    public NTServiceConfig getConfig() {
        return this.config;
    }

    public boolean getEnableFailureActions() {
        return this.enableFailureActions;
    }

    public Win2kServiceFailureActions getFailureActions() {
        return this.failureActions;
    }

    public String getInstalledName() {
        return this.installedName;
    }

    public String getName() {
        return this.name;
    }

    public boolean getRemoveOnUninstall() {
        return this.removeOnUninstall;
    }

    public String getServiceDescription() {
        return this.serviceDescription;
    }

    public boolean getStartAfterInstalling() {
        return this.startAfterInstalling;
    }

    public String[] getStartArguments() {
        Object[] objectArray = new String[this.startArguments.size()];
        this.startArguments.copyInto(objectArray);
        return objectArray;
    }

    public void install(ProductActionSupport productActionSupport) throws ProductException {
        Win32Service win32Service = null;
        this.installedName = this.resolveString(this.name);
        NTServiceConfig nTServiceConfig = this.config.resolve(this.getServices());
        Win2kServiceFailureActions win2kServiceFailureActions = this.failureActions.resolve(this.getServices());
        try {
            win32Service = (Win32Service)this.getService("win32Service");
            String[] stringArray = this.getStartArguments();
            this.resolveStrings(stringArray);
            Win32ServiceUtils.installService(win32Service, this.installedName, nTServiceConfig, this.enableFailureActions, win2kServiceFailureActions, this.resolveString(this.serviceDescription), this.startAfterInstalling, stringArray, this, this);
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            throw new ProductException(serviceException);
        }
    }

    private void resolveStrings(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = this.resolveString(stringArray[n]);
                ++n;
            }
        }
    }

    public void setConfig(NTServiceConfig nTServiceConfig) {
        this.config = nTServiceConfig;
    }

    public void setEnableFailureActions(boolean bl) {
        this.enableFailureActions = bl;
    }

    public void setFailureActions(Win2kServiceFailureActions win2kServiceFailureActions) {
        this.failureActions = win2kServiceFailureActions;
    }

    public void setInstalledName(String string) {
        this.installedName = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setRemoveOnUninstall(boolean bl) {
        this.removeOnUninstall = bl;
    }

    public void setServiceDescription(String string) {
        this.serviceDescription = string;
    }

    public void setStartAfterInstalling(boolean bl) {
        this.startAfterInstalling = bl;
    }

    public void setStartArguments(String[] stringArray) {
        this.startArguments.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            this.startArguments.addElement(stringArray[n]);
            ++n;
        }
    }

    public void uninstall(ProductActionSupport productActionSupport) throws ProductException {
        if (!this.removeOnUninstall) {
            return;
        }
        try {
            Win32Service win32Service = (Win32Service)this.getService("win32Service");
            Win32ServiceUtils.deleteService(win32Service, this.installedName, this, this);
        }
        catch (ServiceException serviceException) {
            productActionSupport.logEvent(this, "err", "Unable to uninstall the Windows service: " + this.installedName);
        }
    }
}

