/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.util.LibraryLoader;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.service.ServiceBuilderSupport;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.IOException;
import java.net.URL;

public class Win32Utils {
    public static final String WINDOWS_PRODUCT_ACTION_CATEGORIES = " '/Actions/Platform Specific/Windows' '/Platform Specific/Windows/Actions' ";
    public static final String WINDOWS_WIZARD_ACTION_CATEGORIES = " '/Actions/Platform Specific/Windows' '/Platform Specific/Windows/Actions' ";
    public static final String WINDOWS_CONDITION_CATEGORIES = "'/Platform Specific/Windows'";
    public static final String JVM_VERIFY_CLASS_NAME = "Verify.jar";
    public static final String LAUNCHER_NAME = "LauncherMain.exe";
    public static final String CONSOLE_LAUNCHER_NAME = "ConsoleLauncher.exe";
    public static final String NATIVE_X86_DLL_NAME = "win32ppk.dll";
    public static final String NATIVE_IA64_DLL_NAME = "win64ppk.dll";
    public static final String ISJECLN_NAME = "isjecln.exe";
    private static final String PPK_SUB_DIR = "win32ppk/";
    private static final String IA64_SUB_DIR = "ia64/";

    public static void addHelperClassesToArchive(ServiceBuilderSupport serviceBuilderSupport) throws IOException {
        serviceBuilderSupport.putClass("com.installshield.wizard.platform.win32.Win32Platform");
        serviceBuilderSupport.putClass("com.installshield.wizard.platform.win32.Win32Utils");
    }

    public static void addNativeSupportToArchive(ServiceBuilderSupport serviceBuilderSupport, WizardServices wizardServices) throws IOException {
        String[] stringArray = new String[]{NATIVE_X86_DLL_NAME, "ia64/win64ppk.dll", ISJECLN_NAME, "ia64/isjecln.exe", JVM_VERIFY_CLASS_NAME};
        int n = 0;
        while (n < stringArray.length) {
            String string = String.valueOf(Win32Utils.getWin32PPKSubdir()) + stringArray[n];
            URL uRL = wizardServices.getResource(string);
            serviceBuilderSupport.putResource(uRL, string);
            ++n;
        }
    }

    public static String getJNIDLLName() {
        if (System.getProperty("os.arch").equalsIgnoreCase("ia64")) {
            return NATIVE_IA64_DLL_NAME;
        }
        return NATIVE_X86_DLL_NAME;
    }

    public static String getJNIDLLResourceName() {
        if (System.getProperty("os.arch").equalsIgnoreCase("ia64")) {
            return String.valueOf(Win32Utils.getWin32PPKSubdir()) + IA64_SUB_DIR + Win32Utils.getJNIDLLName();
        }
        return String.valueOf(Win32Utils.getWin32PPKSubdir()) + Win32Utils.getJNIDLLName();
    }

    public static String getPlatformCleanupResource() {
        if (System.getProperty("os.arch").equalsIgnoreCase("ia64")) {
            return String.valueOf(Win32Utils.getWin32PPKSubdir()) + IA64_SUB_DIR + ISJECLN_NAME;
        }
        return String.valueOf(Win32Utils.getWin32PPKSubdir()) + ISJECLN_NAME;
    }

    public static String getPlatformConsoleLauncherResource() {
        if (System.getProperty("os.arch").equalsIgnoreCase("ia64")) {
            return String.valueOf(Win32Utils.getWin32PPKSubdir()) + IA64_SUB_DIR + CONSOLE_LAUNCHER_NAME;
        }
        return String.valueOf(Win32Utils.getWin32PPKSubdir()) + CONSOLE_LAUNCHER_NAME;
    }

    public static String getPlatformLauncherResource() {
        if (System.getProperty("os.arch").equalsIgnoreCase("ia64")) {
            return String.valueOf(Win32Utils.getWin32PPKSubdir()) + IA64_SUB_DIR + LAUNCHER_NAME;
        }
        return String.valueOf(Win32Utils.getWin32PPKSubdir()) + LAUNCHER_NAME;
    }

    public static String getVerifyClassResource() {
        return String.valueOf(Win32Utils.getWin32PPKSubdir()) + JVM_VERIFY_CLASS_NAME;
    }

    public static String getWin32ConsoleLauncherResource() {
        return String.valueOf(Win32Utils.getWin32PPKSubdir()) + CONSOLE_LAUNCHER_NAME;
    }

    public static String getWin32LauncherResource() {
        return String.valueOf(Win32Utils.getWin32PPKSubdir()) + LAUNCHER_NAME;
    }

    public static String getWin32PPKSubdir() {
        return PPK_SUB_DIR;
    }

    public static String getWindowsIA64ConsoleLauncherResource() {
        return String.valueOf(Win32Utils.getWin32PPKSubdir()) + IA64_SUB_DIR + CONSOLE_LAUNCHER_NAME;
    }

    public static String getWindowsIA64LauncherResource() {
        return String.valueOf(Win32Utils.getWin32PPKSubdir()) + IA64_SUB_DIR + LAUNCHER_NAME;
    }

    public static void loadDLL(URL uRL, String string) {
        try {
            if (System.getProperty("is.debug") != null) {
                System.out.println("Loading DLL " + uRL);
            }
            LibraryLoader.loadLibrary(uRL, string);
        }
        catch (Throwable throwable) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32Utils.cannotLoadJniDll", new String[]{uRL.toString()}));
            throwable.printStackTrace();
        }
    }

    public static int registerDLL(SystemUtilService systemUtilService, String string, boolean bl) throws IOException, InterruptedException, ServiceException {
        int n = -1;
        String string2 = "\"" + string + "\"";
        if (!bl) {
            String[] stringArray = new String[]{"regsvr32.exe", "/s", string2};
            Process process = Runtime.getRuntime().exec(stringArray);
            process.waitFor();
            n = process.exitValue();
        } else {
            String string3 = "regsvr32.exe /s " + string2;
            systemUtilService.addSystemStartupCommand(string3);
            n = 0;
        }
        return n;
    }

    public static int unregisterDLL(SystemUtilService systemUtilService, String string, boolean bl) throws IOException, InterruptedException, ServiceException {
        int n = -1;
        String string2 = "\"" + string + "\"";
        if (!bl) {
            String[] stringArray = new String[]{"regsvr32.exe", "/u", "/s", string2};
            Process process = Runtime.getRuntime().exec(stringArray);
            process.waitFor();
            n = process.exitValue();
        } else {
            String string3 = "regsvr32.exe /u /s " + string2;
            systemUtilService.addSystemStartupCommand(string3);
            n = 0;
        }
        return n;
    }
}

