/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.product.ProductBuilder;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.wizard.platform.win32.Win32Utils;
import com.installshield.wizard.platform.win32.WindowsLauncherExtra;
import com.installshield.wizard.service.WizardServices;

public class Win32LauncherExtra
extends WindowsLauncherExtra
implements ProductBuilder {
    public static final int GUI = 0;
    public static final int CONSOLE = 1;
    int userInterface = 0;

    public void build(ProductBuilderSupport productBuilderSupport) {
        try {
            WizardServices wizardServices = this.obtainBuildtimeServices();
            if (wizardServices != null) {
                String string = Win32Utils.getWin32ConsoleLauncherResource();
                productBuilderSupport.putResource(wizardServices.getResource(string), string);
                String string2 = Win32Utils.getWin32LauncherResource();
                productBuilderSupport.putResource(wizardServices.getResource(string2), string2);
            } else {
                productBuilderSupport.logEvent(this, "err", "Could not add necessary launcher resources:  Could not obtain services.");
            }
        }
        catch (Exception exception) {
            productBuilderSupport.logEvent(this, "err", exception);
        }
    }

    protected String getPlatformIdImpl() {
        return "win32ppk";
    }

    protected String getPlatformLauncherResource() {
        if (this.userInterface == 1) {
            return Win32Utils.getWin32ConsoleLauncherResource();
        }
        return Win32Utils.getWin32LauncherResource();
    }

    public int getUserInterface() {
        return this.userInterface;
    }

    public void setUserInterface(int n) {
        this.userInterface = n;
    }
}

