/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard;

import com.installshield.archive.BuildFilterable;
import com.installshield.archive.index.ArchiveIndexAccessor;
import com.installshield.beans.PropertiesExtendible;
import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.ClassUtils;
import com.installshield.util.ConditionSet;
import com.installshield.util.GenericTreeNode;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.Log;
import com.installshield.util.StringResolverException;
import com.installshield.util.StringResolverUtil;
import com.installshield.util.StringUtils;
import com.installshield.wizard.OptionsTemplateEntry;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardBeanCondition;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilder;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardTree;
import com.installshield.wizard.service.Service;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class WizardBean
implements WizardBuilder,
PropertyAccessible,
Log,
PropertiesExtendible,
BuildFilterable {
    public static final int TEMPLATE_VALUE = 1;
    public static final int CURRENT_VALUE = 2;
    private static int nextId = 1;
    private String beanId = "";
    private String displayName = "";
    private boolean active = true;
    private ConditionSet conditionSet = new ConditionSet();
    private Properties extendedProperties = new Properties();
    private String comments = "";
    private String conditionOperator = "AND";
    private String buildCategories = "";
    private WizardBean parent = null;
    GenericTreeNode node = new GenericTreeNode();
    WizardTree tree = null;
    private Wizard wizard = null;
    private Hashtable values = new Hashtable();

    public WizardBean() {
        this.setBeanId(WizardBean.nextBeanId());
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
    }

    public Dictionary buildCategories() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = StringUtils.parseCommaDelimitedString(this.buildCategories);
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n], "");
            ++n;
        }
        Enumeration enumeration = this.conditionNames();
        while (enumeration.hasMoreElements()) {
            WizardBeanCondition wizardBeanCondition = this.getCondition((String)enumeration.nextElement());
            Enumeration enumeration2 = wizardBeanCondition.buildCategories().keys();
            while (enumeration2.hasMoreElements()) {
                hashtable.put((String)enumeration2.nextElement(), "");
            }
        }
        return hashtable;
    }

    public Enumeration conditionNames() {
        return this.conditionSet.names();
    }

    public boolean conditionsMet() {
        return this.conditionSet.isMet();
    }

    public void evaluateImmutableConditions() {
        this.conditionSet.evaluateImmutableConditions();
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
    }

    public URL getApplicationResource(String string) throws IOException {
        if (this.wizard == null) {
            throw new IllegalStateException("wizard not initialized -- cannot use getApplicationResource");
        }
        return this.wizard.getApplicationResource(string);
    }

    public ArchiveIndexAccessor getArchiveIndexAccessor() throws ServiceException, IOException {
        if (this.wizard == null) {
            throw new IllegalStateException("wizard not initialized -- cannot use getArchiveIndexReader");
        }
        return this.wizard.getArchiveIndexAccessor();
    }

    public String getBeanId() {
        return this.beanId;
    }

    public String getBuildCategories() {
        return this.buildCategories;
    }

    public String getComments() {
        return this.comments;
    }

    public WizardBeanCondition getCondition(String string) {
        return (WizardBeanCondition)this.conditionSet.get(string);
    }

    public String getConditionOperator() {
        return this.conditionOperator;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Dictionary getExtendedProperties() {
        return this.extendedProperties;
    }

    public URL getExternalResource(int n) throws ServiceException, IOException {
        if (this.wizard == null) {
            throw new IllegalStateException("wizard not initialized -- cannot use getExternalResource");
        }
        return this.wizard.getExternalResource(n);
    }

    public URL getIndexedResource(int n) throws ServiceException, IOException {
        if (this.wizard == null) {
            throw new IllegalStateException("wizard not initialized -- cannot use getIndexedResource");
        }
        return this.wizard.getIndexedResource(n);
    }

    public URL getNormalResource(int n) throws ServiceException, IOException {
        if (this.wizard == null) {
            throw new IllegalStateException("wizard not initialized -- cannot use getNormalResource");
        }
        return this.wizard.getNormalResource(n);
    }

    public String getOptionsFileTemplateValueStr() {
        return LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "WizardBean.valueStr");
    }

    public OptionsTemplateEntry[] getOptionsTemplateEntries(int n) {
        return new OptionsTemplateEntry[0];
    }

    public URL getResource(String string) throws IOException {
        if (this.wizard == null) {
            throw new IllegalStateException("wizard not initialized -- cannot call getResource");
        }
        return this.wizard.getResource(string);
    }

    protected Service getService(String string) throws ServiceException {
        if (this.wizard == null) {
            throw new IllegalStateException("services used before wizard tree is initialized");
        }
        return this.wizard.getServices().getService(string);
    }

    public WizardServices getServices() {
        if (this.wizard == null) {
            throw new IllegalStateException("wizard not initialized -- cannot call getResource");
        }
        return this.wizard.getServices();
    }

    public Object getValue(String string) {
        return this.values.get(string);
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public WizardTree getWizardTree() {
        return this.tree;
    }

    public boolean immutableConditionsMet() {
        return this.conditionSet.isImmutableMet();
    }

    public boolean isActive() {
        return this.active;
    }

    protected boolean isEventLogged(String string) {
        if (this.wizard != null) {
            return this.wizard.getWizardLog().isEventLogged(string);
        }
        return false;
    }

    public void logEvent(Object object, String string, Object object2) {
        if (this.wizard != null) {
            this.wizard.getServices().logEvent(object, string, object2);
        } else {
            System.err.println("ERROR: log used before wizard tree is initialized: " + object2);
        }
    }

    private static String nextBeanId() {
        return "bean" + nextId++;
    }

    public void putCondition(String string, WizardBeanCondition wizardBeanCondition) {
        this.conditionSet.put(string, wizardBeanCondition);
        wizardBeanCondition.setWizardBean(this);
    }

    public void removeCondition(String string) {
        this.conditionSet.remove(string);
    }

    protected String resolveString(String string) {
        if (this.wizard == null) {
            throw new IllegalStateException("string resolver used before wizard tree is initialized");
        }
        return this.wizard.getServices().resolveString(string);
    }

    protected String resolveString(String string, String string2, Log log) {
        if (this.wizard == null) {
            throw new IllegalStateException("services not initialized");
        }
        return StringResolverUtil.resolveString(string, string2, log, this, this.wizard.getServices());
    }

    protected String resolveStringWithValidation(String string) throws StringResolverException {
        if (this.wizard == null) {
            throw new IllegalStateException("string resolver used before wizard tree is initialized");
        }
        return this.wizard.getServices().resolveStringWithValidation(string);
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setBeanId(String string) {
        this.beanId = string;
    }

    public void setBuildCategories(String string) {
        if (string == null) {
            throw new IllegalArgumentException("categories cannot be null");
        }
        this.buildCategories = string;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    public void setConditionOperator(String string) {
        this.conditionOperator = string;
        this.conditionSet.setOperator(this.conditionOperator);
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setValue(String string, Object object) {
        this.values.put(string, object);
    }

    public void setWizard(Wizard wizard) {
        this.wizard = wizard;
    }

    public String toString() {
        return String.valueOf(ClassUtils.createObjectDisplayName(this)) + " (" + this.getBeanId() + ")";
    }
}

