/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util.jvm;

import com.installshield.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class LauncherEntry {
    private String name = null;
    private InputStream inputStream = null;

    public abstract long calculateSize() throws IOException;

    public long calculateTotalDecompressedSize() throws IOException {
        return 0L;
    }

    public long getDecompressedFileCount() throws IOException {
        return 1L;
    }

    public abstract InputStream getInputStream() throws IOException;

    public String getName() {
        return this.name;
    }

    public abstract int getType();

    public boolean isCompressed() throws IOException {
        return false;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSource(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public int write(OutputStream outputStream) throws IOException {
        InputStream inputStream = this.inputStream != null ? this.inputStream : this.getInputStream();
        int n = FileUtils.copy(inputStream, outputStream);
        inputStream.close();
        return n;
    }
}

