/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.iterators;

import com.installshield.product.ProductBean;
import com.installshield.product.ProductTreeIterator;
import java.util.Hashtable;

public class VirtualActiveStateProductTreeIterator
implements ProductTreeIterator {
    private ProductTreeIterator iter;
    private ProductBean root;
    private Hashtable virtualActiveStates;

    public VirtualActiveStateProductTreeIterator(ProductTreeIterator productTreeIterator, Hashtable hashtable) {
        this.virtualActiveStates = hashtable;
        this.iter = productTreeIterator;
        this.root = productTreeIterator.getNext(productTreeIterator.begin());
    }

    public ProductBean begin() {
        return this.iter.begin();
    }

    public ProductBean end() {
        return this.iter.end();
    }

    public ProductBean getNext(ProductBean productBean) {
        ProductBean productBean2 = this.iter.getNext(productBean);
        while (productBean2 != this.end() && !this.isVirtuallyActive(productBean2)) {
            productBean2 = this.iter.getNext(productBean2);
        }
        return productBean2;
    }

    public ProductBean getPrevious(ProductBean productBean) {
        ProductBean productBean2 = this.iter.getPrevious(productBean);
        while (productBean2 != this.begin() && !this.isVirtuallyActive(productBean2)) {
            productBean2 = this.iter.getPrevious(productBean2);
        }
        return productBean2;
    }

    private boolean isVirtuallyActive(ProductBean productBean) {
        boolean bl = true;
        if (this.virtualActiveStates != null && !this.virtualActiveStates.containsKey(productBean.getBeanId())) {
            bl = false;
        }
        return bl;
    }
}

