/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.cdi.cib;

import com.ibm.rational.cdi.cib.StringSet;
import com.ibm.rational.cdi.exception.CDIException;
import com.ibm.rational.cdi.exception.RegistryInvalid;
import com.ibm.rational.cdi.util.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;

public class Registry {
    private static final String REGISTRY_DIR = ".sdpinst";
    private static final String PRODUCTS = ".products";
    private static final String LOCATION = ".location";
    private static final String REGISTRY_FILE = "cdi_ref.properties";
    private static final String MESSAGES = "com.ibm.rational.cdi.cib.registry";
    private File registryFile;
    private Properties registry = new Properties();
    private boolean valid = false;
    private boolean dirty = false;
    private Messages msgs = new Messages("com.ibm.rational.cdi.cib.registry");
    private StringSet productSet = new StringSet("");
    private String primaryBeanId;

    public Registry(String installHome) throws CDIException {
        this.initialize(installHome);
    }

    private void initialize(String installHome) throws CDIException {
        try {
            this.setRegistryFile(installHome);
            if (this.loadRegistry()) {
                this.valid = true;
            }
        }
        catch (IOException e) {
            throw new CDIException("Registry.CannotInstallRegistry", e);
        }
        if (!this.valid) {
            throw new CDIException(this.msgs.getString("Registry.CannotInstallRegistry"));
        }
    }

    private void setRegistryFile(String basepath) throws IOException {
        File registryHome = null;
        if (basepath != null && basepath.length() != 0) {
            registryHome = new File(basepath, REGISTRY_DIR);
            if (!registryHome.exists() && !registryHome.mkdirs()) {
                registryHome = null;
                throw new IOException(this.msgs.getString("Registry.NoRegistryAccess"));
            }
            this.registryFile = new File(registryHome, REGISTRY_FILE);
            if (!this.registryFile.exists() && !this.registryFile.createNewFile()) {
                throw new IOException(this.msgs.getString("Cannot create registry file {0}", this.registryFile.getAbsolutePath()));
            }
            if (!this.registryFile.isFile()) {
                throw new IOException(this.msgs.getString("Registry.NotAFile", this.registryFile.getAbsolutePath()));
            }
        }
    }

    private boolean loadRegistry() throws CDIException {
        boolean rc = false;
        try {
            FileInputStream fis = new FileInputStream(this.registryFile);
            this.registry.load(fis);
            fis.close();
            rc = true;
        }
        catch (FileNotFoundException e) {
            throw new CDIException(this.msgs.getString("Registry.ErrorLoadingFile", this.registryFile.getPath()), e);
        }
        catch (IOException e) {
            throw new CDIException(this.msgs.getString("Registry.ERR_ReadingFile", this.registryFile.getPath()), e);
        }
        return rc;
    }

    public boolean hasProduct(String product) throws RegistryInvalid {
        boolean rc = false;
        if (!this.valid || this.primaryBeanId == null || this.primaryBeanId.length() == 0) {
            throw new RegistryInvalid();
        }
        if (this.productSet.hasString(product)) {
            rc = true;
        }
        return rc;
    }

    public String getBeanInstallLocation(String beanId) throws RegistryInvalid {
        String ret = null;
        if (!this.valid || this.primaryBeanId == null || this.primaryBeanId.length() == 0) {
            throw new RegistryInvalid();
        }
        String key = beanId == null ? this.primaryBeanId + LOCATION : this.primaryBeanId + "." + beanId + LOCATION;
        if (this.registry.containsKey(key)) {
            ret = this.registry.getProperty(key);
        }
        return ret;
    }

    public String getKeyValue(String beanId, String key) throws RegistryInvalid {
        String ret = null;
        if (!this.valid || this.primaryBeanId == null || this.primaryBeanId.length() == 0) {
            throw new RegistryInvalid();
        }
        String keystr = beanId == null ? this.primaryBeanId + "." + key : this.primaryBeanId + "." + beanId + "." + key;
        if (this.registry.containsKey(keystr)) {
            ret = this.registry.getProperty(keystr);
        }
        return ret;
    }

    public Vector getReferencedProducts() {
        Vector ret = null;
        if (this.valid && this.primaryBeanId != null && this.primaryBeanId.length() != 0 && this.productSet.count() != 0) {
            ret = this.productSet.getStringVector();
        }
        return ret;
    }

    public void addReferencedProduct(String product) throws RegistryInvalid {
        if (!this.isValid()) {
            throw new RegistryInvalid();
        }
        if (!this.hasProduct(product)) {
            this.productSet.add(product);
            this.registry.put(this.primaryBeanId + PRODUCTS, this.productSet.getString());
            this.dirty = true;
        }
    }

    public void removeReferencedProduct(String product) throws RegistryInvalid {
        if (!this.isValid()) {
            throw new RegistryInvalid();
        }
        if (this.hasProduct(product)) {
            this.productSet.remove(product);
            if (this.productSet.count() == 0) {
                this.registry.remove(this.primaryBeanId + PRODUCTS);
            } else {
                this.registry.put(this.primaryBeanId + PRODUCTS, this.productSet.getString());
            }
            this.dirty = true;
        }
    }

    public void addKeyValue(String beanid, String key, String value) throws RegistryInvalid {
        if (!this.isValid()) {
            throw new RegistryInvalid();
        }
        String keystr = beanid == null ? new String(this.primaryBeanId + "." + key) : new String(this.primaryBeanId + "." + beanid + "." + key);
        this.registry.put(keystr, value);
    }

    public void removeKeyValue(String beanid, String key) throws RegistryInvalid {
        if (!this.isValid()) {
            throw new RegistryInvalid();
        }
        String keystr = beanid == null ? new String(this.primaryBeanId + "." + key) : new String(this.primaryBeanId + "." + beanid + "." + key);
        this.registry.remove(keystr);
        this.dirty = true;
    }

    public void addLocation(String beanid, String installLocation) throws RegistryInvalid {
        if (!this.isValid()) {
            throw new RegistryInvalid();
        }
        String key = beanid == null ? new String(this.primaryBeanId + LOCATION) : new String(this.primaryBeanId + "." + beanid + LOCATION);
        this.registry.put(key, installLocation);
        this.dirty = true;
    }

    public void removeLocation(String beanid) throws RegistryInvalid {
        if (!this.isValid()) {
            throw new RegistryInvalid();
        }
        String key = beanid == null ? new String(this.primaryBeanId + LOCATION) : new String(this.primaryBeanId + "." + beanid + LOCATION);
        this.registry.remove(key);
        this.dirty = true;
    }

    public boolean saveRegistry() throws CDIException {
        boolean rc = false;
        if (this.valid) {
            try {
                FileOutputStream fos = new FileOutputStream(this.registryFile);
                this.registry.store(fos, this.msgs.getString("Registry.RegistryHeader"));
                fos.flush();
                fos.close();
                this.dirty = false;
            }
            catch (FileNotFoundException e) {
                throw new CDIException(this.msgs.getString("Registry.FileNotFound", this.registryFile.getPath()), e);
            }
            catch (IOException e) {
                throw new CDIException(this.msgs.getString("Registry.IOExceptionSave", this.registryFile.getPath()), e);
            }
        }
        return rc;
    }

    public boolean isValid() {
        return this.primaryBeanId != null && this.primaryBeanId.length() != 0 && this.valid;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isEmpty() {
        return this.productSet.count() == 0;
    }

    public String getPrimaryBeanId() {
        return this.primaryBeanId;
    }

    public void setPrimaryBeanId(String beanid) throws RegistryInvalid {
        this.primaryBeanId = beanid;
        if (!this.valid) {
            throw new RegistryInvalid();
        }
        this.dirty = false;
        this.productSet = new StringSet(this.registry.getProperty(this.primaryBeanId + PRODUCTS, ""));
    }

    public void purge() {
        this.registry = new Properties();
        this.productSet = new StringSet("");
        this.dirty = true;
    }
}

