/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.cdi.cib;

import com.ibm.rational.cdi.cib.Registry;
import com.ibm.rational.cdi.util.Messages;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.util.FileUtils;
import com.installshield.util.StringResolverException;
import java.io.IOException;

public class CDIReferenceUninstall
extends ProductAction {
    private String commonInstallHome = null;
    private String currentProductKey = null;
    private boolean performActions = false;
    private Registry reg;
    private Messages msgs = new Messages("com.ibm.rational.cdi.cib.CDIReference");

    public void build(ProductBuilderSupport support) {
        try {
            this.setCommonInstallHome(this.resolveStringWithValidation("$A(COMMON_INSTALL_HOME)"));
        }
        catch (StringResolverException e1) {
            support.logEvent(this, "err", this.getBeanId() + ":" + e1.getMessage());
        }
        try {
            support.putClass("com.ibm.rational.cdi.cib.Registry");
            support.putClass("com.ibm.rational.cdi.cib.StringSet");
            support.putClass("com.ibm.rational.cdi.util.Messages");
            support.putClass("com.ibm.rational.cdi.exception.RegistryInvalid");
            support.putClass("com.ibm.rational.cdi.exception.CDIException");
            support.putClassResource("com/ibm/rational/cdi/cib/registry.properties");
            support.putClassResource("com/ibm/rational/cdi/cib/CDIReference.properties");
        }
        catch (IOException e1) {
            support.logEvent(this, "err", this.getBeanId() + ":" + this.msgs.getString("CDIReferenceInstall.ERR_SupportClassesMissing", e1.getMessage()));
        }
    }

    public void setCommonInstallHome(String s) {
        this.commonInstallHome = s;
    }

    public void install(ProductActionSupport support) throws ProductException {
        this.performActions = false;
        this.commonInstallHome = FileUtils.normalizeFileName(this.resolveString(this.commonInstallHome), '/');
        this.currentProductKey = this.resolveString(this.currentProductKey);
    }

    public void uninstall(ProductActionSupport support) throws ProductException {
        this.performActions = false;
        this.commonInstallHome = FileUtils.normalizeFileName(this.resolveString(this.commonInstallHome), '/');
        try {
            Registry reg = new Registry(this.getCommonInstallHome());
            reg.setPrimaryBeanId(this.getParentComponent().getBeanId());
            reg.removeReferencedProduct(this.getCurrentProductKey());
            if (reg.isEmpty()) {
                this.performActions = true;
            }
            if (reg.isDirty()) {
                reg.saveRegistry();
            }
        }
        catch (Exception e) {
            throw new ProductException(601, "err", this.getBeanId() + ":" + e.toString());
        }
    }

    public String getCommonInstallHome() {
        return this.commonInstallHome;
    }

    public String getCurrentProductKey() {
        return this.currentProductKey;
    }

    public void setCurrentProductKey(String currentProduct) {
        this.currentProductKey = currentProduct;
    }

    public boolean getPerformActions() {
        return this.performActions;
    }

    public void setPerformActions(boolean ia) {
        this.performActions = ia;
    }
}

