-- Connect to the security database
CONNECT TO O3DBA1 USER BTFTOR1 USING TEL1LER

set current sqlid = 'BTFGRP'  

-- Create the user table
CREATE TABLE BTFSCHEM.USERS ("USERID" CHAR(25) NOT NULL,"XID" CHAR(10) NOT NULL,"PASSWORD" CHAR(120),"RIGHTS" VARCHAR(700),"ROLES" VARCHAR(700),"RIGHT_TIMES" VARCHAR(700),"ROLE_TIMES" VARCHAR(700),"ACTIVATION" CHAR(20),"DURATION" CHAR(20),"LOCK" CHAR,"TIMELOCK" CHAR,"DATA" VARCHAR(700), PRIMARY KEY(USERID, XID)) IN DATABASE BTF

CREATE UNIQUE INDEX BTFSCHEM.INDEXUS ON BTFSCHEM.USERS (USERID ASC , XID ASC )

-- Create the rights table
CREATE TABLE BTFSCHEM.RIGHTS ("RIGHT_NAME" CHAR(50) NOT NULL,"XID" CHAR(10) NOT NULL,"DATA" VARCHAR(700), PRIMARY KEY(RIGHT, XID)) IN DATABASE BTF

CREATE UNIQUE INDEX BTFSCHEM.INDEXRI ON BTFSCHEM.RIGHTS ("RIGHT_NAME" ASC , XID ASC )

-- Create the roles table
CREATE TABLE BTFSCHEM.ROLES ("ROLE" CHAR(50) NOT NULL,"XID" CHAR(10) NOT NULL,"HANDLER" CHAR(100),"RIGHTS" VARCHAR(700),"ROLES" VARCHAR(700),"DATA" VARCHAR(700), PRIMARY KEY(ROLE, XID)) IN DATABASE BTF

CREATE UNIQUE INDEX BTFSCHEM.INDEXRL ON BTFSCHEM.ROLES (ROLE ASC , XID ASC )

-- Create the services table
CREATE TABLE BTFSCHEM.SERVICES ("SERVICE" CHAR(50) NOT NULL,"XID" CHAR(10) NOT NULL,"RIGHTS" VARCHAR(700),"DATA" VARCHAR(700), PRIMARY KEY(SERVICE, XID)) IN DATABASE BTF

CREATE UNIQUE INDEX BTFSCHEM.INDEXSV ON BTFSCHEM.SERVICES (SERVICE ASC , XID ASC )

-- Create the groups table
CREATE TABLE BTFSCHEM.GROUPS ("GROUP" CHAR(50) NOT NULL,"XID" CHAR(10) NOT NULL,"USERS" VARCHAR(700),"GROUPS" VARCHAR(700),"DATA" VARCHAR(700), PRIMARY KEY(GROUP, XID)) IN DATABASE BTF

CREATE UNIQUE INDEX BTFSCHEM.INDEXGR ON BTFSCHEM.GROUPS ("GROUP" ASC , XID ASC )

-- Create the contexts table
CREATE TABLE BTFSCHEM.CONTEXTS ("CONTEXT" CHAR(12) NOT NULL,"XID" CHAR(10) NOT NULL,"USERID" CHAR(10),"OVERRIDE" CHAR(10),"ACTIVE" CHAR,"FORCEDSIGNOFF" CHAR,"DATA" VARCHAR(700), PRIMARY KEY(CONTEXT, XID)) IN DATABASE BTF

CREATE UNIQUE INDEX BTFSCHEM.INDEXCX ON BTFSCHEM.CONTEXTS (CONTEXT ASC , XID ASC )

-- Create the configuration table
CREATE TABLE BTFSCHEM.CONFIGURATION ("XID" CHAR(10) NOT NULL,"USRP" CHAR,"CTXP" CHAR,"RGTP" CHAR,"ROLP" CHAR,"SRVP" CHAR,"GRPP" CHAR,"CFGP" CHAR,"AUDIT" CHAR,"QPASSWORD" CHAR,"UNIQUE" CHAR,"ROLES" VARCHAR(700), PRIMARY KEY(XID)) IN DATABASE BTF

CREATE UNIQUE INDEX BTFSCHEM.INDEXCON ON BTFSCHEM.CONFIGURATION (XID ASC )
