################################################################
#                                                              #
# File: createAgentAdminTables.sh                              #
#                                                              #
# Usage: createAgentAdminTables.sh userid password             #
#                                                              #
# This script creates a database BTF and all tables for the    #
# Agent Admin e-Component on AIX platform.                     #
#                                                              #
################################################################

if [ $# -ne 2 ]; then
 echo "Usage: createAgentAdminTables.sh userid password"
 exit 1
fi

#
# Create database BTF.
#

echo Creating database BTF for Agent Admin
db2 "CREATE DATABASE BTF"

#
# Create tables.
#

echo Creating tables for Agent Admin
db2 "CONNECT TO BTF user $1 using $2"

echo 'Creating tables: users\c'
T="CREATE TABLE BTF.USERS ("
T="$T USERID      CHAR(25) NOT NULL,"
T="$T XID         CHAR(10) NOT NULL,"
T="$T PASSWORD    CHAR(120),"
T="$T RIGHTS      VARCHAR(700),"
T="$T ROLES       VARCHAR(700),"
T="$T RIGHT_TIMES VARCHAR(700),"
T="$T ROLE_TIMES  VARCHAR(700),"
T="$T ACTIVATION  CHAR(20),"
T="$T DURATION    CHAR(20),"
T="$T LOCK        CHAR,"
T="$T TIMELOCK    CHAR,"
T="$T DATA        VARCHAR(700),"
T="$T PRIMARY KEY(USERID , XID)) IN USERSPACE1"
db2 "$T"

echo ' rights\c'
T="CREATE TABLE BTF.RIGHTS ("
T="$T RIGHT_NAME CHAR(50) NOT NULL,"
T="$T XID   CHAR(10) NOT NULL,"
T="$T DATA  VARCHAR(700),"
T="$T PRIMARY KEY(RIGHT , XID)) IN USERSPACE1"
db2 "$T"

echo ' roles\c'
T="CREATE TABLE BTF.ROLES ("
T="$T ROLE    CHAR(50) NOT NULL,"
T="$T XID     CHAR(10) NOT NULL,"
T="$T HANDLER CHAR(100),"
T="$T RIGHTS  VARCHAR(700),"
T="$T ROLES   VARCHAR(700),"
T="$T DATA    VARCHAR(700),"
T="$T PRIMARY KEY(ROLE , XID)) IN USERSPACE1"
db2 "$T"

echo ' services\c'
T="CREATE TABLE BTF.SERVICES ("
T="$T SERVICE CHAR(50) NOT NULL,"
T="$T XID     CHAR(10) NOT NULL,"
T="$T RIGHTS  VARCHAR(700),"
T="$T DATA    VARCHAR(700),"
T="$T PRIMARY KEY(SERVICE , XID)) IN USERSPACE1"
db2 "$T"

echo ' groups\c'
T="CREATE TABLE BTF.GROUPS ("
T="$T GROUP  CHAR(50) NOT NULL,"
T="$T XID    CHAR(10) NOT NULL,"
T="$T GROUPS VARCHAR(700),"
T="$T USERS  VARCHAR(700),"
T="$T DATA   VARCHAR(700),"
T="$T PRIMARY KEY(GROUP , XID)) IN USERSPACE1"
db2 "$T"

echo ' contexts\c'
T="CREATE TABLE BTF.CONTEXTS ("
T="$T CONTEXT       CHAR(12) NOT NULL,"
T="$T XID           CHAR(10) NOT NULL,"
T="$T USERID        CHAR(10),"
T="$T OVERRIDE      CHAR(10),"
T="$T ACTIVE        CHAR,"
T="$T FORCEDSIGNOFF CHAR,"
T="$T DATA          VARCHAR(700),"
T="$T PRIMARY KEY(CONTEXT , XID)) IN USERSPACE1"
db2 "$T"

echo ' configurations.'
T="CREATE TABLE BTF.CONFIGURATION ("
T="$T XID       CHAR(10) NOT NULL,"
T="$T USRP      CHAR,"
T="$T CTXP      CHAR,"
T="$T RGTP      CHAR,"
T="$T ROLP      CHAR,"
T="$T SRVP      CHAR,"
T="$T GRPP      CHAR,"
T="$T CFGP      CHAR,"
T="$T AUDIT     CHAR,"
T="$T QPASSWORD CHAR,"
T="$T UNIQUE    CHAR,"
T="$T ROLES     VARCHAR(700),"
T="$T PRIMARY KEY(XID)) IN USERSPACE1"
db2 "$T"

#
# Disconnect from the database.
#

db2 "DISCONNECT BTF"
