/*
 * Decompiled with CFR 0.152.
 */
package esupportui_web.ui;

import com.ibm.esupport.client.search.CategoryEncoding;
import com.ibm.esupport.client.search.ProductEncoding;
import com.ibm.esupport.client.search.ResultSetCategoryView;
import com.ibm.esupport.client.search.ResultSetProductView;
import com.ibm.esupport.client.search.ResultSetView;
import com.ibm.esupport.client.search.SearchResult;
import com.ibm.esupport.client.search.SearchResultPage;
import com.ibm.esupport.client.search.SearchResultSet;
import com.ibm.esupport.client.search.WebDocumentReference;
import esupportui_web.ui.Utilities;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;

public class ResultSetViewBean {
    private ResultSetView viewModel;
    private SearchResultSet resultSet;

    public ResultSetViewBean() {
    }

    public ResultSetViewBean(ResultSetView viewModel) {
        this.viewModel = viewModel;
    }

    public ResultSetViewBean(SearchResultSet rs) {
        this.resultSet = rs;
    }

    public void generateUncategorizedHTML(int pageNum, String searchTargetName) {
    }

    public void produceHTML(int pageNum, Writer writer) throws IOException {
        writer.write("<table>");
        SearchResult[] results = this.viewModel.getContents();
        int k = 0;
        while (k < results.length) {
            writer.write("<tr><td>");
            CategoryEncoding category = results[k].getDocumentCategory();
            if (category != null) {
                writer.write(category.getDisplayName());
            }
            writer.write("</td><td>");
            ProductEncoding product = results[k].getProduct();
            if (product != null) {
                writer.write(product.getDisplayName());
            }
            writer.write("</td></tr><tr><td>");
            writer.write("<table>");
            SearchResultPage pageModel = new SearchResultPage(results[k], 10);
            pageModel.goTo(pageNum);
            WebDocumentReference[] docref = pageModel.getContents();
            int j = 0;
            while (j < docref.length) {
                writer.write("<tr><td>");
                writer.write("<a target=\"_blank\" href='");
                writer.write(docref[j].url);
                writer.write("'>");
                writer.write(docref[j].title);
                writer.write("</a><br>");
                if (docref[j].description != null) {
                    writer.write(this.encodeStringAsHTML(docref[j].description));
                }
                writer.write("</td></tr>");
                ++j;
            }
            writer.write("<tr><td align=\"right\">");
            if (pageNum != 1) {
                writer.write("<a href=\"results.do?pageNum=" + (pageNum - 1) + "&categoryName=" + Utilities.stripAndReplace((String)category.getDisplayName()));
                if (this.viewModel instanceof ResultSetProductView) {
                    writer.write("&productName=" + Utilities.stripAndReplace((String)product.getDisplayName()));
                }
                writer.write("\">&lt; Prev</a>&nbsp;&nbsp;&nbsp;");
            }
            if (pageModel.getPageIndex() < pageModel.getPageCount()) {
                writer.write("<a href=\"results.do?pageNum=" + (pageNum + 1) + "&categoryName=" + Utilities.stripAndReplace((String)category.getDisplayName()));
                if (this.viewModel instanceof ResultSetProductView) {
                    writer.write("&productName=" + Utilities.stripAndReplace((String)product.getDisplayName()));
                }
                writer.write("\">Next &gt;</a>&nbsp;&nbsp;&nbsp;");
            }
            pageModel.getPageIndex();
            pageModel.getPageCount();
            writer.write("</table></td></tr>");
            ++k;
        }
        writer.write("</table>");
    }

    public String generateHTML() throws IOException {
        return this.generateHTML(1, null);
    }

    public String generateHTML(int pageNum, String searchTargetName) throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("<table style=\"font-size: 8pt\">");
        SearchResult[] results = this.resultSet != null ? this.resultSet.contents : this.viewModel.getContents();
        int k = 0;
        while (k < results.length) {
            buf.append("<tr><td  align=\"left\">");
            CategoryEncoding category = results[k].getDocumentCategory();
            ProductEncoding product = results[k].getProduct();
            if (searchTargetName != null) {
                buf.append(Utilities.replaceUnderScore((String)searchTargetName));
            }
            if (category != null) {
                buf.append(" -> " + category.getDisplayName());
            }
            if (product != null) {
                buf.append(" -> " + product.getDisplayName());
            }
            buf.append("</td></tr><tr><td>");
            buf.append("<table style=\"font-size: 8pt\">");
            SearchResultPage pageModel = new SearchResultPage(results[k], 10);
            pageModel.goTo(pageNum);
            WebDocumentReference[] docref = pageModel.getContents();
            buf.append("<tr><td align=\"right\">");
            if (pageNum != 1) {
                buf.append("<a href=\"results.do?pageNum=" + (pageNum - 1));
                if (this.viewModel instanceof ResultSetCategoryView) {
                    if (category != null) {
                        buf.append("&categoryName=" + Utilities.stripAndReplace((String)category.getDisplayName()));
                    }
                    if (searchTargetName != null) {
                        buf.append("&searchTargetName=" + Utilities.stripAndReplace((String)searchTargetName));
                    }
                } else if (this.viewModel instanceof ResultSetProductView) {
                    if (product != null) {
                        buf.append("&productName=" + Utilities.stripAndReplace((String)product.getDisplayName()));
                    }
                    if (category != null) {
                        buf.append("&categoryName=" + Utilities.stripAndReplace((String)category.getDisplayName()));
                    }
                    if (searchTargetName != null) {
                        buf.append("&searchTargetName=" + Utilities.stripAndReplace((String)searchTargetName));
                    }
                } else if (searchTargetName != null) {
                    buf.append("&searchTargetName=" + Utilities.stripAndReplace((String)searchTargetName));
                }
                buf.append("\"><img src=\"../images/prev_left.gif\" border=\"0\" /> Prev</a>&nbsp;&nbsp;&nbsp;");
            }
            if (pageModel.getPageIndex() < pageModel.getPageCount()) {
                buf.append("<a href=\"results.do?pageNum=" + (pageNum + 1));
                if (this.viewModel instanceof ResultSetCategoryView) {
                    if (category != null) {
                        buf.append("&categoryName=" + Utilities.stripAndReplace((String)category.getDisplayName()));
                    }
                    if (searchTargetName != null) {
                        buf.append("&searchTargetName=" + Utilities.stripAndReplace((String)searchTargetName));
                    }
                } else if (this.viewModel instanceof ResultSetProductView) {
                    if (product != null) {
                        buf.append("&productName=" + Utilities.stripAndReplace((String)product.getDisplayName()));
                    }
                    if (category != null) {
                        buf.append("&categoryName=" + Utilities.stripAndReplace((String)category.getDisplayName()));
                    }
                    if (searchTargetName != null) {
                        buf.append("&searchTargetName=" + Utilities.stripAndReplace((String)searchTargetName));
                    }
                } else if (searchTargetName != null) {
                    buf.append("&searchTargetName=" + Utilities.stripAndReplace((String)searchTargetName));
                }
                buf.append("\">Next <img src=\"../images/next_right.gif\" border=\"0\" /></a>&nbsp;&nbsp;&nbsp;");
            }
            pageModel.getPageIndex();
            pageModel.getPageCount();
            buf.append("</td></tr>");
            int j = 0;
            while (j < docref.length) {
                if (!results[k].isHTML()) {
                    buf.append("<tr><td><B>");
                    buf.append("<a target=\"_blank\" href='");
                    buf.append(docref[j].url);
                    buf.append("'>");
                    buf.append(docref[j].title);
                    buf.append("</a></B><br>");
                }
                if (docref[j].description != null) {
                    buf.append(this.encodeStringAsHTML(docref[j].description));
                }
                buf.append("</td></tr>");
                buf.append("<tr height=\"1\"></tr> ");
                ++j;
            }
            buf.append("<tr><td align=\"right\">");
            if (pageNum != 1) {
                buf.append("<a href=\"results.do?pageNum=" + (pageNum - 1));
                if (this.viewModel instanceof ResultSetCategoryView) {
                    if (category != null) {
                        buf.append("&categoryName=" + Utilities.stripAndReplace((String)category.getDisplayName()));
                    }
                    if (searchTargetName != null) {
                        buf.append("&searchTargetName=" + Utilities.stripAndReplace((String)searchTargetName));
                    }
                } else if (this.viewModel instanceof ResultSetProductView) {
                    if (product != null) {
                        buf.append("&productName=" + Utilities.stripAndReplace((String)product.getDisplayName()));
                    }
                    if (category != null) {
                        buf.append("&categoryName=" + Utilities.stripAndReplace((String)category.getDisplayName()));
                    }
                    if (searchTargetName != null) {
                        buf.append("&searchTargetName=" + Utilities.stripAndReplace((String)searchTargetName));
                    }
                } else if (searchTargetName != null) {
                    buf.append("&searchTargetName=" + Utilities.stripAndReplace((String)searchTargetName));
                }
                buf.append("\"><img src=\"../images/prev_left.gif\" border=\"0\" /> Prev</a>&nbsp;&nbsp;&nbsp;");
            }
            if (pageModel.getPageIndex() < pageModel.getPageCount()) {
                buf.append("<a href=\"results.do?pageNum=" + (pageNum + 1));
                if (this.viewModel instanceof ResultSetCategoryView) {
                    if (category != null) {
                        buf.append("&categoryName=" + Utilities.stripAndReplace((String)category.getDisplayName()));
                    }
                    if (searchTargetName != null) {
                        buf.append("&searchTargetName=" + Utilities.stripAndReplace((String)searchTargetName));
                    }
                } else if (this.viewModel instanceof ResultSetProductView) {
                    if (product != null) {
                        buf.append("&productName=" + Utilities.stripAndReplace((String)product.getDisplayName()));
                    }
                    if (category != null) {
                        buf.append("&categoryName=" + Utilities.stripAndReplace((String)category.getDisplayName()));
                    }
                    if (searchTargetName != null) {
                        buf.append("&searchTargetName=" + Utilities.stripAndReplace((String)searchTargetName));
                    }
                } else if (searchTargetName != null) {
                    buf.append("&searchTargetName=" + Utilities.stripAndReplace((String)searchTargetName));
                }
                buf.append("\">Next <img src=\"../images/next_right.gif\" border=\"0\" /></a>&nbsp;&nbsp;&nbsp;");
            }
            pageModel.getPageIndex();
            pageModel.getPageCount();
            buf.append("</table></td></tr>");
            ++k;
        }
        buf.append("</table>");
        return new String(buf);
    }

    public ResultSetView getViewModel() {
        return this.viewModel;
    }

    public void setViewModel(ResultSetView view) {
        this.viewModel = view;
    }

    private char[] encodeStringAsHTML(String source) {
        CharArrayWriter writer = new CharArrayWriter(source.length() * 3 / 2);
        int k = 0;
        while (k < source.length()) {
            char charval = source.charAt(k);
            if (charval > '\u009f') {
                try {
                    writer.write("&#");
                    writer.write(new Integer(charval).toString());
                    writer.write(59);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                writer.write(charval);
            }
            ++k;
        }
        return writer.toCharArray();
    }
}

