/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.sax.impl;

import com.ibm.xml.xlxp.api.sax.impl.SAXExceptionWrapper;
import com.ibm.xml.xlxp.api.util.IOExceptionWrapper;
import com.ibm.xml.xlxp.api.util.SimpleParsedEntityFactory;
import com.ibm.xml.xlxp.api.util.URI;
import com.ibm.xml.xlxp.scan.util.DTDParsedEntityFactory;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.scan.util.XMLString;
import com.ibm.xml.xlxp.scan.util.XMLStringBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAX2ParsedEntityFactory
extends SimpleParsedEntityFactory
implements DTDParsedEntityFactory {
    private EntityResolver fResolver;
    private XMLStringBuffer fStringBuffer;
    private URI fBaseURI;
    private URI fURI;

    public SAX2ParsedEntityFactory(DataBufferFactory dataBufferFactory, XMLStringBuffer xMLStringBuffer) {
        super(dataBufferFactory);
        this.fStringBuffer = xMLStringBuffer;
        this.fBaseURI = new URI(xMLStringBuffer);
        this.fURI = new URI(xMLStringBuffer);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.fResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.fResolver;
    }

    public ParsedEntity createParsedEntity(InputSource inputSource) {
        ParsedEntity parsedEntity = this.getFreeEntity();
        String string = inputSource.getSystemId();
        if (string != null) {
            this.fStringBuffer.addString(string, parsedEntity.baseURI);
        }
        this.readFromInputSource(parsedEntity, inputSource);
        return parsedEntity;
    }

    public ParsedEntity createParsedEntityFromExternalID(XMLString xMLString, XMLString xMLString2, XMLString xMLString3) {
        if (xMLString2 != null) {
            Object object;
            ParsedEntity parsedEntity = this.getFreeEntity();
            parsedEntity.baseURI.setValues(xMLString2);
            this.expandSystemID(parsedEntity.baseURI, xMLString3);
            if (this.fResolver != null && (object = this.resolveExternalEntity(xMLString, parsedEntity.baseURI)) != null) {
                String string = ((InputSource)object).getSystemId();
                if (string != null) {
                    this.fStringBuffer.addString(string, parsedEntity.baseURI);
                    this.expandSystemID(parsedEntity.baseURI, xMLString3);
                } else {
                    parsedEntity.baseURI.clear();
                }
                this.readFromInputSource(parsedEntity, (InputSource)object);
                return parsedEntity;
            }
            try {
                object = URI.openStream(parsedEntity.baseURI);
                this.setByteStreamSource(parsedEntity, (InputStream)object, null, false);
            }
            catch (IOException iOException) {
                throw new IOExceptionWrapper(iOException);
            }
            return parsedEntity;
        }
        return null;
    }

    private void readFromInputSource(ParsedEntity parsedEntity, InputSource inputSource) {
        block6: {
            try {
                Reader reader = inputSource.getCharacterStream();
                if (reader == null) {
                    InputStream inputStream = inputSource.getByteStream();
                    String string = inputSource.getEncoding();
                    if (inputStream == null) {
                        try {
                            inputStream = URI.openStream(parsedEntity.baseURI);
                        }
                        catch (IOException iOException) {
                            throw new IOExceptionWrapper(iOException);
                        }
                    }
                    this.setByteStreamSource(parsedEntity, inputStream, string, true);
                    break block6;
                }
                this.setCharacterStreamSource(parsedEntity, reader);
            }
            catch (IOException iOException) {
                throw new IOExceptionWrapper(iOException);
            }
        }
    }

    private boolean expandSystemID(XMLString xMLString, XMLString xMLString2) {
        URI uRI = this.fURI;
        URI uRI2 = this.fBaseURI;
        if (xMLString == null || xMLString.length == 0 || uRI.parse(xMLString) || xMLString2 == null) {
            return false;
        }
        if (!uRI2.parse(xMLString2)) {
            return false;
        }
        if (uRI.parse(uRI2, xMLString)) {
            uRI.asXMLString(this.fStringBuffer, xMLString);
            return true;
        }
        return false;
    }

    private InputSource resolveExternalEntity(XMLString xMLString, XMLString xMLString2) {
        try {
            String string = xMLString != null ? xMLString.toString() : null;
            String string2 = xMLString2.toString();
            return this.fResolver.resolveEntity(string, string2);
        }
        catch (SAXException sAXException) {
            throw new SAXExceptionWrapper(sAXException);
        }
        catch (IOException iOException) {
            throw new IOExceptionWrapper(iOException);
        }
    }
}

