/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.jaxp.impl;

import com.ibm.xml.xlxp.api.sax.SAX2Parser;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;

public class SAXParserImpl
extends SAXParser {
    public static final String SAX_NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String SAX_NAMESPACES_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    public static final String SAX_VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    private XMLReader fXMLReader;
    private Parser fParser;

    public SAXParserImpl(SAXParserFactory sAXParserFactory, Hashtable hashtable) throws SAXException, SAXNotSupportedException, SAXNotRecognizedException {
        this(sAXParserFactory, hashtable, true);
    }

    protected SAXParserImpl(SAXParserFactory sAXParserFactory, Hashtable hashtable, boolean bl) throws SAXException, SAXNotSupportedException, SAXNotRecognizedException {
        if (bl) {
            this.initializeXMLReader(sAXParserFactory, hashtable, new SAX2Parser());
        }
    }

    protected void initializeXMLReader(SAXParserFactory sAXParserFactory, Hashtable hashtable, XMLReader xMLReader) throws SAXException, SAXNotSupportedException, SAXNotRecognizedException {
        this.fXMLReader = xMLReader;
        this.fXMLReader.setFeature(SAX_NAMESPACES_FEATURE, sAXParserFactory.isNamespaceAware());
        this.fXMLReader.setFeature(SAX_NAMESPACES_PREFIXES_FEATURE, !sAXParserFactory.isNamespaceAware());
        this.fXMLReader.setFeature(SAX_VALIDATION_FEATURE, sAXParserFactory.isValidating());
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl = (Boolean)hashtable.get(string);
                this.fXMLReader.setFeature(string, bl);
            }
        }
    }

    public Parser getParser() throws SAXException {
        if (this.fParser == null) {
            this.fParser = new XMLReaderAdapter(this.fXMLReader);
        }
        return this.fParser;
    }

    public XMLReader getXMLReader() throws SAXException {
        return this.fXMLReader;
    }

    public boolean isNamespaceAware() {
        try {
            return this.fXMLReader.getFeature(SAX_NAMESPACES_FEATURE);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new IllegalStateException(sAXNotRecognizedException.getMessage());
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new IllegalStateException(sAXNotSupportedException.getMessage());
        }
    }

    public boolean isValidating() {
        try {
            return this.fXMLReader.getFeature(SAX_VALIDATION_FEATURE);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new IllegalStateException(sAXNotRecognizedException.getMessage());
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new IllegalStateException(sAXNotSupportedException.getMessage());
        }
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fXMLReader.setProperty(string, object);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fXMLReader.getProperty(string);
    }
}

