/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.selection.rule;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.rule.DefaultRule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EndPointRule
extends DefaultRule {
    private static final TraceComponent tc = Tr.register(EndPointRule.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final ClusterService clusterService;
    private Map endpoints;

    public EndPointRule(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("The endpointMap must not be null.");
        }
        this.endpoints = map;
    }

    public void subset(List list, StringBuffer stringBuffer) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            Identity identity = (Identity)iterator.next();
            ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)descMgr.getDescription((DescriptionKey)identity);
            this.registerNotificationType(identity, "type.add.extrinsic");
            this.registerNotificationType(identity, "type.remove.extrinsic");
            if (clusterMemberDescription == null) continue;
            ClusterMemberDescription.Memento memento = (ClusterMemberDescription.Memento)clusterMemberDescription.getMemento();
            if (memento.isLeaf()) {
                int n;
                object = clusterService.matchEndPoints(identity, this.endpoints);
                int n2 = n = object == null ? 0 : ((EndPoint[])object).length;
                if (n > 0) {
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        this.registerNotificationType(object[i].getIdentity(), "type.state.change.reachability");
                        if (object[i].isAvailable()) continue;
                        --n;
                    }
                }
                if (n != 0) continue;
                iterator.remove();
                stringBuffer.append(identity);
                stringBuffer.append(" removed: Lack of available end point  ");
                stringBuffer.append(this.endpoints);
                stringBuffer.append(' ');
                continue;
            }
            this.registerNotificationType(identity, "member.added");
            this.registerNotificationType(identity, "member.removed");
            object = (ClusterDescription.Memento)memento;
            ArrayList arrayList = new ArrayList(object.getMembers().keySet());
            StringBuffer stringBuffer2 = new StringBuffer();
            this.subset(arrayList, stringBuffer2);
            if (arrayList.size() != 0) continue;
            iterator.remove();
            stringBuffer.append(identity);
            stringBuffer.append(" removed: Lack of subordinates matching end point [");
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(']');
        }
    }

    public boolean equals(Object object) {
        return ((Object)this.endpoints).equals(object);
    }

    public int hashCode() {
        return ((Object)this.endpoints).hashCode();
    }

    public String toString() {
        return EndPointRule.class.getName() + '#' + System.identityHashCode(this) + '[' + this.endpoints + ']';
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.8 ");
        }
        clusterService = ClusterServiceFactory.getClusterService();
    }
}

