/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.webservices.rpc.handler.RPCContext;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;

public class ActionSpecifier {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.ActionSpecifier";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(ActionSpecifier.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private RPCContext _rpcContext = null;

    public ActionSpecifier(RPCContext rPCContext) {
        this._rpcContext = rPCContext;
    }

    public AttributedURI getActionForInputMessageFromWSDL() {
        AttributedURI attributedURI;
        block11: {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "getActionForInputMessageFromWSDL");
            }
            if (this._rpcContext.getWSDLUnavailable().booleanValue()) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getActionForInputMessageFromWSDL", null);
                }
                return null;
            }
            String string = this._rpcContext.getInputWSAAction();
            if (string == null || string.length() < 1 || string.equals("")) {
                string = this._rpcContext.getSOAPActionURI();
            }
            if (string == null || string.length() < 1 || string.equals("")) {
                string = this.generateDefaultActionPatternForMessage(MessageType.REQUEST);
            }
            if (string == null || string.length() < 1 || string.equals("")) {
                String string2 = "WS-Addressing Action cannot be determined for this outbound message.  It may be set on the Call or Stub, or defined in the target service WSDL.  The Action is mandatory for WSAddressed messages.";
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getActionForInputMessageFromWSDL", string2);
                }
                throw new JAXRPCException(string2);
            }
            attributedURI = null;
            try {
                if (string != null) {
                    attributedURI = WSAddressingFactory.createAttributedURI(new URI(string));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                FFDCFilter.processException((Throwable)uRISyntaxException, "com.ibm.ws.wsaddressing.handlers.ActionSpecifier.getActionForInputMessageFromWSDL", "1:184:1.28", uRISyntaxException);
                if (!TRACE_COMPONENT.isEntryEnabled()) break block11;
                Tr.debug(TRACE_COMPONENT, "getActionForInputMessageFromWSDL", "URISyntaxException thrown whilst trying to generate Input Action");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getActionForInputMessageFromWSDL", attributedURI);
        }
        return attributedURI;
    }

    public AttributedURI getActionForOutputMessageFromWSDL() {
        AttributedURI attributedURI;
        block6: {
            String string;
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "getActionForOutputMessageFromWSDL");
            }
            if ((string = this._rpcContext.getOutputWSAAction()) == null || string.length() < 1 || string.equals("")) {
                string = this.generateDefaultActionPatternForMessage(MessageType.RESPONSE);
            }
            attributedURI = null;
            try {
                if (string != null) {
                    attributedURI = WSAddressingFactory.createAttributedURI(new URI(string));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                FFDCFilter.processException((Throwable)uRISyntaxException, "com.ibm.ws.wsaddressing.handlers.ActionSpecifier.getActionForOutputMessageFromWSDL", "1:229:1.28", uRISyntaxException);
                if (!TRACE_COMPONENT.isEntryEnabled()) break block6;
                Tr.debug(TRACE_COMPONENT, "getActionForOutputMessageFromWSDL", "URISyntaxException thrown whilst trying to generate Output Action");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getActionForOutputMessageFromWSDL", attributedURI);
        }
        return attributedURI;
    }

    public AttributedURI getActionForFaultMessageFromWSDL(NamespaceData namespaceData, boolean bl) {
        AttributedURI attributedURI;
        block12: {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "getActionForFaultMessageFromWSDL");
            }
            if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(namespaceData.getNamespace())) {
                AttributedURI attributedURI2 = WSAddressingFactory.createAttributedURI(namespaceData.getFaultActionURI());
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getActionForFaultMessageFromWSDL", attributedURI2);
                }
                return attributedURI2;
            }
            if (bl) {
                AttributedURI attributedURI3 = WSAddressingFactory.createAttributedURI(namespaceData.getFaultActionURI());
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getActionForFaultMessageFromWSDL", attributedURI3);
                }
                return attributedURI3;
            }
            String string = this._rpcContext.getFaultWSAAction();
            if (string == null || string.length() < 1 || string.equals("")) {
                string = this.generateDefaultActionPatternForMessage(MessageType.FAULT);
            }
            URI uRI = null;
            if (string == null || string.length() < 1 || string.equals("")) {
                uRI = namespaceData.getFaultActionURI();
            }
            attributedURI = null;
            try {
                if (string != null) {
                    attributedURI = WSAddressingFactory.createAttributedURI(new URI(string));
                }
                if (uRI != null) {
                    attributedURI = WSAddressingFactory.createAttributedURI(uRI);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                FFDCFilter.processException((Throwable)uRISyntaxException, "com.ibm.ws.wsaddressing.handlers.ActionSpecifier.getActionForFaultMessageFromWSDL", "1:304:1.28", uRISyntaxException);
                if (!TRACE_COMPONENT.isEntryEnabled()) break block12;
                Tr.debug(TRACE_COMPONENT, "getActionForOutputMessageFromWSDL", "URISyntaxException thrown whilst trying to generate Output Action");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getActionForFaultMessageFromWSDL", attributedURI);
        }
        return attributedURI;
    }

    protected void soapActionMustMatch(String string, String string2) throws JAXRPCException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "soapActionMustMatch", new Object[]{string, string2});
        }
        if (string == null || string.length() < 1 || string.equals("")) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "soapActionMustMatch", "SoapAction is null so do not compare to Addressing Action.");
            }
            return;
        }
        if (string.equals(string2)) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "SoapAction matches wsa:Action.");
            }
        } else {
            String string3 = "WS-Addressing Configuration Error: The SoapActionUri set on the stub/call properties ( " + string + " ) does not match the WS-Addressing action defined in the target service WSDL by the <wsaw:Action> marker, or generated from the WSDL using the default action pattern ( " + string2 + " ).";
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, string3);
                Tr.exit(TRACE_COMPONENT, "soapActionMustMatch", new Object[]{string, string2});
            }
            throw new JAXRPCException("SoapActionUri does not match the WSAddressing Action obtained from the WSDL.  This is an invalid configuration according to the W3C WSA specification.");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "soapActionMustMatch");
        }
    }

    private String generateDefaultActionPatternForMessage(MessageType messageType) {
        String string;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "generateDefaultActionPatternForMessage", messageType);
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getDefaultTargetNamespaceDelimPortTypeDelim();
        if (string2 == null) {
            String string3 = "Unable to determine wsa:Action value.";
            Tr.exit(TRACE_COMPONENT, "generateDefaultActionPatternForMessage", string3);
            return null;
        }
        String string4 = string2.substring(string2.length() - 1);
        stringBuffer.append(string2);
        String string5 = this.getWSDLName(messageType);
        if (string5 == null) {
            String string6 = "Unable to determine wsa:Action value as WSDL Name value not generated.";
            Tr.exit(TRACE_COMPONENT, "generateDefaultActionPatternForMessage", string6);
            return null;
        }
        if (messageType.equals(MessageType.REQUEST) || messageType.equals(MessageType.RESPONSE)) {
            stringBuffer.append(string5);
        } else if (messageType.equals(MessageType.FAULT)) {
            string = this._rpcContext.getWSDLOperation();
            stringBuffer.append(string);
            stringBuffer.append(string4);
            stringBuffer.append("Fault");
            stringBuffer.append(string4);
            stringBuffer.append(string5);
        }
        string = stringBuffer.toString();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "generateDefaultActionPatternForMessage", string);
        }
        return string;
    }

    private String getWSDLName(MessageType messageType) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getWSDLName", messageType);
        }
        String string = null;
        if (MessageType.REQUEST.equals(messageType)) {
            string = this._rpcContext.getWSDLInputName();
            if (string == null || string.length() < 1) {
                string = this._rpcContext.getWSDLOperation();
                if (!((MessageContext)this._rpcContext).isOneWay()) {
                    string = string + "Request";
                }
            }
        } else if (MessageType.RESPONSE.equals(messageType)) {
            string = this._rpcContext.getWSDLOutputName();
            if (string == null || string.length() < 1) {
                string = this._rpcContext.getWSDLOperation() + "Response";
            }
        } else if (MessageType.FAULT.equals(messageType)) {
            string = this._rpcContext.getWSDLFaultName();
        } else {
            String string2 = "Invalid internal parameter passed in to private method so do not know whether message is REQUEST, RESPONSE, or FAULT.";
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getWSDLName", string2);
            }
            return null;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getWSDLName", string);
        }
        return string;
    }

    private String getDefaultTargetNamespaceDelimPortTypeDelim() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getDefaultTargetNamespaceDelimPortTypeDelim");
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = this._rpcContext.getWSDLTargetNamespace();
        if (string == null || string.length() < 1) {
            String string2 = "Unable to determine targetNameSpace via RPCContext.";
            Tr.exit(TRACE_COMPONENT, "getDefaultTargetNamespaceDelimPortTypeDelim", string2);
            return null;
        }
        stringBuffer.append(string);
        String string3 = "/";
        if (string.startsWith("urn:") || string.startsWith("URN:")) {
            string3 = ":";
        }
        if (!string.endsWith(string3)) {
            stringBuffer.append(string3);
        }
        QName qName = this._rpcContext.getWSDLPortType();
        String string4 = null;
        if (qName == null) {
            String string5 = "Unable to determine wsdlPortType via RPCContext.";
            Tr.exit(TRACE_COMPONENT, "getDefaultTargetNamespaceDelimPortTypeDelim", string5);
            return null;
        }
        string4 = qName.getLocalPart();
        if (string4 == null || string4.length() < 1) {
            String string6 = "Unable to determine PortType localpart via RPCContext.";
            Tr.exit(TRACE_COMPONENT, "getDefaultTargetNamespaceDelimPortTypeDelim", string6);
            return null;
        }
        stringBuffer.append(string4);
        stringBuffer.append(string3);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] objectArray = new Object[]{stringBuffer.toString()};
            Tr.exit(TRACE_COMPONENT, "getDefaultTargetNamespaceDelimPortTypeDelim", objectArray);
        }
        return stringBuffer.toString();
    }

    public static class MessageType {
        public static MessageType REQUEST = new MessageType(0);
        public static MessageType RESPONSE = new MessageType(1);
        public static MessageType FAULT = new MessageType(2);
        int id;

        private MessageType(int n) {
            this.id = n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof MessageType)) {
                return false;
            }
            return ((MessageType)object).id == this.id;
        }
    }
}

