/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMapping;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.wsdl.Generator;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaStubWriter;
import com.ibm.ws.webservices.wsdl.utils.OperationDescBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;

public class JavaDeployGenerator
implements Generator {
    protected Emitter emitter;
    protected Definition definition;
    protected SymbolTable symbolTable;
    private Vector typeMappings;
    private Vector operations;
    private HashMap typeMappingsByPort = new HashMap();
    private HashMap operationsByPort = new HashMap();
    public static final String QUERY_TYPEMAPPINGS = "queryTypeMappings";
    public static final String QUERY_OPERATIONS = "queryOperations";

    public JavaDeployGenerator(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        this.emitter = emitter;
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    public void generate() throws IOException {
        this.processServices();
    }

    private void processServices() throws IOException {
        Map map = this.symbolTable.getServices();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            Iterator iterator2 = service.getPorts().values().iterator();
            while (iterator2.hasNext()) {
                Port port2 = (Port)iterator2.next();
                BindingEntry bindingEntry = this.symbolTable.getBindingEntry(port2.getBinding().getQName());
                if (bindingEntry.getBindingType() != 0) continue;
                this.processPort(port2, service, bindingEntry);
            }
        }
    }

    private void processPort(Port port2, Service service, BindingEntry bindingEntry) throws IOException {
        this.typeMappings = new Vector();
        this.operations = new Vector();
        PortType portType = bindingEntry.getBinding().getPortType();
        String string = port2.getName();
        this.typeMappingsByPort.put(string, this.typeMappings);
        this.operationsByPort.put(string, this.operations);
        this.emitter.setDynamicVar(QUERY_TYPEMAPPINGS, this.typeMappingsByPort);
        this.emitter.setDynamicVar(QUERY_OPERATIONS, this.operationsByPort);
        this.processTypes(bindingEntry);
        this.processBinding(bindingEntry);
    }

    private void processTypes(BindingEntry bindingEntry) throws IOException {
        Vector vector = this.symbolTable.getTypes();
        Binding binding = bindingEntry.getBinding();
        for (int i = 0; i < vector.size(); ++i) {
            TypeEntry typeEntry = (TypeEntry)vector.elementAt(i);
            if (!JavaStubWriter.needTypeMapping(typeEntry, this.emitter)) continue;
            this.deployTypeMapping((Type)typeEntry, bindingEntry);
        }
    }

    private void deployTypeMapping(Type type, BindingEntry bindingEntry) throws IOException {
        String string = type.getName();
        if (string.endsWith("[]")) {
            String string2 = JavaUtils.getWrapper(string = string.substring(0, string.length() - 2));
            if (string2 != null) {
                this.deployTypeMapping(type, string2 + "[]", bindingEntry);
            }
        } else {
            String string3 = JavaUtils.getWrapper(string);
            if (string3 != null) {
                this.deployTypeMapping(type, string3, bindingEntry);
            }
        }
        this.deployTypeMapping(type, type.getName(), bindingEntry);
    }

    private void deployTypeMapping(Type type, String string, BindingEntry bindingEntry) throws IOException {
        Serializable serializable;
        String string2 = type.getQName().getNamespaceURI();
        String string3 = type.getQName().getLocalPart();
        String string4 = JavaStubWriter.getSerializerFactoryName(type, string, this.emitter);
        String string5 = JavaStubWriter.getDeserializerFactoryName(type, string, this.emitter);
        String string6 = "";
        if (!bindingEntry.hasLiteral()) {
            string6 = Constants.URI_DEFAULT_SOAP_ENC;
        }
        QName qName = null;
        QName qName2 = null;
        if (type.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN) != null) {
            qName = ((Entry)type.getChildren().get(0)).getQName();
            qName2 = ((TypeEntry)type.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN)).getQName();
        } else if (type.isList()) {
            serializable = type;
            while (((TypeEntry)serializable).getRefType() != null && ((Type)((TypeEntry)serializable).getRefType()).isList()) {
                serializable = (Type)((TypeEntry)serializable).getRefType();
            }
            qName2 = ((TypeEntry)serializable).getRefType().getQName();
        } else if (type.getDimensions().length() > 0 && string4.equals("com.ibm.ws.webservices.engine.encoding.ser.ArraySerializerFactory")) {
            serializable = type.getRefType();
            if (serializable != null) {
                while (((TypeEntry)serializable).getRefType() != null && !(serializable instanceof Type)) {
                    serializable = ((TypeEntry)serializable).getRefType();
                }
                qName2 = ((Entry)((Object)serializable)).getQName();
            }
        } else if (type.isSimpleTypeOrSimpleContent()) {
            for (serializable = type.getRestrictionBase(); serializable != null && ((Type)serializable).getRestrictionBase() != null; serializable = ((Type)serializable).getRestrictionBase()) {
            }
            qName2 = serializable != null ? ((Entry)((Object)serializable)).getQName() : null;
        }
        serializable = (QName)type.getDynamicVar(SymbolTable.LEGACY_QNAME);
        if (serializable != null) {
            this.generateTypeMapping(((QName)serializable).getNamespaceURI(), ((QName)serializable).getLocalPart(), string, string4, string5, string6, (String)type.getDynamicVar("CustomBinderName"), qName, qName2);
        }
        this.generateTypeMapping(string2, string3, string, string4, string5, string6, (String)type.getDynamicVar("CustomBinderName"), qName, qName2);
    }

    private void generateTypeMapping(String string, String string2, String string3, String string4, String string5, String string6, String string7, QName qName, QName qName2) throws IOException {
        WSDDTypeMapping wSDDTypeMapping = new WSDDTypeMapping();
        wSDDTypeMapping.setEncodingStyle(string6);
        wSDDTypeMapping.setLanguageSpecificType(string3);
        wSDDTypeMapping.setQName(new QName(string, string2));
        wSDDTypeMapping.setSerializer(string4);
        wSDDTypeMapping.setDeserializer(string5);
        wSDDTypeMapping.setBinderName(string7);
        wSDDTypeMapping.setComponentQName(qName);
        wSDDTypeMapping.setComponentTypeQName(qName2);
        this.typeMappings.add(wSDDTypeMapping);
    }

    private void processBinding(BindingEntry bindingEntry) throws IOException {
        Binding binding = bindingEntry.getBinding();
        Iterator iterator = binding.getBindingOperations().iterator();
        while (iterator.hasNext()) {
            BindingOperation bindingOperation = (BindingOperation)iterator.next();
            Operation operation = bindingOperation.getOperation();
            OperationType operationType = operation.getStyle();
            BindingOperationEntry bindingOperationEntry = bindingEntry.getOperation(operation);
            if (operationType == OperationType.NOTIFICATION || operationType == OperationType.SOLICIT_RESPONSE || bindingOperationEntry == null) continue;
            this.processOperation(bindingEntry, bindingOperationEntry);
        }
    }

    private void processOperation(BindingEntry bindingEntry, BindingOperationEntry bindingOperationEntry) {
        OperationDescBuilder operationDescBuilder = OperationDescBuilder.create(bindingOperationEntry, bindingEntry, this.symbolTable);
        OperationDesc operationDesc = operationDescBuilder.getOperationDesc(false);
        this.operations.add(operationDesc);
    }

    private String getModeString(byte by) {
        if (by == 1) {
            return "IN";
        }
        if (by == 3) {
            return "INOUT";
        }
        return "OUT";
    }
}

