/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;

public abstract class JavaBeanBaseWriter
extends JavaClassWriter {
    protected Type type;
    protected Type extendType;
    protected Type baseSimpleType = null;
    protected Vector elements;
    protected Vector attributes;
    protected Hashtable _qNameMap = new Hashtable();
    private boolean hasCheckedException = false;

    protected JavaBeanBaseWriter(Emitter emitter, Type type, String string, String string2) {
        super(emitter, string, string2);
        this.type = type;
        this.hasCheckedException = type.getDynamicVar("throwsCheckedException") == null ? false : (Boolean)type.getDynamicVar("throwsCheckedException");
        this.extendType = type.getExtensionBase();
        if (this.extendType == null) {
            this.extendType = type.getRestrictionBase();
        }
        if (type.isSimpleTypeOrSimpleContent() && this.extendType != null) {
            this.baseSimpleType = this.extendType;
            while (this.baseSimpleType.getRestrictionBase() != null || this.baseSimpleType.getExtensionBase() != null) {
                if (this.baseSimpleType.getRestrictionBase() != null) {
                    this.baseSimpleType = this.baseSimpleType.getRestrictionBase();
                    continue;
                }
                this.baseSimpleType = this.baseSimpleType.getExtensionBase();
            }
        }
        this.elements = null;
        this.attributes = null;
        Vector vector = type.getChildren();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.get(i) instanceof ChildElement) {
                    if (this.elements == null) {
                        this.elements = new Vector();
                    }
                    this.elements.add(vector.get(i));
                    continue;
                }
                if (this.attributes == null) {
                    this.attributes = new Vector();
                }
                this.attributes.add(vector.get(i));
            }
        }
    }

    protected boolean isBaseClass() {
        return this.extendType == null || this.extendType.isEnumeration() || this.type.isSimpleContent() && this.type.getExtensionBase() == null || this.baseSimpleType != null && this.baseSimpleType.getName().equals(this.extendType.getName());
    }

    protected void buildQNames() throws IOException {
        Object object;
        ChildEntry childEntry;
        int n;
        if (this.attributes != null) {
            for (n = 0; n < this.attributes.size(); ++n) {
                childEntry = (ChildAttribute)this.attributes.get(n);
                if (this._qNameMap.get(childEntry.getQName()) == null) {
                    this._qNameMap.put(childEntry.getQName(), Utils.returnQNameIdentifier(childEntry.getQName().getNamespaceURI(), childEntry.getQName().getLocalPart()));
                }
                if (this._qNameMap.get(object = Utils.getXSIType(childEntry.getType())) != null) continue;
                this._qNameMap.put(object, Utils.returnQNameIdentifier(((QName)object).getNamespaceURI(), ((QName)object).getLocalPart()));
            }
        }
        if (this.elements != null && !this.type.isSimpleType()) {
            for (n = 0; n < this.elements.size(); ++n) {
                childEntry = (ChildElement)this.elements.get(n);
                object = childEntry.getQName().getLocalPart();
                String string = childEntry.getQName().getNamespaceURI();
                QName qName = new QName(string, (String)object);
                if (this._qNameMap.get(qName) != null) continue;
                this._qNameMap.put(qName, Utils.returnQNameIdentifier(string, (String)object));
            }
        }
    }

    protected void writeQNames(PrintWriter printWriter, String string, String string2) throws IOException {
        Set set = this._qNameMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            String string3 = (String)this._qNameMap.get(qName);
            printWriter.print(string + string2 + " final static javax.xml.namespace.QName ");
            printWriter.println(string3 + " = ");
            printWriter.println(string + "       com.ibm.ws.webservices.engine.utils.QNameTable.createQName(");
            printWriter.println(string + "              \"" + qName.getNamespaceURI() + "\",");
            printWriter.println(string + "              \"" + qName.getLocalPart() + "\");");
        }
    }

    public void startTolerateCheckedException(PrintWriter printWriter, String string) {
        if (this.hasCheckedException) {
            printWriter.println(string + "try {");
        }
    }

    public void endTolerateCheckedException(PrintWriter printWriter, String string) {
        if (this.hasCheckedException) {
            printWriter.println(string + "} catch (java.lang.Throwable _t)  {");
            printWriter.println(string + "  if (!(_t instanceof java.lang.RuntimeException)) {");
            printWriter.println(string + "    _t = new java.lang.RuntimeException(_t);");
            printWriter.println(string + "  }");
            printWriter.println(string + "  throw (java.lang.RuntimeException) _t;");
            printWriter.println(string + "}");
        }
    }
}

