/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.types;

import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.Serializable;
import java.text.FieldPosition;
import java.text.NumberFormat;

public class UnsignedLong
extends Number
implements Comparable,
Serializable {
    protected Double lValue = new Double(0.0);
    private Object __equalsCalc = null;

    public UnsignedLong() {
    }

    public UnsignedLong(double d) throws NumberFormatException {
        this.setValue(d);
    }

    public UnsignedLong(String string) throws NumberFormatException {
        this.setValue(Double.parseDouble(string));
    }

    public void setValue(double d) throws NumberFormatException {
        if (!this.isValid(d)) {
            throw new NumberFormatException(Messages.getMessage("badUnsignedLong00", "[" + String.valueOf(d) + "]"));
        }
        this.lValue = new Double(d);
    }

    private String convertDoubleToUnsignedLong(Double d) {
        if (d != null) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setGroupingUsed(false);
            StringBuffer stringBuffer = new StringBuffer();
            FieldPosition fieldPosition = new FieldPosition(0);
            numberFormat.format(d, stringBuffer, fieldPosition);
            return stringBuffer.toString();
        }
        return null;
    }

    public String toString() {
        return this.convertDoubleToUnsignedLong(this.lValue);
    }

    public int hashCode() {
        if (this.lValue != null) {
            return this.lValue.hashCode();
        }
        return 0;
    }

    public boolean isValid(double d) {
        return !(d < 0.0) && !(d > 1.8446744073709552E19);
    }

    public synchronized boolean equals(Object object) {
        if (!(object instanceof UnsignedLong)) {
            return false;
        }
        UnsignedLong unsignedLong = (UnsignedLong)object;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.__equalsCalc != null) {
            return this.__equalsCalc == object;
        }
        this.__equalsCalc = object;
        boolean bl = this.lValue == null && unsignedLong.lValue == null || this.lValue != null && this.lValue.equals(unsignedLong.lValue);
        this.__equalsCalc = null;
        return bl;
    }

    public int compareTo(Object object) {
        if (this.lValue != null) {
            return this.lValue.compareTo((Double)object);
        }
        if (this.equals(object)) {
            return 0;
        }
        return 1;
    }

    public byte byteValue() {
        return this.lValue.byteValue();
    }

    public short shortValue() {
        return this.lValue.shortValue();
    }

    public int intValue() {
        return this.lValue.intValue();
    }

    public long longValue() {
        return this.lValue.longValue();
    }

    public double doubleValue() {
        return this.lValue;
    }

    public float floatValue() {
        return this.lValue.floatValue();
    }
}

