/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends FilterOutputStream {
    boolean eos = false;
    static final byte[] crlf = "\r\n".getBytes();

    private ChunkedOutputStream() {
        super(null);
    }

    public ChunkedOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n}, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        this.out.write(Integer.toHexString(n2).getBytes());
        this.out.write(crlf);
        this.out.write(byArray, n, n2);
        this.out.write(crlf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eos() throws IOException {
        ChunkedOutputStream chunkedOutputStream = this;
        synchronized (chunkedOutputStream) {
            if (this.eos) {
                return;
            }
            this.eos = true;
        }
        this.out.write("\r\n0\r\n".getBytes());
        this.out.flush();
    }

    public void close() throws IOException {
        this.eos();
        this.out.close();
    }
}

