/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.security.servlet;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.security.AuthenticatedUser;
import com.ibm.ws.webservices.engine.security.SecurityProvider;
import com.ibm.ws.webservices.engine.security.servlet.ServletAuthenticatedUser;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import java.security.Principal;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;

public class ServletSecurityProvider
implements SecurityProvider {
    protected static Log log = LogFactory.getLog(ServletSecurityProvider.class.getName());
    static HashMap users = null;

    public AuthenticatedUser authenticate(MessageContext messageContext) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (httpServletRequest == null) {
            return null;
        }
        log.debug(Messages.getMessage("got00", "HttpServletRequest"));
        Principal principal = httpServletRequest.getUserPrincipal();
        if (principal == null) {
            log.debug(Messages.getMessage("noPrincipal00"));
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("gotPrincipal00", principal.getName()));
        }
        return new ServletAuthenticatedUser(httpServletRequest);
    }

    public boolean userMatches(AuthenticatedUser authenticatedUser, String string) {
        if (authenticatedUser == null) {
            return string == null;
        }
        if (authenticatedUser instanceof ServletAuthenticatedUser) {
            ServletAuthenticatedUser servletAuthenticatedUser = (ServletAuthenticatedUser)authenticatedUser;
            return servletAuthenticatedUser.getRequest().isUserInRole(string);
        }
        return false;
    }
}

