/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.dispatchers;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.FaultDesc;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.dispatchers.BasicDispatcher;
import com.ibm.ws.webservices.engine.dispatchers.Processor;
import com.ibm.ws.webservices.engine.dispatchers.SoapProcessor;
import com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.engine.xmlsoap.builders.WebServicesFaultProcessor;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.Holder;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public class SoapRPCProcessor
extends SoapProcessor {
    protected static Log log = LogFactory.getLog(SoapRPCProcessor.class.getName());
    protected static Processor singleton;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;

    public static Processor getProcessor() {
        if (singleton == null) {
            singleton = new SoapRPCProcessor();
        }
        return singleton;
    }

    private SoapRPCProcessor() {
    }

    public OperationDesc resolveOperation(MessageContext messageContext) throws Exception, WebServicesFault {
        OperationDesc operationDesc = this.getOperation(messageContext);
        if (operationDesc == null) {
            Message message = messageContext.getRequestMessage();
            SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
            SOAPBody sOAPBody = (SOAPBody)sOAPEnvelope.getBody();
            if (sOAPBody == null) {
                if (log.isDebugEnabled()) {
                    log.debug("detected no body.  A body is created.");
                }
                sOAPBody = (SOAPBody)sOAPEnvelope.addBody();
                new RequestResponse("", "", sOAPBody, false, null, new DeserializationContextImpl(messageContext, null));
            }
            RequestResponse requestResponse = sOAPBody.getRequestResponse();
            QName qName = null;
            if (sOAPBody.getNumChildren() > 0) {
                qName = sOAPBody.getChildElement(0).getQName();
            }
            PortDesc portDesc = messageContext != null ? messageContext.getPortDesc() : null;
            String string = qName == null ? "<no element in body>" : qName.toString();
            String string2 = portDesc == null ? "null portDesc" : portDesc.toString();
            throw new WebServicesFault(QNameTable.createQName(messageContext.getSOAPConstants().getEnvelopeURI(), "Client"), Messages.getMessage("noSuchOperation", string, string2), null, null);
        }
        return operationDesc;
    }

    public OperationDesc getOperation(MessageContext messageContext) throws Exception, WebServicesFault {
        try {
            OperationDesc operationDesc = messageContext.getOperation();
            if (operationDesc == null) {
                Message message = messageContext.getRequestMessage();
                SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
                SOAPBody sOAPBody = (SOAPBody)sOAPEnvelope.getBody();
                RequestResponse requestResponse = sOAPBody == null ? null : sOAPBody.getRequestResponse();
                OperationDesc operationDesc2 = operationDesc = requestResponse == null ? null : requestResponse.getOperation();
                if (operationDesc == null) {
                    QName qName = requestResponse == null ? null : requestResponse.getQName();
                    SOAPPort sOAPPort = messageContext.getPort();
                    PortDesc portDesc = sOAPPort.getPortDesc();
                    if (qName != null) {
                        operationDesc = portDesc.getOperationByElementQName(qName);
                    }
                }
                messageContext.setOperation(operationDesc);
            }
            return operationDesc;
        }
        catch (Exception exception) {
            throw WebServicesFault.makeFault(exception);
        }
    }

    public void processMessage(MessageContext messageContext, BasicDispatcher basicDispatcher, Object object) throws Exception, WebServicesFault {
        Object object2;
        Serializable serializable;
        Object object3;
        Message message;
        SOAPEnvelope sOAPEnvelope;
        SOAPBody sOAPBody;
        if (log.isDebugEnabled()) {
            log.debug("Enter: SoapRPCProcessor.processMessage()");
        }
        if ((sOAPBody = (SOAPBody)(sOAPEnvelope = (message = messageContext.getRequestMessage()).getSOAPEnvelope()).getBody()) == null) {
            if (log.isDebugEnabled()) {
                log.debug("detected no body.  A body is created.");
            }
            sOAPBody = (SOAPBody)sOAPEnvelope.addBody();
            new RequestResponse("", "", sOAPBody, false, null, new DeserializationContextImpl(messageContext, null));
        }
        sOAPBody.getSOAPFactory().setProtectState(false);
        RequestResponse requestResponse = sOAPBody.getRequestResponse();
        OperationDesc operationDesc = this.resolveOperation(messageContext);
        Vector vector = requestResponse.getParams();
        Object[] objectArray = new Object[operationDesc.getNumParams()];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ParamValue paramValue = (ParamValue)vector.get(i);
            object3 = paramValue.getValue();
            serializable = paramValue.getParamDesc();
            if (serializable != null && ((ParameterDesc)serializable).getJavaSigType() != null) {
                object2 = ((ParameterDesc)serializable).getJavaSigType();
                try {
                    object3 = JavaUtils.convert(object3, (Class)object2);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.dispatchers.SoapRPCProcessor.processMessage", "204", this);
                    throw new Exception("convert problem " + object3.getClass() + " " + object2);
                }
                paramValue.setValue(object3);
                if (((ParameterDesc)serializable).getMode() == 3) {
                    arrayList.add(paramValue);
                }
            }
            if (serializable == null || ((ParameterDesc)serializable).getOrder() == -1) {
                objectArray[i] = object3;
            } else {
                objectArray[((ParameterDesc)serializable).getOrder()] = object3;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("  " + Messages.getMessage("value00", JavaUtils.getObjectIdentity(object3)));
        }
        if (n < objectArray.length) {
            ArrayList arrayList2 = operationDesc.getOutParams();
            for (int i = 0; i < arrayList2.size(); ++i) {
                object3 = (ParameterDesc)arrayList2.get(i);
                serializable = ((ParameterDesc)object3).getJavaSigType();
                if (serializable == null || !(class$javax$xml$rpc$holders$Holder == null ? SoapRPCProcessor.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder).isAssignableFrom((Class<?>)serializable)) {
                    throw new WebServicesFault(Messages.getMessage("badOutParameter00", "" + ((ParameterDesc)object3).getQName(), operationDesc.getName()));
                }
                objectArray[n + i] = ((Class)serializable).newInstance();
                object2 = new ParamValue(((ParameterDesc)object3).getQName(), objectArray[n + i]);
                ((ParamValue)object2).setParamDesc((ParameterDesc)object3);
                arrayList.add(object2);
            }
        }
        if (operationDesc.isOneway()) {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("onewayOperation", operationDesc.getName()));
            }
            if (log.isDebugEnabled()) {
                log.debug("Oneway operation.");
            }
            this.processOneway(messageContext, basicDispatcher, operationDesc, object, objectArray);
        } else {
            Object object4 = messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectRequired");
            if (object4 != null) {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("asyncOperation", operationDesc.getName()));
                }
                if (log.isDebugEnabled()) {
                    log.debug("Async operation.");
                }
                try {
                    if (messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectResponse") != null && messageContext.getProperty("com.ibm.ws.wsaddressing.RedirectFault") != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Close client connection as response will be sent async.");
                        }
                        messageContext.oneWayEvent();
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.webservices.engine.dispatchers.SoapRPCProcessor.processOneway", "1:408:1.23", this);
                }
                QName qName = requestResponse.getQName();
                this.processRequestResponse(messageContext, basicDispatcher, operationDesc, object, objectArray, arrayList, qName.getNamespaceURI());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("R-ROperation", operationDesc.getName()));
                }
                if (log.isDebugEnabled()) {
                    log.debug("R-R operation.");
                }
                QName qName = requestResponse.getQName();
                this.processRequestResponse(messageContext, basicDispatcher, operationDesc, object, objectArray, arrayList, qName.getNamespaceURI());
            }
        }
    }

    private void processOneway(MessageContext messageContext, BasicDispatcher basicDispatcher, OperationDesc operationDesc, Object object, Object[] objectArray) {
        try {
            messageContext.oneWayEvent();
            basicDispatcher.invokeOperation(operationDesc, object, objectArray, messageContext);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.webservices.engine.dispatchers.SoapRPCProcessor.processOneway", "1:408:1.23", this);
        }
    }

    private void processRequestResponse(MessageContext messageContext, BasicDispatcher basicDispatcher, OperationDesc operationDesc, Object object, Object[] objectArray, ArrayList arrayList, String string) throws Exception {
        String string2;
        Object object2 = null;
        try {
            object2 = basicDispatcher.invokeOperation(operationDesc, object, objectArray, messageContext);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.dispatchers.SoapRPCProcessor.processRequestResponse", "1:431:1.23", this);
            Throwable throwable = WebServicesFault.getRootCause(exception);
            FaultDesc faultDesc = operationDesc.getFaultByClass(throwable.getClass());
            if (faultDesc != null) {
                WebServicesFaultProcessor.copyWSAFaultAction(faultDesc, messageContext);
                throw WebServicesFault.makeUserFault((Exception)throwable, faultDesc.getFaultCode());
            }
            throw exception;
        }
        messageContext.setPastPivot(true);
        String string3 = operationDesc.getElementQName() != null ? operationDesc.getElementQName().getLocalPart() : operationDesc.getName();
        SOAPEnvelope sOAPEnvelope = this.createResponseEnvelope(messageContext);
        String string4 = (String)operationDesc.getOption(OperationDesc.RESPONSE_NAMESPACE);
        if (string4 == null) {
            string4 = string;
        }
        if ((string2 = (String)operationDesc.getOption(OperationDesc.RESPONSE_LOCALPART)) == null) {
            string2 = string3 + "Response";
        }
        RequestResponse requestResponse = new RequestResponse(string4, string2, (SOAPBody)sOAPEnvelope.getBody(), true);
        String string5 = messageContext.getEncodingStyle();
        if (string5 != null && string5.length() > 0) {
            sOAPEnvelope.getBody().setEncodingStyle(string5);
            sOAPEnvelope.getHeader().setEncodingStyle(string5);
        }
        try {
            Object object3;
            ParamValue paramValue;
            Object object4;
            if (operationDesc.getMethod().getReturnType() != Void.TYPE) {
                object4 = operationDesc.getReturnQName();
                if (object4 == null) {
                    object4 = QNameTable.createQName("", string3 + "Return");
                }
                if (messageContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS) {
                    object4 = Constants.QNAME_RPC_RESULT;
                }
                paramValue = new ParamValue((QName)object4, object2);
                paramValue.setParamDesc(operationDesc.getReturnParamDesc());
                if (!operationDesc.isReturnHeader()) {
                    requestResponse.addParam(paramValue);
                } else {
                    object3 = sOAPEnvelope.getSOAPFactory().createSOAPHeaderElement(paramValue.getQName().getNamespaceURI(), paramValue.getQName().getLocalPart());
                    ((SOAPElement)object3).setAlternateContent(paramValue);
                    sOAPEnvelope.getHeader().addChildElement((javax.xml.soap.SOAPElement)object3);
                }
            }
            if (!arrayList.isEmpty()) {
                object4 = arrayList.iterator();
                while (object4.hasNext()) {
                    paramValue = (ParamValue)object4.next();
                    object3 = (Holder)paramValue.getValue();
                    Object object5 = JavaUtils.getHolderValue(object3);
                    ParameterDesc parameterDesc = paramValue.getParamDesc();
                    paramValue.setValue(object5);
                    if (parameterDesc != null && parameterDesc.isOutHeader()) {
                        SOAPHeaderElement sOAPHeaderElement = sOAPEnvelope.getSOAPFactory().createSOAPHeaderElement(paramValue.getQName().getNamespaceURI(), paramValue.getQName().getLocalPart());
                        sOAPHeaderElement.setAlternateContent(paramValue);
                        sOAPEnvelope.getHeader().addChildElement(sOAPHeaderElement);
                        continue;
                    }
                    requestResponse.addParam(paramValue);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.engine.dispatchers.SoapRPCProcessor.processRequestResponse", "1:519:1.23", this);
            throw exception;
        }
    }

    protected final SOAPEnvelope createResponseEnvelope(MessageContext messageContext) throws SOAPException {
        SOAPFactory sOAPFactory = new SOAPFactory(messageContext.getSOAPConstants());
        SOAPEnvelope sOAPEnvelope = sOAPFactory.createSOAPEnvelope(true);
        Message message = new Message(sOAPEnvelope);
        messageContext.setResponseMessage(message);
        return sOAPEnvelope;
    }
}

