/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.SimpleChain;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDHandler;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class WSDDChain
extends WSDDHandler {
    private final boolean _reverse;
    private boolean _dirty = false;
    private Vector _handlers = new Vector();

    public WSDDChain(boolean bl) {
        this._reverse = bl;
    }

    public WSDDChain(boolean bl, Element element) throws WSDDException {
        super(element);
        int n;
        this._reverse = bl;
        if (this.getType() != null) {
            return;
        }
        Element[] elementArray = this.getChildElements(element, "handler");
        if (elementArray.length != 0) {
            for (n = 0; n < elementArray.length; ++n) {
                this.addHandler(new WSDDHandler(elementArray[n]));
            }
        }
        if ((elementArray = this.getChildElements(element, "chain")).length != 0) {
            for (n = 0; n < elementArray.length; ++n) {
                this.addHandler(new WSDDChain(bl, elementArray[n]));
            }
        }
        if (this._handlers.isEmpty()) {
            throw new WSDDException(Messages.getMessage("noHandlersInChain00", this.getElementName().getLocalPart(), this.getQName() != null ? this.getQName().toString() : "null"));
        }
    }

    protected QName getElementName() {
        return WSDDConstants.QNAME_CHAIN;
    }

    public void addHandler(WSDDHandler wSDDHandler) {
        this._handlers.add(wSDDHandler);
        this._dirty = true;
        this.manageLifeCycleOf(wSDDHandler);
    }

    public Vector getHandlers() {
        if (this._dirty) {
            this.sort();
        }
        return this._handlers;
    }

    public void removeHandler(WSDDHandler wSDDHandler) {
        if (this._handlers.remove(wSDDHandler)) {
            this._dirty = true;
            if (this.releaseLifeCycleManagementOf(wSDDHandler) && wSDDHandler.isActive()) {
                wSDDHandler.destroy();
            }
        }
    }

    private void sort() {
        if (this._handlers != null) {
            if (this._reverse) {
                Collections.sort(this._handlers, Collections.reverseOrder());
                int n = this._handlers.size() - 1;
                for (int i = 0; i <= n; ++i) {
                    WSDDHandler wSDDHandler = (WSDDHandler)this._handlers.get(i);
                    wSDDHandler.setParameter("com.ibm.websphere.webservices.handler.position", String.valueOf(n - i));
                }
            } else {
                Collections.sort(this._handlers);
                for (int i = 0; i < this._handlers.size(); ++i) {
                    WSDDHandler wSDDHandler = (WSDDHandler)this._handlers.get(i);
                    wSDDHandler.setParameter("com.ibm.websphere.webservices.handler.position", String.valueOf(i));
                }
            }
            this._dirty = false;
        }
    }

    protected Handler makeNewHandler(EngineConfiguration engineConfiguration) throws ConfigurationException {
        SimpleChain simpleChain = new SimpleChain();
        if (this._dirty) {
            this.sort();
        }
        for (int i = 0; i < this._handlers.size(); ++i) {
            WSDDHandler wSDDHandler = (WSDDHandler)this._handlers.get(i);
            Handler handler2 = wSDDHandler.getInstance(engineConfiguration);
            if (handler2 == null) {
                throw new WSDDException("Can't find handler name:'" + wSDDHandler.getQName() + "' type:'" + wSDDHandler.getType() + "' in the registry");
            }
            simpleChain.addHandler(handler2);
        }
        return simpleChain;
    }

    public void writeToContext(SerializationContext serializationContext) throws IOException {
        AttributesImpl attributesImpl = new AttributesImpl();
        QName qName = this.getQName();
        if (qName != null) {
            attributesImpl.addAttribute("", "name", "name", "CDATA", serializationContext.getSerializationWriter().qName2String(qName));
        }
        if (this.getType() != null) {
            attributesImpl.addAttribute("", "type", "type", "CDATA", serializationContext.getSerializationWriter().qName2String(this.getType()));
        }
        serializationContext.getSerializationWriter().startElement(this.getElementName(), attributesImpl);
        if (this._dirty) {
            this.sort();
        }
        for (int i = 0; i < this._handlers.size(); ++i) {
            WSDDHandler wSDDHandler = (WSDDHandler)this._handlers.get(i);
            wSDDHandler.writeToContext(serializationContext);
        }
        serializationContext.getSerializationWriter().endElement();
    }

    public void _destroy() {
        super._destroy();
        this._handlers.clear();
    }
}

