/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.ArrayList;
import java.util.List;

public class ManagementScopeData {
    private static final TraceComponent tc = Tr.register(ManagementScopeData.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    String scopeType = null;
    String cellName = null;
    String nodeGroupName = null;
    String nodeName = null;
    String processName = null;
    String clusterName = null;
    String endPointName = null;
    String fullScope = null;
    String newFullScope = null;
    String processScope = null;
    String nodeScope = null;
    String nodeGroupScope = null;
    String clusterScope = null;
    String cellScope = null;
    String endPointScope = null;

    public ManagementScopeData(String string) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ManagementScopeData: " + string);
        }
        this.fullScope = string;
        if (this.fullScope != null) {
            int n = -1;
            int n2 = -1;
            n = this.fullScope.lastIndexOf("(");
            if (n != -1) {
                n2 = this.fullScope.lastIndexOf(")");
            }
            if (n != -1 && n2 != -1) {
                this.scopeType = this.fullScope.substring(n + 1, n2);
                if (!this.isTypeValid(this.scopeType)) {
                    throw new IllegalArgumentException("Invalid scope type: " + this.scopeType);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ScopeType: " + this.scopeType);
                }
            } else {
                throw new IllegalArgumentException("Invalid scope: " + this.fullScope);
            }
            n = this.fullScope.indexOf("(cell):");
            if (n != -1) {
                n2 = this.fullScope.indexOf(":", n + "(cell):".length());
                this.cellName = n2 != -1 ? this.fullScope.substring(n + "(cell):".length(), n2) : this.fullScope.substring(n + "(cell):".length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CellName: " + this.cellName);
                }
            }
            if ((n = this.fullScope.indexOf("(nodegroup):")) != -1) {
                n2 = this.fullScope.indexOf(":", n + "(nodegroup):".length());
                this.nodeGroupName = n2 != -1 ? this.fullScope.substring(n + "(nodegroup):".length(), n2) : this.fullScope.substring(n + "(nodegroup):".length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeGroupName: " + this.nodeGroupName);
                }
            }
            if ((n = this.fullScope.indexOf("(cluster):")) != -1) {
                n2 = this.fullScope.indexOf(":", n + "(cluster):".length());
                this.clusterName = n2 != -1 ? this.fullScope.substring(n + "(cluster):".length(), n2) : this.fullScope.substring(n + "(cluster):".length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ClusterName: " + this.clusterName);
                }
            }
            if ((n = this.fullScope.indexOf("(node):")) != -1) {
                n2 = this.fullScope.indexOf(":", n + "(node):".length());
                this.nodeName = n2 != -1 ? this.fullScope.substring(n + "(node):".length(), n2) : this.fullScope.substring(n + "(node):".length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NodeName: " + this.nodeName);
                }
            }
            if ((n = this.fullScope.indexOf("(server):")) != -1) {
                n2 = this.fullScope.indexOf(":", n + "(server):".length());
                this.processName = n2 != -1 ? this.fullScope.substring(n + "(server):".length(), n2) : this.fullScope.substring(n + "(server):".length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ServerName: " + this.processName);
                }
            }
            if ((n = this.fullScope.indexOf("(endpoint):")) != -1) {
                n2 = this.fullScope.indexOf(":", n + "(endpoint):".length());
                this.endPointName = n2 != -1 ? this.fullScope.substring(n + "(endpoint):".length(), n2) : this.fullScope.substring(n + "(endpoint):".length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EndPointName: " + this.endPointName);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ManagementScopeData");
        }
    }

    public String formFullScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formFullScope");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cellName != null) {
            stringBuffer.append("(cell):");
            stringBuffer.append(this.cellName);
        }
        if (this.nodeGroupName != null) {
            stringBuffer.append("(nodegroup):");
            stringBuffer.append(this.nodeGroupName);
        }
        if (this.clusterName != null) {
            stringBuffer.append(":(cluster):");
            stringBuffer.append(this.clusterName);
        }
        if (this.nodeName != null) {
            stringBuffer.append(":(node):");
            stringBuffer.append(this.nodeName);
        }
        if (this.processName != null) {
            stringBuffer.append(":(server):");
            stringBuffer.append(this.processName);
        }
        if (this.endPointName != null) {
            stringBuffer.append(":(endpoint):");
            stringBuffer.append(this.endPointName);
        }
        this.newFullScope = stringBuffer.toString();
        if (this.newFullScope.endsWith(":")) {
            this.newFullScope = this.newFullScope.substring(0, this.newFullScope.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formFullScope: " + this.newFullScope);
        }
        return this.newFullScope;
    }

    public String formEndPointScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formEndPointScope");
        }
        if (this.endPointScope == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(cell):");
            stringBuffer.append(this.cellName);
            stringBuffer.append(":(node):");
            stringBuffer.append(this.nodeName);
            stringBuffer.append(":(server):");
            stringBuffer.append(this.processName);
            stringBuffer.append(":(endpoint):");
            stringBuffer.append(this.endPointName);
            this.endPointScope = stringBuffer.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formEndPointScope: " + this.endPointScope);
        }
        return this.endPointScope;
    }

    public String formProcessScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formProcessScope");
        }
        if (this.processScope == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(cell):");
            stringBuffer.append(this.cellName);
            stringBuffer.append(":(node):");
            stringBuffer.append(this.nodeName);
            stringBuffer.append(":(server):");
            stringBuffer.append(this.processName);
            this.processScope = stringBuffer.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formProcessScope: " + this.processScope);
        }
        return this.processScope;
    }

    public String formNodeGroupScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formNodeGroupScope");
        }
        if (this.nodeGroupScope == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(cell):");
            stringBuffer.append(this.cellName);
            stringBuffer.append(":(nodegroup):");
            stringBuffer.append(this.nodeGroupName);
            this.nodeGroupScope = stringBuffer.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formNodeGroupScope: " + this.nodeGroupScope);
        }
        return this.nodeGroupScope;
    }

    public String formNodeScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formNodeScope");
        }
        if (this.nodeScope == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(cell):");
            stringBuffer.append(this.cellName);
            stringBuffer.append(":(node):");
            stringBuffer.append(this.nodeName);
            this.nodeScope = stringBuffer.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formNodeScope: " + this.nodeScope);
        }
        return this.nodeScope;
    }

    public String formCellScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formCellScope");
        }
        if (this.cellScope == null) {
            this.cellScope = "(cell):" + this.cellName;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formCellScope: " + this.cellScope);
        }
        return this.cellScope;
    }

    public String formClusterScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formClusterScope");
        }
        if (this.clusterScope == null && this.clusterName != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(cell):");
            stringBuffer.append(this.cellName);
            stringBuffer.append(":(cluster):");
            stringBuffer.append(this.clusterName);
            this.clusterScope = stringBuffer.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formClusterScope: " + this.clusterScope);
        }
        return this.clusterScope;
    }

    public String getCellName() {
        return this.cellName;
    }

    public void setCellName(String string) {
        this.cellName = string;
    }

    public String getNodeGroupName() {
        return this.nodeGroupName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getEndPointName() {
        return this.endPointName;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public List subScopes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.formEndPointScope());
        arrayList.add(this.formProcessScope());
        arrayList.add(this.formNodeGroupScope());
        arrayList.add(this.formNodeScope());
        arrayList.add(this.formCellScope());
        arrayList.add(this.formClusterScope());
        return arrayList;
    }

    private boolean isTypeValid(String string) {
        return string.equalsIgnoreCase("cell") || string.equalsIgnoreCase("nodeGroup") || string.equalsIgnoreCase("node") || string.equalsIgnoreCase("server") || string.equalsIgnoreCase("cluster") || string.equalsIgnoreCase("endpoint");
    }
}

