/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.util.PlatformClusterConfigHelper;
import com.ibm.ws.management.util.PlatformClusterMemberConfigHelper;
import com.ibm.ws.management.util.PlatformServerConfigHelper;
import com.ibm.ws.util.ImplFactory;

public class ConfigHelperFactory {
    private static TraceComponent tc = Tr.register(ConfigHelperFactory.class, "Admin", null);
    private static ManagedObjectMetadataAccessor metadataAccessor = null;
    private static ManagedObjectMetadataHelper metadataHelper = null;

    public static PlatformServerConfigHelper getPlatformServerConfigHelper(Node node) {
        PlatformServerConfigHelper platformServerConfigHelper = null;
        String string = null;
        String string2 = ConfigHelperFactory.normalizePlatform(node);
        string = string2 != null && string2.length() > 0 ? "com.ibm.ws.management.util." + string2 + ".PlatformServerConfigHelperImpl" : "com.ibm.ws.management.util.PlatformServerConfigHelperImpl";
        platformServerConfigHelper = (PlatformServerConfigHelper)ConfigHelperFactory.getImplFromClass(string);
        if (platformServerConfigHelper == null) {
            platformServerConfigHelper = (PlatformServerConfigHelper)ConfigHelperFactory.getImplFromImplFactory(string);
        }
        if (platformServerConfigHelper == null) {
            platformServerConfigHelper = (PlatformServerConfigHelper)ConfigHelperFactory.getDefaultHelper("PlatformServerConfigHelperImpl");
        }
        return platformServerConfigHelper;
    }

    public static PlatformClusterConfigHelper getPlatformClusterConfigHelper(Node node) {
        PlatformClusterConfigHelper platformClusterConfigHelper = null;
        String string = null;
        String string2 = ConfigHelperFactory.normalizePlatform(node);
        string = string2 != null && string2.length() > 0 ? "com.ibm.ws.management.util." + string2 + ".PlatformClusterConfigHelperImpl" : "com.ibm.ws.management.util.PlatformClusterConfigHelperImpl";
        platformClusterConfigHelper = (PlatformClusterConfigHelper)ConfigHelperFactory.getImplFromClass(string);
        if (platformClusterConfigHelper == null) {
            platformClusterConfigHelper = (PlatformClusterConfigHelper)ConfigHelperFactory.getImplFromImplFactory(string);
        }
        if (platformClusterConfigHelper == null) {
            platformClusterConfigHelper = (PlatformClusterConfigHelper)ConfigHelperFactory.getDefaultHelper("PlatformClusterConfigHelperImpl");
        }
        return platformClusterConfigHelper;
    }

    public static PlatformClusterMemberConfigHelper getPlatformClusterMemberConfigHelper(Node node) {
        PlatformClusterMemberConfigHelper platformClusterMemberConfigHelper = null;
        String string = null;
        String string2 = ConfigHelperFactory.normalizePlatform(node);
        string = string2 != null && string2.length() > 0 ? "com.ibm.ws.management.util." + string2 + ".PlatformClusterMemberHelperImpl" : "com.ibm.ws.management.util.PlatformClusterMemberHelperImpl";
        platformClusterMemberConfigHelper = (PlatformClusterMemberConfigHelper)ConfigHelperFactory.getImplFromClass(string);
        if (platformClusterMemberConfigHelper == null) {
            platformClusterMemberConfigHelper = (PlatformClusterMemberConfigHelper)ConfigHelperFactory.getImplFromImplFactory(string);
        }
        if (platformClusterMemberConfigHelper == null) {
            platformClusterMemberConfigHelper = (PlatformClusterMemberConfigHelper)ConfigHelperFactory.getDefaultHelper("PlatformClusterMemberHelperImpl");
        }
        return platformClusterMemberConfigHelper;
    }

    private static String normalizePlatform(Node node) {
        ManagedObjectMetadataHelper managedObjectMetadataHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "normalizePlatform()", node);
        }
        boolean bl = false;
        String string = null;
        try {
            string = node.getName();
            managedObjectMetadataHelper = ConfigHelperFactory.getMetadataHelper();
            if (managedObjectMetadataHelper.isNodeZOS(string)) {
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isNodeZOS", new Boolean(bl));
                }
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "Error during initializing ManagedObjectMetadataHelper", exception);
        }
        if (AdminHelper.getPlatformHelper().isZOS() || bl) {
            return "zos";
        }
        if (node != null && (managedObjectMetadataHelper = null) != null && ((String)((Object)managedObjectMetadataHelper)).length() > 0) {
            if (((String)((Object)managedObjectMetadataHelper)).startsWith("win")) {
                return "win";
            }
            if (((String)((Object)managedObjectMetadataHelper)).startsWith("sun")) {
                return "sun";
            }
            if (((String)((Object)managedObjectMetadataHelper)).startsWith("os400")) {
                return "os400";
            }
            if (((String)((Object)managedObjectMetadataHelper)).startsWith("hp")) {
                return "hp";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "normalizePlatform()");
        }
        return null;
    }

    private static Object getImplFromImplFactory(String string) {
        Object object = null;
        try {
            object = ImplFactory.loadImplFromKey(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    private static Object getImplFromClass(String string) {
        Object var1_1 = null;
        try {
            Class<?> clazz = Class.forName(string);
            var1_1 = clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return var1_1;
    }

    private static Object getDefaultHelper(String string) {
        Object object = null;
        object = ConfigHelperFactory.getImplFromClass("com.ibm.ws.management.util." + string);
        return object;
    }

    private static synchronized ManagedObjectMetadataHelper getMetadataHelper() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMetadataHelper");
        }
        if (metadataAccessor == null) {
            metadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(null);
            metadataHelper = new ManagedObjectMetadataHelper(metadataAccessor);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMetadataHelper");
        }
        return metadataHelper;
    }
}

