/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class TrailerCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(TrailerCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static TrailerCallback myInstance = null;

    private TrailerCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new TrailerCallback();
        }
    }

    public static final TrailerCallback getRef() {
        if (null == myInstance) {
            TrailerCallback.createSingleton();
        }
        return myInstance;
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: vc=" + virtualConnection);
        }
        if (virtualConnection instanceof OutboundVirtualConnection) {
            HttpOutboundServiceContextImpl httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
            httpOutboundServiceContextImpl.continueRead();
        } else {
            HttpInboundServiceContextImpl httpInboundServiceContextImpl = (HttpInboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC);
            httpInboundServiceContextImpl.continueRead();
        }
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called: vc=" + virtualConnection + " ioe=" + iOException);
        }
        if (virtualConnection instanceof OutboundVirtualConnection) {
            HttpOutboundServiceContextImpl httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
            if (httpOutboundServiceContextImpl.canceledRead()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ignoring error callback on canceled read");
                }
                httpOutboundServiceContextImpl.resetCanceledRead();
                return;
            }
            httpOutboundServiceContextImpl.setPersistent(false);
            httpOutboundServiceContextImpl.getAppReadCallback().error(virtualConnection, iOException);
        } else {
            HttpInboundServiceContextImpl httpInboundServiceContextImpl = (HttpInboundServiceContextImpl)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC);
            if (httpInboundServiceContextImpl.canceledRead()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ignoring error callback on canceled read");
                }
                httpInboundServiceContextImpl.resetCanceledRead();
                return;
            }
            httpInboundServiceContextImpl.setPersistent(false);
            httpInboundServiceContextImpl.getAppReadCallback().error(virtualConnection, iOException);
        }
    }
}

