/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.ffdc.CallStack;
import com.ibm.ws.ffdc.Configure;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDCHelper;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.ffdc.IncidentStreamManager;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Hashtable;

class DiagnosticEngine {
    private static int processLevel;
    private static Hashtable globalHashTableOfDM;
    private static final ThreadLocal threadLocalIncidentStream;
    private static final ThreadLocal threadLocalHTofDM;

    private DiagnosticEngine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processIncident(Object object, Throwable throwable, String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2, long l, String string5, Object[] objectArray) {
        String string6 = null;
        String string7 = null;
        int n = 0;
        int n2 = 2;
        boolean bl = false;
        Hashtable<Integer, DiagnosticModule> hashtable = (Hashtable<Integer, DiagnosticModule>)threadLocalHTofDM.get();
        if (hashtable == null) {
            hashtable = new Hashtable<Integer, DiagnosticModule>();
            threadLocalHTofDM.set(hashtable);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Date date = new Date();
        FieldPosition fieldPosition = new FieldPosition(0);
        IncidentStream incidentStream = (IncidentStream)threadLocalIncidentStream.get();
        if (incidentStream == null) {
            incidentStream = IncidentStreamManager.getIncidentStream();
            threadLocalIncidentStream.set(incidentStream);
        } else {
            IncidentStreamManager.openIncidentStream();
        }
        date.setTime(l);
        DateFormat dateFormat = FFDCHelper.getBasicDateFormatter();
        DiagnosticEngine.formatTime(stringBuffer, dateFormat, date, fieldPosition);
        incidentStream.write("------Start of DE processing------", stringBuffer.toString());
        incidentStream.writeLine(", key", string5);
        if (globalHashTableOfDM == null || globalHashTableOfDM.isEmpty()) {
            DiagnosticEngine.dumpObjectAndStack(string, string2, string3, object, string4, n2, incidentStream);
            return;
        }
        if (object != null) {
            string7 = DiagnosticEngine.analyzeObject(object);
        } else {
            bl = true;
            n = CallStack.currentExecutionPoint(stringArray2);
            if (stringArray2 != null && n > 0 && n < stringArray2.length) {
                string6 = stringArray2[n];
                string7 = DiagnosticEngine.getPackageName(string6);
            }
        }
        switch (processLevel) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                incidentStream.introspectAndWriteLine("Stack Dump", string4);
                break;
            }
            case 3: {
                DiagnosticEngine.dumpObjectAndStack(string, string2, string3, object, string4, n2, incidentStream);
                break;
            }
            case 4: {
                n2 = 0;
                DiagnosticEngine.dumpObjectAndStack(string, string2, string3, object, string4, n2, incidentStream);
                DiagnosticModule diagnosticModule = null;
                Hashtable hashtable2 = globalHashTableOfDM;
                synchronized (hashtable2) {
                    diagnosticModule = DiagnosticEngine.findDM(string7);
                    if (diagnosticModule == null) {
                        diagnosticModule = DiagnosticEngine.findDM(string2);
                    }
                }
                if (diagnosticModule == null) {
                    n2 = 3;
                    DiagnosticEngine.dumpObjectAndStack(string, string2, string3, object, string4, n2, incidentStream);
                    break;
                }
                try {
                    boolean bl2 = diagnosticModule.dumpComponentData(stringArray, throwable, incidentStream, object, objectArray, string2, stringArray2);
                }
                catch (Exception exception) {}
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                int n3 = 0;
                if (processLevel == 5) {
                    if (!bl) {
                        n = CallStack.currentExecutionPoint(stringArray2);
                    }
                    n3 = n;
                } else if (stringArray2 != null) {
                    n3 = stringArray2.length - 1;
                }
                boolean bl3 = false;
                boolean bl4 = true;
                DiagnosticModule diagnosticModule = null;
                n2 = 0;
                DiagnosticEngine.dumpObjectAndStack(string, string2, string3, object, string4, n2, incidentStream);
                if (hashtable == null) {
                    hashtable = new Hashtable();
                }
                for (int i = n3; stringArray2 != null && i >= 0; --i) {
                    string6 = stringArray2[i];
                    string7 = DiagnosticEngine.getPackageName(string6);
                    Integer n4 = new Integer(string7.hashCode());
                    Hashtable hashtable3 = globalHashTableOfDM;
                    synchronized (hashtable3) {
                        diagnosticModule = DiagnosticEngine.findDM(string7);
                    }
                    if (diagnosticModule == null || hashtable == null || hashtable.containsKey(n4)) continue;
                    hashtable.put(n4, diagnosticModule);
                    bl3 = true;
                    try {
                        bl4 = diagnosticModule.dumpComponentData(stringArray, throwable, incidentStream, object, objectArray, string2, stringArray2);
                        if (bl4) continue;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl3) break;
                n2 = 3;
                DiagnosticEngine.dumpObjectAndStack(string, string2, string3, object, string4, n2, incidentStream);
            }
        }
    }

    private static String analyzeObject(Object object) {
        return object.getClass().getName();
    }

    private static String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }

    static final void configure(Configure configure) {
        processLevel = configure.processLevel;
    }

    private static DiagnosticModule findDM(String string) {
        String string2 = string;
        boolean bl = false;
        DiagnosticModule diagnosticModule = null;
        while (!bl) {
            Integer n = new Integer(string2.hashCode());
            if (globalHashTableOfDM.containsKey(n)) {
                diagnosticModule = (DiagnosticModule)globalHashTableOfDM.get(n);
                bl = true;
                continue;
            }
            if ((string2 = DiagnosticEngine.trim(string2)) != null) continue;
            return null;
        }
        return diagnosticModule;
    }

    private static String trim(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean registerDM(DiagnosticModule diagnosticModule, String string) {
        Hashtable hashtable = globalHashTableOfDM;
        synchronized (hashtable) {
            Integer n = new Integer(string.hashCode());
            if (globalHashTableOfDM.containsKey(n)) {
                return false;
            }
            globalHashTableOfDM.put(n, diagnosticModule);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean deregisterDM(String string) {
        Hashtable hashtable = globalHashTableOfDM;
        synchronized (hashtable) {
            Integer n = new Integer(string.hashCode());
            if (globalHashTableOfDM.containsKey(n)) {
                globalHashTableOfDM.remove(n);
                return true;
            }
        }
        return false;
    }

    static void reset() {
        threadLocalIncidentStream.set(null);
        Hashtable hashtable = (Hashtable)threadLocalHTofDM.get();
        if (hashtable != null) {
            hashtable.clear();
        }
        threadLocalHTofDM.set(null);
    }

    private static void dumpObjectAndStack(String string, String string2, String string3, Object object, String string4, int n, IncidentStream incidentStream) {
        incidentStream.writeLine("Exception", string);
        incidentStream.writeLine("Source", string2);
        incidentStream.writeLine("probeid", string3);
        if (n < 3) {
            incidentStream.writeLine("Stack Dump", string4);
        }
        incidentStream.introspectAndWriteLine("Dump of callerThis", object, n);
    }

    private static void formatTime(StringBuffer stringBuffer, DateFormat dateFormat, Date date, FieldPosition fieldPosition) {
        stringBuffer.setLength(0);
        stringBuffer.append('[');
        dateFormat.format(date, stringBuffer, fieldPosition);
        stringBuffer.append("] ");
    }

    static {
        globalHashTableOfDM = null;
        threadLocalIncidentStream = new ThreadLocal();
        threadLocalHTofDM = new ThreadLocal();
        globalHashTableOfDM = new Hashtable();
    }
}

