/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras.server;

import com.ibm.ras.RASMessageCatalog;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RASConnectionHandler
implements Runnable {
    private boolean toFile = false;
    private PrintWriter pWriter = null;
    private RASMessageCatalog cat = new RASMessageCatalog("com.ibm.ras.server.RASLogServerMsgs");
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss:SSS");
    private Socket socket = null;

    public RASConnectionHandler(Socket socket, boolean bl, PrintWriter printWriter) {
        this.socket = socket;
        this.toFile = bl;
        this.pWriter = printWriter;
        String string = df.format(new Date());
        this.write(this.cat.getMessage("CONNECTION_OPENED", socket.getInetAddress().getHostName(), string));
    }

    public void run() {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }
        catch (Throwable throwable) {
            this.write(this.cat.getMessage("ERR_INPUT_STREAM"));
            this.write(throwable.getMessage());
            return;
        }
        try {
            while (true) {
                String string = null;
                string = bufferedReader.readLine();
                if (string == null) {
                    return;
                }
                this.write(string);
            }
        }
        catch (Throwable throwable) {
            String string = df.format(new Date());
            this.write(this.cat.getMessage("CONNECTION_CLOSED", this.socket.getInetAddress().getHostName(), string));
            this.write(throwable.getMessage());
            return;
        }
    }

    private void write(String string) {
        if (this.toFile) {
            this.pWriter.println(string);
        }
        System.out.println(string);
    }
}

