/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.am;

import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ejs.util.am.AlarmThreadPool;
import com.ibm.ejs.util.am._Alarm;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.BinaryHeap;

class AlarmManagerThread
implements Dumpable,
Runnable {
    private static final TraceComponent tc = Tr.register(AlarmManagerThread.class, null, null);
    protected boolean dumped = false;
    BinaryHeap alarmQ;
    boolean deferredAlarms = false;
    String alarmThreadPoolName;

    AlarmManagerThread(BinaryHeap binaryHeap, boolean bl) {
        Tr.registerDumpable(tc, this);
        this.alarmQ = binaryHeap;
        this.deferredAlarms = bl;
    }

    AlarmManagerThread(BinaryHeap binaryHeap, boolean bl, String string) {
        Tr.registerDumpable(tc, this);
        this.alarmQ = binaryHeap;
        this.deferredAlarms = bl;
        this.alarmThreadPoolName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        AlarmThreadPool alarmThreadPool = new AlarmThreadPool(this.alarmThreadPoolName);
        while (true) {
            try {
                while (true) {
                    _Alarm _Alarm2 = null;
                    BinaryHeap binaryHeap = this.alarmQ;
                    synchronized (binaryHeap) {
                        _Alarm2 = null;
                        if (this.alarmQ.isEmpty()) {
                            this.alarmQ.wait();
                        } else {
                            _Alarm2 = (_Alarm)this.alarmQ.minimum();
                            long l = _Alarm2.expirationTime - System.currentTimeMillis();
                            if (l <= 0L) {
                                this.alarmQ.deleteMin();
                                _Alarm2.fired = true;
                            } else {
                                _Alarm2 = null;
                                if (!this.deferredAlarms || AlarmManager.getActiveWork() > 0) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Alarm manager thread waiting", new Long(l));
                                    }
                                    this.alarmQ.wait(l);
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Alarm Manager waiting for next server work request");
                                    }
                                    this.alarmQ.wait();
                                }
                            }
                        }
                    }
                    if (_Alarm2 == null) continue;
                    alarmThreadPool.fireAlarm(_Alarm2);
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ejs.util.am.AlarmManagerThread.run", "121", this);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        if (this.dumped) {
            return;
        }
        try {
            Tr.dump(tc, "-- Alarm Manager Dump --");
            Tr.dump(tc, this.alarmQ.size() + " scheduled alarms");
            BinaryHeap binaryHeap = this.alarmQ;
            synchronized (binaryHeap) {
                Tr.dump(tc, "alarm queue contents", this.alarmQ.elements());
            }
        }
        finally {
            this.dumped = true;
        }
    }

    public void resetDump() {
        this.dumped = false;
    }
}

