/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*      VisualAge Generator Server for OS/2, AIX, HP-UX, and Windows NT      */
/*                          Version 3.0  5697-C28                            */
/*                    (C) COPYRIGHT IBM CORP. 1994,1997                      */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWKEYS_H
#define FCWKEYS_H

//-----------------------------------------------------------------------------
// Key class                                                                  -
//-----------------------------------------------------------------------------
// This class defines the key enumeration values that will be used to set or  -
// query keys.                                                                -
//-----------------------------------------------------------------------------
class Key
{
   public:
      enum enum_Key
      {
         None  = 0x00,
         PF1   = 0x31, PF2,  PF3,  PF4,  PF5,  PF6,  PF7,  PF8,  PF9,  PF10,
         PF11  = 0x23,
         PF12  = 0x40, PF13, PF14, PF15, PF16, PF17, PF18, PF19, PF20, PF21,
         PF22  = 0x5b,
         PF23  = 0x2e,
         PF24  = 0x3c,
         ENTER = 0x27,
         CLEAR = 0x5f,
         PA1   = 0x25,
         PA2   = 0x3e,
         PA3   = 0x2c
      };
};

//-----------------------------------------------------------------------------
// ByPassKeys class                                                           -
//-----------------------------------------------------------------------------
// The ByPassKeys class is used to store the map's bypass keys as well as to  -
// determine if the key pressed is a bypass key.                              -
//-----------------------------------------------------------------------------
struct ByPassKeys_Data;

class ByPassKeys
{
   public:
      ByPassKeys(ByPassKeys const &);
      ByPassKeys(Key::enum_Key  key1 = Key::None,
                 Key::enum_Key  key2 = Key::None,
                 Key::enum_Key  key3 = Key::None,
                 Key::enum_Key  key4 = Key::None,
                 Key::enum_Key  key5 = Key::None);
      ~ByPassKeys();

      Bool  isBypassKey(Key::enum_Key) const;
      Bool  any()                      const;
      void  operator=(ByPassKeys const &);

   private:
      #define  numkeys  5
      Key::enum_Key     keys[numkeys];
      void*             pData;
};

#endif
