package com.ibm.vap.RelationalPersistence;

/**
 *
 * Licensed Material - Property of IBM 
 * IBM(R) VisualAge(TM) for Java(TM) Version 2.0 
 * (C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 *
 */ 
import com.ibm.ivj.db.base.*;
import com.ibm.vap.Persistence.*;
import com.ibm.vap.Transactions.*;
import com.ibm.vap.RelationalPersistence.*;
import com.ibm.vap.RuntimeTools.Trace;
import com.ibm.vap.common.VapMethodInvocation;
import com.ibm.vap.common.ArrayVectorTransform;
import java.sql.*;
import java.util.*;
import javax.ejb.*;

public abstract class RelationalServiceObject extends ServiceObject implements RelationalServiceObjectIfc {
	private static java.util.ResourceBundle resobjectExtender = java.util.ResourceBundle.getBundle("objectExtender");  //$NON-NLS-1$
/**
 * This method was created by a SmartGuide.
 */
public RelationalServiceObject () {
	super();
}
/**
 * This method was created by a SmartGuide.
 * @param forHome COM.ibm.vap.Persistence.PersistentHomeCollection
 */
public RelationalServiceObject ( PersistentHomeCollection forHome) {
	super(forHome);
}
/**
 * 
 */
protected void allInstancesLoadCache(SqlQuery aQuery) 
{	
	ReadTransformer aReader;
	aReader = this.createDefaultReader(aQuery);
	aReader.setRootComplete();
	aReader.extract();
	this.resultsAddAll(aReader.oids());
}
/**
 * Clone the SO. 
 * 
 */
public Object clone( ) 
{
	return (RelationalServiceObject)super.clone();

}


public abstract RdbBOInjector createDefaultBOInjector(Object input);
/**
 * 
 */
public abstract ReadTransformer createDefaultReader(SqlQuery aQuery);
/**
 * Throw a runtime error.
 */
protected void errorNoKey( ) 
 {
 	String aString = resobjectExtender.getString("noInputKey"); //$NON-NLS-1$
 	this.getServiceResult().setToError();
 	throw new RuntimeException(aString);
	}
/**
 *  Throw a runtime error.
 */
protected void errorPrimaryKey( ) 
 {
 	String aString = resobjectExtender.getString("tooManyElements"); //$NON-NLS-1$
 	this.getServiceResult().setToError();
 	throw new RuntimeException(aString);
	}
/**
 * The generic all instances kind of query.  Subclasses must override to extend or 
 * alter the events.
 */
public void executeAllInstances() 
{
	Vector querySpecs = queryPool().allInstancesQuery();
	SqlQuery aQuery = new SqlQuery(querySpecs, getSession().getConnection());

	executeQuery(aQuery);
	if (!isError())
		allInstancesLoadCache(aQuery);
}
/**
 * This is used by custom queries.  This method will decide whether or not
 * to create an injector if arguments are used.
 * 
 */

public void executeCustomQuery(String aQueryName, Object[] args) {

	if ((args != null) && (args.length > 0))
		executeCustomQueryWithInjector(aQueryName, args);
	else
		executeCustomQueryWithoutInjector(aQueryName);

}
/**
 * This is used by custom queries for performing the locking query.  
 * This method will decide whether or not to create an injector if arguments are used.
 */
public  void executeCustomQueryLock(String aQueryName, Object[] args)
{
	if ((args != null) && (args.length > 0))
		executeCustomQueryLockWithInjector(aQueryName, args);
	else
		executeCustomQueryLockWithoutInjector(aQueryName);
}
/**
 * This is used by custom queries.
 * 
 */

private void executeCustomQueryLockWithInjector(String aQueryName, Object[] args) {

	String lockQueryName = getLockingQueryNameFor(aQueryName);
	Trace.show(">>>>executing locking query " + lockQueryName) ;
	Vector querySpecs = primExecuteCustomQueryWithInjector(lockQueryName, args);
	SqlQuery aQuery = new SqlQuery(querySpecs, getSession().getConnection());

	executeQuery(aQuery);
	
}

/**
 * This method is used by the custom query framework.  It will execute the locking
 * query necessary to lock the rows in the query aQueryName.  No injector is
 * built here.
 * 
 */
private void executeCustomQueryLockWithoutInjector(String aQueryName)
{
	String lockQueryName = getLockingQueryNameFor(aQueryName);
	Trace.show(">>>>executing locking query " + lockQueryName) ;
	Vector querySpecs = (Vector) VapMethodInvocation.performMethod(lockQueryName, queryPool());
	SqlQuery aQuery = new SqlQuery(querySpecs, getSession().getConnection());

	executeQuery(aQuery);
}
/**
 * This method is used by the custom query framework.  It will execute the query named
 * aQueryName.  An injector is built here.
 * 
 */

private void executeCustomQueryWithInjector(String aQueryName, Object[] args) {

	Trace.show(">>>>executing " + aQueryName) ;
	primExecuteCustomQuery(primExecuteCustomQueryWithInjector(aQueryName, args));
	
}

/**
 * This method is used by the custom query framework.  It will execute the query 
 * named aQueryName.  No injector is built here.
 * 
 */

private void executeCustomQueryWithoutInjector(String aQueryName) {

	
	Trace.show(">>>>executing " + aQueryName) ;
	Vector querySpecs = (Vector) VapMethodInvocation.performMethod(aQueryName, this.queryPool());
	primExecuteCustomQuery(querySpecs);
}

/**
 * Generic delete.  Override to alter behavior.
 */
public void executeDelete() 
{
	Enumeration e = getServiceInputs().elements();

		while (e.hasMoreElements())
	{
		executeOneDelete((EntityBean) e.nextElement());
		if (!continueService())
	   	return;
	}		
}
/**
 * The generic find by primary key query.  Subclasses must override to extend or 
 * alter the behavior.
 */


public void executeFindByKey() 
{
	RdbBOInjector anInjector = createDefaultBOInjector(getInputKey());
	Vector querySpecs = queryPool().findByKeyQuery(anInjector.getKeyData(), anInjector);
	SqlQuery aQuery = new SqlQuery(querySpecs, getSession().getConnection());
	executeQuery(aQuery);
	if (!isError())
		findByKeyExtraction(aQuery);
}
/**
 * Generic insert.  Override to alter behavior.
 */
public void executeInsert() {
	Enumeration e = getServiceInputs().elements();
	while (e.hasMoreElements()) {
		executeOneInsert((EntityBean) e.nextElement());
		if (!continueService()) return;
	}
}
/**
 * The generic lock all kind of query.  Subclasses must override to extend or 
 * alter the events.
 */
public  void executeLockAll( )
{
	Vector querySpecs = queryPool().lockQuery();
	SqlQuery aQuery = new SqlQuery(querySpecs, getSession().getConnection());

	executeQuery(aQuery);
}
/**
 * The generic delete query.  Subclasses must override to extend or 
 * alter the events.
 */

protected void executeOneDelete(EntityBean aBean) 
{
	RdbBOInjector anInjector = createDefaultBOInjector(createDOFromBean(aBean));
	Vector querySpecs = queryPool().deleteQuery(anInjector.dataForDelete(), anInjector);
	SqlQuery aQuery = new SqlQuery(querySpecs, getSession().getConnection());
	
	executeQuery(aQuery);
}
/**
 * The standard implementation of a single insert.  If subclasses need something
 * different, then they must override.
 */
protected void executeOneInsert(EntityBean aBean) {
	RowDataObject dataObject = (RowDataObject) this.createDOFromBean(aBean);
	RdbBOInjector anInjector = createDefaultBOInjector(dataObject);
	Vector querySpecs = queryPool().insertQuery(anInjector.getData(), anInjector);
	SqlQuery aQuery = new SqlQuery(querySpecs, getSession().getConnection());
	executeQuery(aQuery);
	if (!this.isError()) this.updatePredicateValues(aBean, dataObject);
}
/**
 * The standard implementation of a single lock.  If subclasses need something
 * different, then they must override.
 */
protected void executeOneSingleLock(EntityBean aBean) {
	RdbBOInjector anInjector = createDefaultBOInjector(createDOFromBean(aBean));
	Vector querySpecs = queryPool().singleLockQuery(anInjector.dataForSingleLock(), anInjector);
	SqlQuery aQuery = new SqlQuery(querySpecs, getSession().getConnection());
	executeQuery(aQuery);
}
/**
 * The standard implementation of a single insert.  If subclasses need something
 * different, then they must override.
 */
protected void executeOneUpdate(EntityBean aBean) 
{
	RowDataObject dataObject = (RowDataObject) this.createDOFromBean(aBean);
	RdbBOInjector anInjector = createDefaultBOInjector(dataObject);
	Vector querySpecs = queryPool().updateQuery(anInjector.dataForUpdate(), anInjector);
	SqlQuery aQuery = new SqlQuery(querySpecs, getSession().getConnection());
	executeQuery(aQuery);
	if (!this.isError()) this.updatePredicateValues(aBean, dataObject);
}
/**
 * Execute a query.
 */
protected void executeQuery(SqlQuery aQuery) {
	aQuery.execute();
	if (aQuery.isError()) {
		setToError();
		result().addAllError(aQuery.getErrors());
		Trace.show("there was an error during query execution");
		return;
	}
	else
		setToSuccess();
}
/**
 * The standard implementation of a single lock.  If subclasses need something
 * different, then they must override.
 */
public void executeSingleLock() {
	RdbBOInjector anInjector = createDefaultBOInjector(getInputKey());
	Vector querySpecs = queryPool().singleLockQuery(anInjector.dataForSingleLock(), anInjector);
	SqlQuery aQuery = new SqlQuery(querySpecs, getSession().getConnection());
	executeQuery(aQuery);
}
/**
 * Generic update.  Override to alter behavior.
 */
public void executeUpdate() {
	Enumeration e = getServiceInputs().elements();
	while (e.hasMoreElements()) {
		executeOneUpdate((EntityBean) e.nextElement());
		if (!continueService()) return;
	}
}
/**
 *
 */
protected void findByKeyExtraction(SqlQuery aQuery) 
{	
	ReadTransformer aReader;
	aReader = createDefaultReader(aQuery);
	Vector aVector;
	aReader.extractDOs();
	aVector = aReader.dataObjects();
	if (aVector.isEmpty())
		return;
	if (aVector.size() > 1)
		this.errorPrimaryKey();
	this.addResult(aVector.firstElement());
}
/**
 *
 */
protected void findByKeyLoadCache(SqlQuery aQuery) 
{	
	ReadTransformer aReader;
	aReader = this.createDefaultReader(aQuery);
	Vector aVector;
	aReader.extract();
	aVector = aReader.oids();
	if (aVector.isEmpty())
		return;
	if (aVector.size() > 1)
		this.errorPrimaryKey();
	this.addResult(this.getCache().getDO(((OID) aVector.firstElement()).getKey()));
}
/**
 * Answer the key for the find by key query.
 */
protected Object getInputKey() 
{
	if (getServiceInputs().isEmpty())
		this.errorNoKey();
	return (Object) getServiceInputs().firstElement();
}
/**
 * Return the name of the locking query that is called to lock the
 * rows from a query named aQueryName.  For example, if aQueryName is 'studentsOver21Query'
 * then the locking query will be 'studentsOver21QueryForLocking'.
 */
private String getLockingQueryNameFor(String aQueryName)
{
	return aQueryName + "ForLocking";
	
}
/**
 *  Cast magic.
 */
public SqlSession getSqlSession ( ) 
 {
 	return (SqlSession) getSession();
}
/**
 * Answer an array of values of the input key.
 */
protected Vector inputKeyValues() {
Object aKeyOrBO = this.getInputKey();
	if(aKeyOrBO instanceof Key)
		return this.createDefaultBOInjector((Key)aKeyOrBO).getKeyData();
	else
		return this.createDefaultBOInjector((VapEntityBean)aKeyOrBO).getKeyData();
}
/**
 * This is used by custom queries.
 * This method will perform the query and load the cache.
 */

private void primExecuteCustomQuery(Vector querySpecs) {

	SqlQuery aQuery = new SqlQuery(querySpecs, this.getSqlSession().getDbConnection());
	executeQuery(aQuery);
	if (!isError())
		allInstancesLoadCache(aQuery);
	setToCompleted();
}
/**
 * This is used by custom queries.
 * 
 */

private Vector primExecuteCustomQueryWithInjector(String aQueryName, Object[] args) {

	Vector v = ArrayVectorTransform.toVector(args);

	RdbBOInjector injector = this.createDefaultBOInjector(v);
	
	Object[] newArgs = new Object[2];
	newArgs[0] = injector.getSourceAsVector();
	newArgs[1] = injector;

	//create our own class types array for the newArgs using the superclass BOInjector
	Class[] argTypes = new Class[2];
	argTypes[0] = java.util.Vector.class;
	argTypes[1] = com.ibm.vap.Persistence.BOInjector.class;
	
	return (Vector) VapMethodInvocation.performMethod(aQueryName, queryPool(), newArgs, argTypes);
	
}

/**
 * 
 */
public abstract QueryPool queryPool();
/**
 * A bean has been updated in the database, refresh its predicate values
 */
protected void updatePredicateValues(EntityBean aBean, DataObject dataObject) {
	// Test for VAP Bean just to be sure, raw EntityBeans can't do this
	if (aBean instanceof VapEntityBean) {
		dataObject.setPredicateValuesIn((VapEntityBean) aBean);
	}
}
}