package com.ibm.vap.Transactions;

import java.util.Vector;
import java.beans.PropertyChangeListener ;
import java.awt.event.ActionListener;
import java.util.*;
/**
 * The Transaction signaller has the responsibility for handling events
 * for a Transaction
 */
public class TransactionSignaller {
	protected Transaction transaction ;
	protected Vector versions = new Vector(25) ;
	protected Vector collectionChangesSignallers = new Vector(10);
	protected Vector deferredMessages = new Vector(10);
	protected Vector listenerList = new Vector(5);
/**
 * TransactionSignaller constructor comment.
 * Store the backpointer to the transaction we are the signaller for
 */
public TransactionSignaller(Transaction aTransaction) {
	transaction = aTransaction ;
}
/* Add the argument to our collection of action listeners */
public void addActionListener(VapActionListener listener){
	listenerList.addElement(listener);
}
/* Add the arguments to our collection of versions
 * that we are batching up to signal later
 */
public void addDeferredMessage(VapDeferredMessage aMsg) {
	deferredMessages().addElement(aMsg) ;
}
/* Add the arguments to our collection of collectionChangesSignallers
 * that we are batching up to signal later
 */
public void addDeferredSignaller(CollectionChangesSignaller aSignaller) {
	collectionChangesSignallers().addElement(aSignaller) ;
}
/* Add the arguments to our collection of versions
 * that we are batching up to signal later
 */
public void addDeferredSignaller(Version aParentVersion) {
	versions().addElement( new ParentChildVersionPair(aParentVersion , aParentVersion.getBean()) ) ;
}
/* add the argument as a property change listener */

public void addPropertyChangeListener(PropertyChangeListener aListener){
}
/*
 * resume trans.
 */

protected Transaction cacheCurrentAndResumeTransaction() {

	Transaction current = Transaction.getCurrent();
	if (transaction != null)
		resumeTransaction(transaction);
	return current;

}
/* Iterate over the deferred messages and get them to evaluate.
 * 
 */

public void callDeferredMessages() {

	VapDeferredMessage nextMsg;
	Transaction current;
	
	if (deferredMessages != null) {
		Vector currentMessages = deferredMessages ;
		deferredMessages = null ;
		Enumeration e = currentMessages.elements();
		while (e.hasMoreElements()) {
			nextMsg = (VapDeferredMessage)e.nextElement();
			if (nextMsg.getReceiver().isNotVapRemoved()) {
				current = cacheCurrentAndResumeTransaction();
				nextMsg.send();
				resumeTransaction(current);
			}
		}
	
	}

}
/* Iterate over the deferred signallers and get them to publish their events.
 * Cache the versions and null out the versions so that when we are iterating over the vector
 * we do not have any versions which may go stale on us
 */

public void callDeferredSignallers() {

	
	if (versions != null) {
		Vector currentVersions = versions ;
		versions = null ;
		Enumeration e = currentVersions.elements();
		while (e.hasMoreElements())
			((ParentChildVersionPair)e.nextElement()).signalEvents();
	}

	if (collectionChangesSignallers != null) {
		Vector currentChanges = collectionChangesSignallers;
		collectionChangesSignallers = null;
		Enumeration e = currentChanges.elements();
		while (e.hasMoreElements()) 
			((CollectionChangesSignaller)e.nextElement()).signalEvents();
	}
}
/*
 * Notify all listeners that have registered interest for
 * notification on this event type.
 */
private Vector collectionChangesSignallers() {
	if ( collectionChangesSignallers == null ) 
		collectionChangesSignallers = new Vector(10);
	return collectionChangesSignallers ;
}
/*
 * Notify all listeners that have registered interest for
 * notification on this event type.
 */
private Vector deferredMessages() {
	if ( deferredMessages == null ) { deferredMessages = new Vector(10) ; } ;
	return deferredMessages ;
}
/*
 * Notify all listeners that have registered interest for
 * notification on this event type.
 */
protected void fireActionPerformed(VapEvent event) {
	// Send all of our listeners this event
	Enumeration e = listenerList.elements();
	while (e.hasMoreElements()) 
		((VapActionListener)e.nextElement()).actionPerformed(event);
}
/* Remove the argument from our collection of action listeners */
public void removeActionListener(VapActionListener listener){
	listenerList.removeElement(listener);
}
/* add the argument as a property change listener */

public void removePropertyChangeListener(PropertyChangeListener aListener){
}
/*
 * resume trans.
 */

protected void resumeTransaction(Transaction trans) {

	try {
		trans.resume();
	} catch (com.ibm.vap.common.VapTransactionRequiredException e) { }

}
/* Our transaction has been committed.
 * Signal the correct events to any interested parties */
public void signalHasBeenCommitted() {
	fireActionPerformed( new VapEvent(transaction , "committed" ));
	fireActionPerformed( new VapEvent(transaction , "committedOrRolledback" ));
}
/* Our transaction has been rolledback.
 * Signal the correct events to any interested parties */
public void signalHasBeenRolledback() {
	fireActionPerformed( new VapEvent(transaction , "rolledback" ));
	fireActionPerformed( new VapEvent(transaction , "committedOrRolledback" ));
}
/* Our transaction has been merged.
 * Signal the correct events to any interested parties */
public void signalMergedIntoEvent() {
	fireActionPerformed( new VapEvent(transaction , "mergedInto" ));
}
/* Our transaction has been committed.
 * This is the root of a commit and must be distinguished from secondary commits
 * that are part of a cascaded commit
 * Signal the correct events to any interested parties */
public void signalRootHasBeenCommitted() {
	signalHasBeenCommitted();
	fireActionPerformed( new VapEvent(transaction , "rootCommitted" ));
	fireActionPerformed( new VapEvent(transaction , "rootCommittedOrRolledback" , "committed" ));
}
/* Our transaction has been rolledback.
 * This is the root of a rollback and must be distinguished from secondary rollbacks
 * that are part of a cascaded commit
 * Signal the correct events to any interested parties */
public void signalRootHasBeenRolledback() {
	signalHasBeenRolledback();
	fireActionPerformed( new VapEvent(transaction , "rootRolledback" ));
	fireActionPerformed( new VapEvent(transaction , "rootCommittedOrRolledback" , "rolledback"));
}
/*
 * Notify all listeners that have registered interest for
 * notification on this event type.
 */
private Vector versions() {
	if ( versions == null ) { versions = new Vector(25) ; } ;
	return versions ;
}
}