package com.ibm.vap.Transactions;


/**
 * SingleLink
 *
 * Licensed Material - Property of IBM 
 * IBM(R) VisualAge(TM) for Java(TM) Version 2.0 
 * (C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 *
 */

import java.rmi.RemoteException;

public class SingleLink extends AbstractSingleLink
{
	private VapEJBObject source;
	private static final java.lang.String copyright  = "(c) Copyright International Business Machines Corporation, 1998";
/**
 * Create a properly initialized single link
 */
public SingleLink(VapEJBObject anEjbObject, Relationship aRelationship)
{
	super(aRelationship);
	this.setSource(anEjbObject);
}
/**
 * If we have a target then get the counter link for ourself in the target and 
 * forward the message there.	Use a prim method to stop recursion
 */
public void changeSignalledForTarget(VapEJBObject anEJBObject) throws RemoteException {

	if ((getTarget() != null) && (hasEjbObject())) {
		AbstractLink aCounterLink = getRelationship().getCounterLinkFor(getTarget());
		if (aCounterLink != null) 
			aCounterLink.primChangeSignalledForTarget(anEJBObject);
	}
}
/**
 * Answer my source business object
 */
public VapEJBObject getSource()
{
	return source; 
}
/**
 * Answer my value.  This is the API by which BO accessors provide
 * the target of the relationship. 
 */
public VapEJBObject getValue() throws RemoteException
{
	if (this.isNotHydrated())
		if (this.getRelationship().canQueryForLink(this))
		{
			this.connectToRetrieved (relationship.fetchTargetForLink(this));
			this.setHasQueried();
		}
		
	if (this.getTarget().isBusinessObject())
		return this.getTarget();
	else
		return null;
}
/**
 * Reconcile links between old version and new version after
 * refreshing from the database
 * @param anOldLink COM.ibm.vap.Transactions.SingleLink
 */
public void reconcileFromRetrievedWith (AbstractLink anOldLink)
{
	SingleLink oldLink;

	oldLink = (SingleLink) anOldLink;
	this.setSource(oldLink.getSource());

	if (this.getKey() != oldLink.getKey())
		try {
			oldLink.disconnectFromRetrieved(oldLink.getTarget());}
		catch (RemoteException e) {}
	else if (oldLink.isConnected())
	{
		this.setTarget(oldLink.getTarget());
		this.setHasQueried(oldLink.hasQueried());
	}
}
/**
 * Reconcile links between old version and new version after
 * refreshing from the database
 * @param anOldLink COM.ibm.vap.Transactions.SingleLink
 */
public void reconcileWith (AbstractLink anOldLink)
{
	SingleLink oldLink;

	oldLink = (SingleLink) anOldLink;
	this.setSource(oldLink.getSource());

	if (this.getKey() != oldLink.getKey())
		try {
			oldLink.disconnectFrom(oldLink.getTarget());}
		catch (RemoteException e) {}
	else if (oldLink.isConnected())
	{
		this.setTarget(oldLink.getTarget());
		this.setHasQueried(oldLink.hasQueried());
	}
}
/**
 * Set my source business object
 */
public void setSource(VapEJBObject anEjbObject)
{
	source = anEjbObject; 
}
}