package com.ibm.vap.Transactions;


/**
 *
 * Licensed Material - Property of IBM 
 * IBM(R) VisualAge(TM) for Java(TM) Version 2.0 
 * (C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 *
 */
import java.util.Enumeration;
import java.rmi.RemoteException;
import java.util.Vector;
import com.ibm.vap.Persistence.ServiceObject;
import com.ibm.vap.Persistence.ServiceResult;
import com.ibm.vap.Persistence.DataStore;
import com.ibm.vap.Persistence.PersistentHomeCollection;
import com.ibm.vap.Isolation.ObjectIsolationImplementor;
import com.ibm.vap.common.VapReadFailureException;
import com.ibm.vap.common.VapObjectLockedException;

public abstract class Relationship implements VapHome
{
	protected RelationshipCache relationshipCache;
	protected HomeCollection targetHome;
	protected boolean isPersistentRelationship;
	private static final java.lang.String copyright  = "(c) Copyright International Business Machines Corporation, 1998";
/**
 * Construct a Relationship, taking a target home instance, invoke initialize()
 */
public Relationship(HomeCollection target) {
	targetHome = target;
	initialize();
}
public void bePersistent() {
	isPersistentRelationship = true;
}
public void beUnpersistent() {
	isPersistentRelationship = false;
}
public boolean canQueryForLink(AbstractLink aLink) throws RemoteException
{
	return (this.getKeyForLink(aLink) != null && this.getKeyForLink(aLink).isComplete()) && isPersistentRelationship && aLink.getSource().isPersistent();
}
public void discardCache() {
	if (relationshipCache != null) relationshipCache.discardCache();
/*
	relationshipCache notNil
		ifTrue: [relationshipCache discard].
*/
}
/**
 * Get the correct key for the target of my relationship.  Then
 * go get it."
 */
public VapEJBObject fetchTargetForLink(AbstractLink aLink) throws RemoteException,VapObjectLockedException
{
	Key key;
	
	if (this.isForward())
	{
	  key = this.getForwardKeyForLink((AbstractSingleLink) aLink);
	  return this.objectForPrimaryKey(key);
	}
	else
	{
	  key = this.getBackwardKeyForLink(aLink);
	  return this.objectForForeignKey(key);
	}
}
/**
 * This is just a stub for testing.  Will need to 
 * be replaced when PersistentCollections are tested.
 */
public Vector fetchTargets() {
	return new Vector();
}
/**
 * 
 */
public Vector fetchTargetsForLink(AbstractLink aLink)  throws RemoteException,VapObjectLockedException
{
	return this.objectsForForeignKey(this.getBackwardKeyForLink(aLink));
}
/**
 * PRIVATE - Answer the backward referenceing key.  This
 * is always the sources key (OID?)
 */
protected Key getBackwardKeyForLink(AbstractLink aLink)
{
	Key key = null;
	
	try {key = (Key)aLink.getSource().getPrimaryKey();} catch (RemoteException e) {}

	return key;
}
/**
 * Answer the counter link or inverse link for my Link
 * Subclasses should override to retrieve the counter link value via
 * a known accessor.
 */
public AbstractLink getCounterLinkFor(VapEJBObject aBo) throws RemoteException
{
	return null;
}
/**
 * Answer the counter link or inverse link for my Link
 * The intention is to modify the counter, so if it is forwards then mark the BO modified.
 */
public AbstractLink getCounterLinkForUpdate(VapEJBObject aBo) throws RemoteException
{
	if (!this.isForward())
		aBo.getBom().markModified();

	return this.getCounterLinkFor(aBo);
}
/**
 * Answer the datastore
 */
public DataStore getDataStore()
{
	return targetHome.getDataStore();
}
/**
 * PRIVATE - Answer the forward referenceing key.  If the link is connected
	then key is taken from the connected BO.  Otherwise the key must come
	from the source object
 */
protected Key getForwardKeyForLink(AbstractSingleLink aLink)
{
	if (aLink.isConnected())
		try {return (Key)((AbstractSingleLink)aLink).getTarget().getPrimaryKey();
		} catch (RemoteException e) {}

	return this.primGetForwardKeyForLink(aLink);		
		
	/*
		^aLink isConnected
		ifTrue: [aLink target key]
		ifFalse: [self primGetForwardKeyForLink: aLink]
	*/
}
/**
 * 
 */
public ObjectIsolationImplementor getIsolationImplementorFor(VapEJBObject aBoShell)
{
	return this.getSourceFor(aBoShell).getBom().getIsolationImplementor();
/*
	^(self sourceFor: aBoShell) bom isolationImplementor
*/
}
/**
 * Answer my key
 */
public Key getKeyForLink(AbstractLink aLink)
{
	if (isForward())
		return this.getForwardKeyForLink((AbstractSingleLink) aLink);
	else
		return this.getBackwardKeyForLink(aLink);
}
public RelationshipCache getRelationshipCache(){
	return relationshipCache;
}
/**
 * Answer this since I am the root of the home hierarchy
 */
public VapHome getRootHome() {
	return this;
}
/**
 * Get the service object for our target home,
 * the implementer of the services to support this relationship.
 */
public ServiceObject getServiceObject()
{
	return ((PersistentHomeCollection)getTargetHome()).getServiceObject();
}
/**
 * This method was created by a SmartGuide.
 */
public VapEJBObject getSourceFor(LinkCollectionShell aShell)
{
	return aShell.getSourceLink().getSource();
}
/**
 * This method was created by a SmartGuide.
 */
public VapEJBObject getSourceFor(VapEJBObject aShell)
{
	return ((LinkCollectionShell)aShell).getSourceLink().getSource();
}
/**
 * Answer the target home
 */
public HomeCollection getTargetHome()
{
	return targetHome;
}
/**
* Aswer true if target has delete precedence
*/
protected boolean hasDeletePrecedence()
{
	return !this.isForward();
}
/**
* Aswer true if target has insert precedence
*/
protected boolean hasInsertPrecedence()
{
	return this.isForward();
}
/**
 * This method was created by a SmartGuide.
 * @return boolean
 */
public static boolean hasSingleton( ) {
	return false;
/*
	^singleton notNil
*/
}
/**
 * 
 */
protected void initialize()
{ 
	relationshipCache = new RelationshipCache();
	isPersistentRelationship = true;
}
/**
* Return whether or not an integrity constraint exists in the database
* which requires updates to this relationship to be ordered
*/
protected boolean isConstrained() {
	return false;
}
/*
 * Return a boolean to indicate whether this relationship is
 * a forward reference, holding a foreign key, or a backward
 * relationship which must be queried .
 * 
 */
protected abstract boolean isForward();
/**
 * This method was created by a SmartGuide.
 * @return vap.runtime.testClasses.BusinessObject.
 * "PRIVATE - Answer the single object which reference this key"
 */
protected VapEJBObject objectForForeignKey(Key aKey) throws RemoteException,VapObjectLockedException
{
	Vector bos = this.objectsForForeignKey(aKey);
	if (bos.size() != 1) 
		return null;
	return (VapEJBObject) bos.firstElement();
}
/**
 * @return vap.runtime.testClasses.BusinessObject.
 * "PRIVATE - Answer the object which has this key
 */
protected VapEJBObject objectForPrimaryKey(Key aKey) throws RemoteException,VapObjectLockedException
{
	try {
		return (VapEJBObject)this.getTargetHome().findByPrimaryKey(aKey);}
	catch (VapReadFailureException e) {
		return null;}
}
/**
 *	"PRVATE - Answer a collection of objects which reference this key"
 */
protected Vector objectsForForeignKey(Key aKey) throws  RemoteException,VapObjectLockedException
{
	Vector bos = new Vector();
	Key key;
	Enumeration targetKeys;

	if (!relationshipCache.includesSourceKey(aKey))
		this.retrieveTargetDOsFor(aKey);

	targetKeys = relationshipCache.targetKeysForSourceKey(aKey).elements();
	while (targetKeys.hasMoreElements())
	{
		key = (Key)targetKeys.nextElement();
		bos.addElement(this.objectForPrimaryKey(key));
	}

	return bos;	
}
/**
 * PRIVATE - Answer the forward referenceing key.  
 * Ask the source of the link via a specific key accessor.
 * Subclasses may override if they can extract the foreign
 * key from a data object.
 */
protected Key primGetForwardKeyForLink(AbstractSingleLink aLink)
{
	return aLink.primGetKey();
}
public static void releaseAll() {
	/**
	CarOwnerRelationship.release();
	DogMasterRelationship.release();
	ManCarsRelationship.release();
	ManCatRelationship.release();
	ManDogRelationship.release();
**/
}
/**
 * Reload a version for an ejb object
 */
public void reload(VapEJBObject anEjbObject) throws RemoteException,VapReadFailureException
{
}
/**
 * This method was created by a SmartGuide.
 */
public void reset ( ) {
	this.initialize();
	/*
	self initialize.
	*/
}
/**
 *	 This is the generated service used to force a query.
 * This will load the relationship cache
 */
protected abstract ServiceResult retrieveTargetDOsFor(Key anForeignKey);
/**
 * This method was created by a SmartGuide.
 * @return COM.ibm.vap.Transactions.HomeCollection
 */
public HomeCollection  rootHome ( ) {
	return null;
}
/**
 * This method was created by a SmartGuide.
 */
public void setTargetHome (HomeCollection aHome)
{
	targetHome = aHome;
}
}