package com.ibm.vap.Transactions;

/**
 * State of a transaction that is marked to be rolled back
 * 
 */

import java.rmi.RemoteException;
import com.ibm.vap.common.VapTransactionRequiredException;
import com.ibm.vap.common.VapTransactionFailureException;

public class MarkedRollbackTransactionState extends TransactionState
{
/**
 * Test if the transaction is marked to be rolled back
 */
protected boolean isMarkedRollback( )
{
	return true;
}
/**
 * Rollback a transaction
 */
protected void rollback(Transaction aTransaction) throws RemoteException, VapTransactionFailureException
{
	aTransaction.primRollback();
	aTransaction.setState(aTransaction.createRolledBackState());
	aTransaction.signalHasBeenRolledback();
}
/* Append the string MR" to the string */
public String toString(Transaction aTransaction) {
	return "(MR)" + super.toString(aTransaction) ;
}
}