package com.ibm.vap.Transactions;


/**
 * LinkCollection
 *
 * Licensed Material - Property of IBM 
 * IBM(R) VisualAge(TM) for Java(TM) Version 2.0 
 * (C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 *
 */
import java.rmi.RemoteException;
import java.util.*;
import javax.ejb.*;
import com.ibm.vap.common.VapObjectLockedException;

public class LinkCollection extends VersionDataWrapper implements Cloneable 
{
	protected boolean hasQueried = false;
	protected LinkCollectionChanges changedLinks;
	private static final java.lang.String copyright  = "(c) Copyright International Business Machines Corporation, 1998";
/**
 * Create a new LinkCollection
 */
public LinkCollection(LinkCollectionShell aShell)
{
	this.setShell(aShell);
	this.setData(new Vector());
}
/**
 * Answer newLink after adding newLink to the receiver.
 * Note that we don't bother to check and see if the object was previously removed in this
 * transaction. This is because, in order to make this invisible to our parent, we would have
 * to be able to add it back in the same position it came out of, which is hard to track. This
 * means that if we remove something and add it back, the parent will see both operations,
 * but with different indexes, reflecting the fact that the object has changed index
 */
public RootLink add(RootLink newLink) throws RemoteException
{
	this.getItems().addElement(newLink);
	this.changedLinks().added(newLink.getValue(), (LinkCollectionShell)getShell());
	return newLink;
}
/**
 * PRIVATE - Answer a new rootlink after adding it to elements
 */
public RootLink addNewLink( ) throws RemoteException
{
	RootLink link;

	link = this.createLink();
	((Vector)this.getData()).addElement(link);
	this.changedLinks().added(link.getValue(), (LinkCollectionShell)getShell());

	return link;
}
/**
 * Answer newObject having added newObject to the end of
 * receiver WITHOUT MARKING IT MODIFIED.
 */
public VapEJBObject addRetrieved(VapEJBObject anElement) throws RemoteException
{
	RootLink link;

	link = this.createLink();
	((Vector)this.getData()).addElement(link);
	link.connectToRetrieved(anElement);

	return anElement;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.Object
 */
public LinkCollectionChanges changedLinks() {
	
	if (changedLinks == null)
		changedLinks = new LinkCollectionChanges();
	return changedLinks;
}
/**
 * 
 */
public boolean contains(RootLink aLink) throws RemoteException
{
	return this.getItems().contains(aLink);
}
/**
 * Answer a clone of myself
 */
public LinkCollection createCopy() throws RemoteException
{
	LinkCollection newCollection;
	Enumeration links=null;
	Vector newLinks;
	RootLink link;

	if (!this.hasQueried())
		this.hydrate();

	newCollection = (LinkCollection)super.clone();
	newCollection.reset();

	newLinks = new Vector();
	links = ((Vector)this.getData()).elements();
	while (links.hasMoreElements())
	{
		link = (RootLink) links.nextElement();
		newLinks.addElement(link.copyLink());
	}

	newCollection.setItems(newLinks);
	newCollection.setHasQueried(this.hasQueried());

	return newCollection;
}
/**
 * Create a new element link
 */
public RootLink createLink( )
{
	return new RootLink(this.getSourceLink(),this.getRelationship());
}
/**
 * Answer the link at index anInteger.
 *
 *	 Fail if anInteger is not an Integer. Fail if anInteger is
 *	 < 1. Fail if anInteger exceeds the size of the receiver.
 */
public RootLink elementAt(int anInteger) throws RemoteException
{
	return (RootLink)this.getItems().elementAt(anInteger);
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.Object
 */
public RootLink firstElement() throws RemoteException
{
	return (RootLink)this.getItems().firstElement();
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.Object
 */
public Vector getItems() throws RemoteException
{
	if (!this.hasQueried())
		this.hydrate();

	return (Vector)this.getData();
}
/**
 * 
 */
public Key getKey()
{
	try {
		return (Key)this.getShell().getPrimaryKey();}
	catch (RemoteException e) {
		return null;}
}
/**
 * 
 */
public Relationship getRelationship( )
{
	return ((LinkCollectionShell)this.getShell()).getRelationship();
}
/**
 * 
 */
public ManyLink getSourceLink ( )
{
	return ((LinkCollectionShell)this.getShell()).getSourceLink();
/*
	^self shell manyLink
*/
}
/**
 * This method was created by a SmartGuide.
 * @return boolean
 */
public boolean hasNoChangedLinks() {
	
	return (changedLinks == null);
}
/**
 * Answer true if the collection has queried its elements
 */
public boolean hasQueried ( )
{
	return hasQueried;
}
/**
 * Query the database to load the cache.  Extract primary keys of
 * target objects, then check registry.  If the element was in the registry
 * then us that instance (discarding the new one).  Otherwise, use the new
 * one and add it to the registry. 
 */
protected void hydrate() throws RemoteException
{
	Vector targetObjects;
	Enumeration targets;

	if (this.relationshipCanQuery())
	{
		hasQueried = true;
		targetObjects = this.getRelationship().fetchTargetsForLink(this.getSourceLink());
		targets  = targetObjects.elements();
		while (targets.hasMoreElements())
			this.addRetrieved((VapEJBObject)targets.nextElement());
	}
}
/**
 * 
 */
public int indexOf(RootLink aLink) throws RemoteException
{
	return this.getItems().indexOf(aLink);
}
/**
 * Answer the link containing %oldObject.
 * If oldObject has no link in the receiver then answer 0.
 */
public int indexOf(VapEJBObject anObject) throws RemoteException
{
	int i;
	Enumeration elements;
	RootLink link;

	i = -1;
	elements = this.getItems().elements();
	while (elements.hasMoreElements())
	{
		i++;
		link = (RootLink)elements.nextElement();
		if (link.getValue() == anObject)
			return i;
	}

	return -1;	 
}
/**
 * Answer  true if the receiver contains
 * no elements
 */
public boolean isEmpty ( ) throws RemoteException
{
	return this.getItems().isEmpty();
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.Object
 */
public RootLink lastElement() throws RemoteException
{
	return (RootLink) this.getItems().lastElement();
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.Object
 */
public Vector links() throws RemoteException
{
	return (Vector)this.getItems();
}
/**
 * Record the fact that the argument has modified itself
 */
public void modified(Object anObject) throws RemoteException {
	
	changedLinks().modified(anObject, (LinkCollectionShell)getShell());
}
/**
 * Answer  true if the receiver contains
 * elements
 */
public boolean notEmpty( ) throws RemoteException
{
	return !this.isEmpty();
}
/**
 * 
 */
protected void originalParentLinkChanges(LinkCollectionChanges changes) {
	
	if (hasNoChangedLinks() || (changes == null))
		return;

	changedLinks.merge(changes);
}
/**
 * For link collections if our old version is in the same transaction as our new version
 * then we are going between things like a read only version to an update version.
 * We should try and copy forward any recorded changes to our old version into the new version.
 * If we are not at the same transaction then the version is being copied for the purposes
 * of populating the version data of a child transaction and we should NOT copy our data changes
 * down
 */
protected void postInitializeFrom(Version anOldVersion, Version aNewVersion) {

	if (anOldVersion.getView() == aNewVersion.getView())
		primChangedLinks(((LinkCollection)anOldVersion.getBean()).primChangedLinks());
}
		
/**
 * Return the changed links without any lazy initialization
 */
protected LinkCollectionChanges primChangedLinks() {

	return changedLinks();
}
		
/**
 * Set the changed links
 */
protected void primChangedLinks(LinkCollectionChanges changes) {

	changedLinks = changes;
}
		
/**
 * Answer  true if the receiver contains
 * no elements. Does not hydrate the collection
 */
public boolean primIsEmpty( ) 
{
	return ((Vector)this.getData()).isEmpty();
}
/**
 * 
 */
public boolean relationshipCanQuery ( ) throws java.rmi.RemoteException
{
	return this.getRelationship().canQueryForLink(this.getSourceLink());
/*
	^self relationship canQueryForLink: self manyLink
*/
}
/**
 * Answer the link at index anInteger within the receiver after having removed it.
 */
public RootLink removeAtIndex(int index) throws RemoteException
{
	RootLink link;

	link = (RootLink)this.getItems().elementAt(index);
	this.getItems().removeElementAt(index);
	this.changedLinks().removed(link.getValue(), index, (LinkCollectionShell)getShell());
	return link;
}
/**
 * 
 */
public void reset( )
{
	return;
}
/**
 * 
 */
public void resetChangedLinks() {
	
	changedLinks = null;
}
/**
 * 
 */
public void setHasQueried(boolean aBoolean)
{
	hasQueried = aBoolean;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.Object
 */
public void setItems(Vector theItems)
{
	this.setData(theItems);
}
/**
 * Do nothing
 */
protected void signalEvents(Version aVersion) {

}
		
/**
 * Answer my size
 */
public int size ( ) throws RemoteException
{
	return this.getItems().size();
}
}