/* peek utility for use with the Smalltalk AbxProcessPeekApp application.
 * Compile with the command: cc -o peek peek.c.
 */

#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/errno.h>

#define DEFAULT_PORT 7172

void printUsage() {
  printf("usage: peek [-p portnum] filename\n"); }

int getPortNum(char *argv[]) {

  int port;

  if (strcmp(argv[1], "-p") !=0) {
    printf("Invalid option: %s\n", argv[1]);
    return -1; }

  port = atoi(argv[2]);
  if (port < 1) {
    printf("Invalid port given\n");
    return -1; }

  return port; }

int sendPeekRequest(int port, char* fileName) {

  int sockfd;
  struct sockaddr_in servaddr;

  if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
    printf("socket error: %d\n", errno);
    return -1; }

  memset(&servaddr, 0, sizeof(servaddr));
  servaddr.sin_family = AF_INET;
  servaddr.sin_port = htons(port);
  if (inet_addr(AF_INET, "127.0.0.1", &servaddr.sin_addr) < 0) {
    printf("inet_addr error: %d\n", errno);
    return -1; }

  if (connect(sockfd, (struct sockaddr *) &servaddr, sizeof(servaddr)) < 0) {
    printf("connect error: %d\n", errno);
    return -1; }

  if (write(sockfd, fileName, strlen(fileName)) < 0) {
    printf("send error: %d\n", errno);
    close(sockfd);
    return -1; }

  close(sockfd);
  return 0; }

void main(int argc, char *argv[]) {
  int port;
  char *fileName;
  int i;

  if ((argc != 2) & (argc != 4)) {
    printUsage();
    exit(1); }

  if (argc == 4)
    port = getPortNum(argv);
  else
    port = DEFAULT_PORT;

  if (port == -1) {
    printUsage();
    exit(1); }

  fileName = argv[argc - 1];

  if (sendPeekRequest(port, fileName) < 0)
    printf("Unable to send request to port: %d, filename: %s\n", port, fileName);
  else
    printf("Sent request to port: %d, filename: %s\n", port, fileName);
}

