package com.ibm.ulc.ui.lists;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
/**
 * PendingNode is a placeholder for TreeModel nodes.
 * It is inserted into the model when any node is expanded, 
 * and the UI is waiting for the reply from the ULC side.
 * It also need to know it's parent since the lazy-rendering
 * process needs this.
 */
import com.ibm.ulc.util.UlcHashtable;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.util.UlcObject;
public class UiInvalidRow extends UlcObject implements IRow {
	private static UiInvalidRow fInstance = new UiInvalidRow();
/**
 * answer the receiver's object identifier (oid)
 */
public IRow asNonPendingRow(UiItemCache cache, int oid) {
	UiRow answer = new UiRow(oid);
	return answer;
}
/**
 * answer the receiver's object identifier (oid)
 */
public void cancelInput(UiItemCache cache) {
}
/**
 * answer the receiver's object identifier (oid)
 */
public void changedAttributes(String[] attributeNames) {
	if (attributeNames.length == 0)
		resetValues();
	else {
		for (int i = 0; i < attributeNames.length; i++)
			resetValue(attributeNames[i]);
	}
}
/**
 * answer the value of the receiver's attribute called attributeName. 
 * Answer null, if the attribute is not defined
 *
 * @param attributeName		the attribute requested is named this
 */
public Object getExistingValueAt(String attributeName, UiItemCache cache) {
	return com.ibm.ulc.ui.base.InvalidCell.theInvalidCell();
}
/**
 * answer the defined instance of the receiver.
 */
static protected UiInvalidRow getInstance() {
	return fInstance;
}
/**
 * answer the receiver's object identifier (oid)
 */
public int getOid() {
	return -1;
}
/**
 * answer the value of the receiver's attribute called attributeName. 
 * Answer null, if the attribute is not defined
 *
 * @param attributeName		the attribute requested is named this
 */
public Object getValueAt(String attributeName, UiItemCache cache) {

	return com.ibm.ulc.ui.base.InvalidCell.theInvalidCell();
	
}
public boolean hasUnsavedChanges() {
	return false;
}
/**
 * answer true, if the receiver's value for @atttributeName is equal to value
 *
 */
public boolean isValue(String attributeName, Object value) {
	return false;
}
public void prepareChanges(UITableModel model, Anything rowIds, Anything changes) {
}
/**
 * the receiver is about to be replaced by <code>anotherRow</code>. update it if required
 *
 * @param anotherRow the row about to replace the receiver
 */
protected void resetValue(String attributeName) {
}
public void resetValues() {
}
/**
 * answer the receiver's object identifier (oid)
 */
public void resetValues(String[] attributeNames) {
	for (int i = 1; i < attributeNames.length; i++) {
		resetValue(attributeNames[i]);
	}
}
/**
 * answer the receiver's object identifier (oid)
 */
public void resetValues(UiItemCache cache) {
}
/**
 * answer the receiver's object identifier (oid)
 */
public void saveInput(UiItemCache cache) {
}
/**
 * Set the data directly without trashing the edit cache.
 */
public void setData(UITableModel tableModel, Anything attributeName, Anything attributeValues) {
}
/**
 * set the value of the receiver's attribute called <code>attributeName</code> to <code>value</code>
 *
 * @param attributeName		the attribute to be set is named this
 * @param value				the value of the attribute
 */
public boolean setInput(UiItemCache cache, String attributeName, Object value) {
	return false;
}
/**
 * set the value of the receiver's attribute called <code>attributeName</code> to <code>value</code>
 *
 * @param attributeName		the attribute to be set is named this
 * @param value				the value of the attribute
 */
public void setValue(UiItemCache cache, String attributeName, Object value) {
}
/**
 * the receiver is about to be replaced by <code>anotherRow</code>. update it if required
 *
 * @param anotherRow the row about to replace the receiver
 */
public void startEditing(UiItemCache cache) {
}
/**
 * the receiver is about to be replaced by <code>anotherRow</code>. update it if required
 *
 * @param anotherRow the row about to replace the receiver
 */
public void updateData(UiItemCache cache, UlcHashtable data) {
}
}
